COMMENT

   **************************************************
   File generated by: neuroConstruct v1.3.8 
   **************************************************

   This file holds the implementation in NEURON of the Cell Mechanism:
   LeakConductance (Type: Channel mechanism, Model: Template based ChannelML file)

   with parameters: 
   /channelml/@units = Physiological Units 
   /channelml/notes = ChannelML file containing a single Channel description 
   /channelml/ion/@name = non_specific 
   /channelml/ion/@charge = 1 
   /channelml/ion/@default_erev = -65.00 
   /channelml/channel_type/@name = LeakConductance 
   /channelml/channel_type/@density = yes 
   /channelml/channel_type/status/@value = stable 
   /channelml/channel_type/notes = Simple example of a leak/passive conductance. Note: for GENESIS cells with a single leak conductance,         it is better to use the Rm and Em variab ... 
   /channelml/channel_type/current_voltage_relation/ohmic/@ion = non_specific 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/@default_gmax = 0.3 

// File from which this was generated: /home/Simon/nC_projects/Rat_Mitral_Cell_Gap_Network_copy4/cellMechanisms/LeakConductance/LeakConductance.xml

// XSL file with mapping to simulator: /home/Simon/nC_projects/Rat_Mitral_Cell_Gap_Network_copy4/cellMechanisms/LeakConductance/ChannelML_v1.8.0_NEURONmod.xsl

ENDCOMMENT


?  This is a NEURON mod file generated from a ChannelML file

?  Unit system of original ChannelML file: Physiological Units

COMMENT
    ChannelML file containing a single Channel description
ENDCOMMENT

TITLE Channel: LeakConductance

COMMENT
    Simple example of a leak/passive conductance. Note: for GENESIS cells with a single leak conductance,
        it is better to use the Rm and Em variables for a passive current.
ENDCOMMENT


UNITS {
    (mA) = (milliamp)
    (mV) = (millivolt)
    (S) = (siemens)
    (um) = (micrometer)
    (molar) = (1/liter)
    (mM) = (millimolar)
    (l) = (liter)
}


    
NEURON {
      

    SUFFIX LeakConductance
    ? A non specific current is present
    RANGE e
    NONSPECIFIC_CURRENT i
    
    RANGE gmax, gion
    
}

PARAMETER { 
      

    gmax = 0.0003 (S/cm2) ? default value, should be overwritten when conductance placed on cell
    
    e = -65.00 (mV) ? default value, should be overwritten when conductance placed on cell
    
}



ASSIGNED {
      

    v (mV)
        
    i (mA/cm2)
        
}

BREAKPOINT { 
    i = gmax*(v - e) 
        

}


