COMMENT

   **************************************************
   File generated by: neuroConstruct v1.3.8 
   **************************************************

   This file holds the implementation in NEURON of the Cell Mechanism:
   NaxSH10_ChannelML (Type: Channel mechanism, Model: ChannelML based process)

   with parameters: 
   /channelml/@units = Physiological Units 
   /channelml/notes = ChannelML file containing a single Channel description 
   /channelml/ion/@name = na 
   /channelml/ion/@charge = 1 
   /channelml/ion/@default_erev = 50 
   /channelml/channel_type/@name = NaxSH10_ChannelML 
   /channelml/channel_type/@density = yes 
   /channelml/channel_type/status/@value = stable 
   /channelml/channel_type/status/comment = Agreement of generated NEURON and GENESIS to original NEURON mod. Compared voltage and n traces on single comp with current pulse 
   /channelml/channel_type/status/contributor/name = Padraig Gleeson 
   /channelml/channel_type/notes = ... 
   /channelml/channel_type/authorList/modelTranslator/name = Padraig Gleeson 
   /channelml/channel_type/authorList/modelTranslator/institution = UCL 
   /channelml/channel_type/authorList/modelTranslator/email = p.gleeson - at - ucl.ac.uk 
   /channelml/channel_type/current_voltage_relation/ohmic/@ion = na 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/@default_gmax = 120 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/rate_adjustments/q10_settings/@q10_factor = 2 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/rate_adjustments/q10_settings/@experimental_temp = 24 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[1]/@power = 3 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[1]/state/@name = m 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[1]/state/@fraction = 1 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[2]/@power = 1 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[2]/state/@name = h 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[2]/state/@fraction = 1 
   /channelml/channel_type/hh_gate[1]/@state = m 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/@type = linoid 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/@expr = A*(k*(v-d))/(1 - exp(-(k*(v-d)))) 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[1]/@value = 2.880000018 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[2]/@value = 0.1388888888 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[3]/@value = -20 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/@type = linoid 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/@expr = A*(k*(v-d))/(1 - exp(-(k*(v-d)))) 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[1]/@value = 0.892800005 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[2]/@value = -0.1388888888 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[3]/@value = -20 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/tau/generic_equation_hh/@expr = 1/( (alpha + beta) * temp_adj_m ) &lt; 0.02 ? (0.02 * temp_adj_m) : 1/(alpha + beta)   
   /channelml/channel_type/hh_gate[2]/@state = h 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/@type = linoid 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/@expr = A*(k*(v-d))/(1 - exp(-(k*(v-d)))) 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[1]/@value = 0.045 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[2]/@value = 0.6666666667 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[3]/@value = -35 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/@type = linoid 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/@expr = A*(k*(v-d))/(1 - exp(-(k*(v-d)))) 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[1]/@value = 0.015 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[2]/@value = -0.6666666667 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[3]/@value = -35 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/tau/generic_equation_hh/@expr = 1/( (alpha + beta) * temp_adj_h ) &lt; 0.5 ? (0.5 * temp_adj_h) : 1/(alpha + beta)   
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/@type = sigmoid 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/@expr = A/(1 + exp(k*(v-d))) 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/parameter[1]/@value = 1 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/parameter[2]/@value = 0.25 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/parameter[3]/@value = -40 
   /channelml/channel_type/impl_prefs/table_settings/@max_v = 100 
   /channelml/channel_type/impl_prefs/table_settings/@min_v = -100 
   /channelml/channel_type/impl_prefs/table_settings/@table_divisions = 2000 

// File from which this was generated: /home/Simon/nC_projects/Rat_Mitral_Cell_Gap_Network_copy4/cellMechanisms/NaxSH10_ChannelML/NaChannel.xml

// XSL file with mapping to simulator: /home/Simon/nC_projects/Rat_Mitral_Cell_Gap_Network_copy4/cellMechanisms/NaxSH10_ChannelML/ChannelML_v1.8.0_NEURONmod.xsl

ENDCOMMENT


?  This is a NEURON mod file generated from a ChannelML file

?  Unit system of original ChannelML file: Physiological Units

COMMENT
    ChannelML file containing a single Channel description
ENDCOMMENT

TITLE Channel: NaxSH10_ChannelML

COMMENT
    ...
ENDCOMMENT


UNITS {
    (mA) = (milliamp)
    (mV) = (millivolt)
    (S) = (siemens)
    (um) = (micrometer)
    (molar) = (1/liter)
    (mM) = (millimolar)
    (l) = (liter)
}


    
NEURON {
      

    SUFFIX NaxSH10_ChannelML
    USEION na READ ena WRITE ina VALENCE 1 ? reversal potential of ion is read, outgoing current is written
            
    RANGE gmax, gion
    
    RANGE minf, mtau
    RANGE hinf, htau
}

PARAMETER { 
      

    gmax = 0.12 (S/cm2) ? default value, should be overwritten when conductance placed on cell
    
}



ASSIGNED {
      

    v (mV)
    
    celsius (degC)
    
    ? Reversal potential of na
    ena (mV)
    ? The outward flow of ion: na calculated by rate equations...
    ina (mA/cm2)
            
    
    gion (S/cm2)
    minf
    mtau (ms)
    hinf
    htau (ms)
    
}

BREAKPOINT { 
                        
    SOLVE states METHOD cnexp
         

    gion = gmax*((1*m)^3)*((1*h)^1)
    ina = gion*(v - ena)
                

}



INITIAL {
    ena = 50
        
    rates(v)
    m = minf
                
        
    h = hinf
                
        
    
    
}
    
STATE {
    m
    h
    
}

DERIVATIVE states {
    rates(v)
    m' = (minf - m)/mtau
    h' = (hinf - h)/htau
    
}

PROCEDURE rates(v(mV)) {  
    
    ? Note: not all of these may be used, depending on the form of rate equations
    LOCAL  alpha, beta, tau, inf, gamma, zeta, temp_adj_m, A_alpha_m, k_alpha_m, d_alpha_m, A_beta_m, k_beta_m, d_beta_m, A_tau_m, k_tau_m, d_tau_m, temp_adj_h, A_alpha_h, k_alpha_h, d_alpha_h, A_beta_h, k_beta_h, d_beta_h, A_tau_h, k_tau_h, d_tau_h, A_inf_h, k_inf_h, d_inf_h
        
    TABLE minf, mtau,hinf, htau
 DEPEND celsius
 FROM -100 TO 100 WITH 2000
    
    
    UNITSOFF
    
    ? There is a Q10 factor which will alter the tau of the gates 
                 

    temp_adj_m = 2^((celsius - 24)/10)     

    temp_adj_h = 2^((celsius - 24)/10)
        
    ?      ***  Adding rate equations for gate: m  ***
        
    ? Found a parameterised form of rate equation for alpha, using expression: A*(k*(v-d)) / (1 - exp(-(k*(v-d))))
    A_alpha_m = 2.880000018
    k_alpha_m = 0.1388888888
    d_alpha_m = -20
     
    
    alpha = A_alpha_m * vtrap((v - d_alpha_m), (1/k_alpha_m))
    
    
    ? Found a parameterised form of rate equation for beta, using expression: A*(k*(v-d)) / (1 - exp(-(k*(v-d))))
    A_beta_m = 0.892800005
    k_beta_m = -0.1388888888
    d_beta_m = -20
     
    
    beta = A_beta_m * vtrap((v - d_beta_m), (1/k_beta_m))
    
         

    ? Found a generic form of the rate equation for tau, using expression: 1/( (alpha + beta) * temp_adj_m ) < 0.02 ? (0.02 * temp_adj_m) : 1/(alpha + beta)  
                    
    
    if (1/( (alpha + beta) * temp_adj_m ) < 0.02 ) {
        tau =  (0.02 * temp_adj_m) 
    } else {
        tau =  1/(alpha + beta)  
    }
    mtau = tau/temp_adj_m
    minf = alpha/(alpha + beta)
          
       
    
    ?     *** Finished rate equations for gate: m ***
    
        
        
    ?      ***  Adding rate equations for gate: h  ***
        
    ? Found a parameterised form of rate equation for alpha, using expression: A*(k*(v-d)) / (1 - exp(-(k*(v-d))))
    A_alpha_h = 0.045
    k_alpha_h = 0.6666666667
    d_alpha_h = -35
     
    
    alpha = A_alpha_h * vtrap((v - d_alpha_h), (1/k_alpha_h))
    
    
    ? Found a parameterised form of rate equation for beta, using expression: A*(k*(v-d)) / (1 - exp(-(k*(v-d))))
    A_beta_h = 0.015
    k_beta_h = -0.6666666667
    d_beta_h = -35
     
    
    beta = A_beta_h * vtrap((v - d_beta_h), (1/k_beta_h))
    
         

    ? Found a generic form of the rate equation for tau, using expression: 1/( (alpha + beta) * temp_adj_h ) < 0.5 ? (0.5 * temp_adj_h) : 1/(alpha + beta)  
                    
    
    if (1/( (alpha + beta) * temp_adj_h ) < 0.5 ) {
        tau =  (0.5 * temp_adj_h) 
    } else {
        tau =  1/(alpha + beta)  
    }
    htau = tau/temp_adj_h
    
    ? Found a parameterised form of rate equation for inf, using expression: A / (1 + exp(k*(v-d)))
    A_inf_h = 1
    k_inf_h = 0.25
    d_inf_h = -40
     
    
    inf = A_inf_h / (exp((v - d_inf_h) * k_inf_h) + 1)
    
    hinf = inf
          
       
    
    ?     *** Finished rate equations for gate: h ***
    
             

}


? Function to assist with parameterised expressions of type linoid/exp_linear

FUNCTION vtrap(VminV0, B) {
    if (fabs(VminV0/B) < 1e-6) {
    vtrap = (1 + VminV0/B/2)
}else{
    vtrap = (VminV0 / B) /(1 - exp((-1 *VminV0)/B))
    }
}

UNITSON


