COMMENT

   **************************************************
   File generated by: neuroConstruct v1.3.8 
   **************************************************

   This file holds the implementation in NEURON of the Cell Mechanism:
   KA_ChannelML (Type: Channel mechanism, Model: ChannelML based process)

   with parameters: 
   /channelml/@units = Physiological Units 
   /channelml/notes = K-A current for Mitral Cells from Wang et al (1996) M.Migliore Jan. 2002     Note, the values used here are based on the Neuron Mod scripts accompanyi ... 
   /channelml/ion/@name = k 
   /channelml/ion/@charge = 1 
   /channelml/ion/@default_erev = -90 
   /channelml/channel_type/@name = KA_ChannelML 
   /channelml/channel_type/@density = yes 
   /channelml/channel_type/notes = A-type K channel, with rate equations expressed in tau and inf form 
   /channelml/channel_type/authorList/modelTranslator/name = Simon O'Connor 
   /channelml/channel_type/authorList/modelTranslator/institution = University of Cardiff 
   /channelml/channel_type/authorList/modelTranslator/email = simon.oconnor@btinternet.com 
   /channelml/channel_type/publication/fullTitle = Migliore, M., Hines, M.L., Shepherd, G.M. The Role of Distal Dendritic Gap Junctions in Synchronization of Mitral Cell Axonal Output J.Comput. Neurosc ... 
   /channelml/channel_type/publication/pubmedRef = http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&amp;db=pubmed&amp;dopt=Abstract&amp;list_uids=15714267 
   /channelml/channel_type/neuronDBref/modelName = K channels 
   /channelml/channel_type/neuronDBref/uri = http://senselab.med.yale.edu/senselab/NeuronDB/channelGene2.htm#table3 
   /channelml/channel_type/current_voltage_relation/ohmic/@ion = k 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/@default_gmax = 2 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/rate_adjustments/q10_settings/@q10_factor = 3 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/rate_adjustments/q10_settings/@experimental_temp = 24 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/rate_adjustments/offset/@value = 0 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[1]/@power = 1 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[1]/state/@name = m 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[1]/state/@fraction = 1 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[2]/@power = 1 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[2]/state/@name = h 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[2]/state/@fraction = 1 
   /channelml/channel_type/hh_gate[1]/@state = m 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/@type = exponential 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/@expr = A*exp(k*(v-d)) 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[1]/@value = 1 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[2]/@value = 0.1 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[3]/@value = -45 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/@type = exponential 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/@expr = A*exp(k*(v-d)) 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[1]/@value = 1 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[2]/@value = 0.075 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[3]/@value = -45 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/tau/generic_equation_hh/@expr = beta / (0.04 *(1+alpha)) 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/inf/parameterised_hh/@type = sigmoid 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/inf/parameterised_hh/@expr = A/(1 + exp(k*(v-d))) 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/inf/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/inf/parameterised_hh/parameter[1]/@value = 1 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/inf/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/inf/parameterised_hh/parameter[2]/@value = -(0.071428571) 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/inf/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/inf/parameterised_hh/parameter[3]/@value = 17.5 
   /channelml/channel_type/hh_gate[2]/@state = h 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/@type = exponential 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/@expr = A*exp(k*(v-d)) 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[1]/@value = 1 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[2]/@value = 0.2 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[3]/@value = -70 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/@type = exponential 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/@expr = A*exp(k*(v-d)) 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[1]/@value = 1 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[2]/@value = 0.198 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[3]/@value = -70 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/tau/generic_equation_hh/@expr = beta / (0.018 *(1+alpha)) 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/@type = sigmoid 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/@expr = A/(1 + exp(k*(v-d))) 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/parameter[1]/@value = 1 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/parameter[2]/@value = (0.166666666) 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/inf/parameterised_hh/parameter[3]/@value = -41.7 

// File from which this was generated: /home/Simon/nC_projects/Rat_Mitral_Cell_Gap_Network_copy4/cellMechanisms/KA_ChannelML/KA_Chan.xml

// XSL file with mapping to simulator: /home/Simon/nC_projects/Rat_Mitral_Cell_Gap_Network_copy4/cellMechanisms/KA_ChannelML/ChannelML_v1.8.0_NEURONmod.xsl

ENDCOMMENT


?  This is a NEURON mod file generated from a ChannelML file

?  Unit system of original ChannelML file: Physiological Units

COMMENT
    K-A current for Mitral Cells from Wang et al (1996) M.Migliore Jan. 2002
    Note, the values used here are based on the Neuron Mod scripts accompanying Migliore et al (2005)
ENDCOMMENT

TITLE Channel: KA_ChannelML

COMMENT
    A-type K channel, with rate equations expressed in tau and inf form
ENDCOMMENT


UNITS {
    (mA) = (milliamp)
    (mV) = (millivolt)
    (S) = (siemens)
    (um) = (micrometer)
    (molar) = (1/liter)
    (mM) = (millimolar)
    (l) = (liter)
}


    
NEURON {
      

    SUFFIX KA_ChannelML
    USEION k READ ek WRITE ik VALENCE 1 ? reversal potential of ion is read, outgoing current is written
            
    RANGE gmax, gion
    
    RANGE minf, mtau
    RANGE hinf, htau
}

PARAMETER { 
      

    gmax = 0.0020 (S/cm2) ? default value, should be overwritten when conductance placed on cell
    
}



ASSIGNED {
      

    v (mV)
    
    celsius (degC)
    
    ? Reversal potential of k
    ek (mV)
    ? The outward flow of ion: k calculated by rate equations...
    ik (mA/cm2)
            
    
    gion (S/cm2)
    minf
    mtau (ms)
    hinf
    htau (ms)
    
}

BREAKPOINT { 
                        
    SOLVE states METHOD cnexp
         

    gion = gmax*((1*m)^1)*((1*h)^1)
    ik = gion*(v - ek)
                

}



INITIAL {
    ek = -90
        
    rates(v)
    m = minf
                
        
    h = hinf
                
        
    
    
}
    
STATE {
    m
    h
    
}

DERIVATIVE states {
    rates(v)
    m' = (minf - m)/mtau
    h' = (hinf - h)/htau
    
}

PROCEDURE rates(v(mV)) {  
    
    ? Note: not all of these may be used, depending on the form of rate equations
    LOCAL  alpha, beta, tau, inf, gamma, zeta, temp_adj_m, A_alpha_m, k_alpha_m, d_alpha_m, A_beta_m, k_beta_m, d_beta_m, A_tau_m, k_tau_m, d_tau_m, A_inf_m, k_inf_m, d_inf_m, temp_adj_h, A_alpha_h, k_alpha_h, d_alpha_h, A_beta_h, k_beta_h, d_beta_h, A_tau_h, k_tau_h, d_tau_h, A_inf_h, k_inf_h, d_inf_h
        
    TABLE minf, mtau,hinf, htau
 DEPEND celsius
 FROM -100 TO 100 WITH 400
    
    
    UNITSOFF
    
    ? There is a Q10 factor which will alter the tau of the gates 
                 

    temp_adj_m = 3^((celsius - 24)/10)     

    temp_adj_h = 3^((celsius - 24)/10)
    
    ? There is a voltage offset of 0. This will shift the dependency of the rate equations 
    v = v - (0)
    
        
    ?      ***  Adding rate equations for gate: m  ***
        
    ? Found a parameterised form of rate equation for alpha, using expression: A*exp(k*(v-d))
    A_alpha_m = 1
    k_alpha_m = 0.1
    d_alpha_m = -45
     
    
    alpha = A_alpha_m * exp((v - d_alpha_m) * k_alpha_m)
    
    
    ? Found a parameterised form of rate equation for beta, using expression: A*exp(k*(v-d))
    A_beta_m = 1
    k_beta_m = 0.075
    d_beta_m = -45
     
    
    beta = A_beta_m * exp((v - d_beta_m) * k_beta_m)
    
         

    ? Found a generic form of the rate equation for tau, using expression: beta / (0.04 *(1+alpha))
                    tau = beta / (0.04 *(1+alpha))
        
    mtau = tau/temp_adj_m
    
    ? Found a parameterised form of rate equation for inf, using expression: A / (1 + exp(k*(v-d)))
    A_inf_m = 1
    k_inf_m = -(0.071428571)
    d_inf_m = 17.5
     
    
    inf = A_inf_m / (exp((v - d_inf_m) * k_inf_m) + 1)
    
    minf = inf
          
       
    
    ?     *** Finished rate equations for gate: m ***
    
        
        
    ?      ***  Adding rate equations for gate: h  ***
        
    ? Found a parameterised form of rate equation for alpha, using expression: A*exp(k*(v-d))
    A_alpha_h = 1
    k_alpha_h = 0.2
    d_alpha_h = -70
     
    
    alpha = A_alpha_h * exp((v - d_alpha_h) * k_alpha_h)
    
    
    ? Found a parameterised form of rate equation for beta, using expression: A*exp(k*(v-d))
    A_beta_h = 1
    k_beta_h = 0.198
    d_beta_h = -70
     
    
    beta = A_beta_h * exp((v - d_beta_h) * k_beta_h)
    
         

    ? Found a generic form of the rate equation for tau, using expression: beta / (0.018 *(1+alpha))
                    tau = beta / (0.018 *(1+alpha))
        
    htau = tau/temp_adj_h
    
    ? Found a parameterised form of rate equation for inf, using expression: A / (1 + exp(k*(v-d)))
    A_inf_h = 1
    k_inf_h = (0.166666666)
    d_inf_h = -41.7
     
    
    inf = A_inf_h / (exp((v - d_inf_h) * k_inf_h) + 1)
    
    hinf = inf
          
       
    
    ?     *** Finished rate equations for gate: h ***
    
             

}


UNITSON


