COMMENT

   **************************************************
   File generated by: neuroConstruct v1.3.8 
   **************************************************

   This file holds the implementation in NEURON of the Cell Mechanism:
   KCa3_ChannelML_new (Type: Channel mechanism, Model: ChannelML based process)

   with parameters: 
   /channelml/@units = Physiological Units 
   /channelml/notes = A channel from Bhalla, U.S.and Bower, J.M. Exploring parameter space in detailed single neuron models:     simulations of the mitral and granule cells ... 
   /channelml/channel_type/@name = KCa3_ChannelML_new 
   /channelml/channel_type/@density = yes 
   /channelml/channel_type/status/@value = in_progress 
   /channelml/channel_type/status/issue = This ChannelML file is intended to replicate the GENESIS functionality of a tabchannel version of Kca_mit_usb  
   /channelml/channel_type/status/contributor/name = Simon O'Connor 
   /channelml/channel_type/notes = Calcium dependent K channel 
   /channelml/channel_type/publication/fullTitle = Bhalla, U.S.and Bower, J.M. Exploring parameter space in detailed single neuron models:     simulations of the mitral and granule cells of the olfacto ... 
   /channelml/channel_type/publication/pubmedRef = http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&amp;db=PubMed&amp;list_uids=7688798&amp;dopt=Abstract 
   /channelml/channel_type/neuronDBref/modelName = K channels 
   /channelml/channel_type/neuronDBref/uri = http://senselab.med.yale.edu/senselab/NeuronDB/channelGene2.htm#table3 
   /channelml/channel_type/current_voltage_relation/@cond_law = ohmic 
   /channelml/channel_type/current_voltage_relation/@ion = k 
   /channelml/channel_type/current_voltage_relation/@default_gmax = 3.6 
   /channelml/channel_type/current_voltage_relation/@default_erev = -80 
   /channelml/channel_type/current_voltage_relation/conc_dependence/@name = Calcium 
   /channelml/channel_type/current_voltage_relation/conc_dependence/@ion = ca 
   /channelml/channel_type/current_voltage_relation/conc_dependence/@charge = 2 
   /channelml/channel_type/current_voltage_relation/conc_dependence/@variable_name = ca_conc 
   /channelml/channel_type/current_voltage_relation/conc_dependence/@min_conc = 0 
   /channelml/channel_type/current_voltage_relation/conc_dependence/@max_conc = 1e-8 
   /channelml/channel_type/current_voltage_relation/gate[1]/@name = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/@instances = 1 
   /channelml/channel_type/current_voltage_relation/gate[1]/closed_state/@id = m0 
   /channelml/channel_type/current_voltage_relation/gate[1]/open_state/@id = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/open_state/@fraction = 1 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@name = alpha 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@from = m0 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@to = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@expr = (exp ((v-65)/27)) 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@name = beta 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@from = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@to = m0 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@expr = 0.008 
   /channelml/channel_type/current_voltage_relation/gate[2]/@name = z 
   /channelml/channel_type/current_voltage_relation/gate[2]/@instances = 1 
   /channelml/channel_type/current_voltage_relation/gate[2]/closed_state/@id = z0 
   /channelml/channel_type/current_voltage_relation/gate[2]/open_state/@id = z 
   /channelml/channel_type/current_voltage_relation/gate[2]/open_state/@fraction = 1 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[1]/@name = alpha 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[1]/@from = z0 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[1]/@to = z 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[1]/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[1]/@expr = (500.0*(0.015 - (ca_conc*1e6)))/( (exp ((0.015 - (ca_conc*1e6))/0.0013)) -1) 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[2]/@name = beta 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[2]/@from = z 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[2]/@to = z0 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[2]/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[2]/@expr = 0.0021 
   /channelml/channel_type/impl_prefs/table_settings/@max_v = 50 
   /channelml/channel_type/impl_prefs/table_settings/@min_v = -100 
   /channelml/channel_type/impl_prefs/table_settings/@table_divisions = 300 

// File from which this was generated: /home/Simon/nC_projects/Rat_Mitral_Cell_Gap_Network_copy4/cellMechanisms/KCa3_ChannelML_new/KCa_Chan.xml

// XSL file with mapping to simulator: /home/Simon/nC_projects/Rat_Mitral_Cell_Gap_Network_copy4/cellMechanisms/KCa3_ChannelML_new/ChannelML_v1.8.0_NEURONmod.xsl

ENDCOMMENT


?  This is a NEURON mod file generated from a ChannelML file

?  Unit system of original ChannelML file: Physiological Units

COMMENT
    A channel from Bhalla, U.S.and Bower, J.M. Exploring parameter space in detailed single neuron models:
    simulations of the mitral and granule cells of the olfactory bulb
ENDCOMMENT

TITLE Channel: KCa3_ChannelML_new

COMMENT
    Calcium dependent K channel
ENDCOMMENT


UNITS {
    (mA) = (milliamp)
    (mV) = (millivolt)
    (S) = (siemens)
    (um) = (micrometer)
    (molar) = (1/liter)
    (mM) = (millimolar)
    (l) = (liter)
}


    
NEURON {
      

    SUFFIX KCa3_ChannelML_new
    USEION k READ ek WRITE ik VALENCE 1  ? reversal potential of ion is read, outgoing current is written
           
        
    USEION ca READ cai VALENCE 2 ? internal concentration of ion is read

    
    RANGE gmax, gion
    
    RANGE minf, mtau
    
    RANGE zinf, ztau
    
}

PARAMETER { 
      

    gmax = 0.0036 (S/cm2)  ? default value, should be overwritten when conductance placed on cell
    
}



ASSIGNED {
      

    v (mV)
    
    celsius (degC)
          

    ? Reversal potential of k
    ek (mV)
    ? The outward flow of ion: k calculated by rate equations...
    ik (mA/cm2)
          

    ? The internal concentration of ion: ca is used in the rate equations...
    cai (mM)   
    
    
    gion (S/cm2)
    minf
    mtau (ms)
    zinf
    ztau (ms)
    
}

BREAKPOINT { SOLVE states METHOD derivimplicit     

    gion = gmax*((1*m)^1)*((1*z)^1)      

    ik = gion*(v - ek)
            

}



INITIAL {
    
    ek = -80
        
    settables(v,cai)
    m = minf
           
    z = zinf
           
    
    
}
    
STATE {
    m
    z
    
}

DERIVATIVE states {
    settables(v,cai)
    m' = (minf - m)/mtau
    z' = (zinf - z)/ztau
    
}

PROCEDURE settables(v(mV), cai(mM)) {  
    
    ? Note: not all of these may be used, depending on the form of rate equations
    LOCAL  alpha, beta, tau, inf, gamma, zeta, ca_conc, temp_adj_m, A_alpha_m, B_alpha_m, Vhalf_alpha_m, A_beta_m, B_beta_m, Vhalf_beta_m, temp_adj_z, A_alpha_z, B_alpha_z, Vhalf_alpha_z, A_beta_z, B_beta_z, Vhalf_beta_z
    
    
    UNITSOFF
    temp_adj_m = 1
    temp_adj_z = 1
    
    ? Gate depends on the concentration of ca
    ca_conc = cai ? In NEURON, the variable for the concentration  of ca is cai
    
            
                
           

        
    ?      ***  Adding rate equations for gate: m  ***
         
    ? Found a generic form of the rate equation for alpha, using expression: (exp ((v-65)/27))
    
    ? Equations can depend on concentration. NEURON uses 'SI Units' internally for concentration, 
    ? but the ChannelML file is in Physiological Units...
    ca_conc = ca_conc / 1000000
    alpha = (exp ((v-65)/27))
        
    ? Resetting concentration...
    ca_conc = ca_conc * 1000000
    
     
    ? Found a generic form of the rate equation for beta, using expression: 0.008
    
    ? Equations can depend on concentration. NEURON uses 'SI Units' internally for concentration, 
    ? but the ChannelML file is in Physiological Units...
    ca_conc = ca_conc / 1000000
    beta = 0.008
        
    ? Resetting concentration...
    ca_conc = ca_conc * 1000000
    
    mtau = 1/(temp_adj_m*(alpha + beta))
    minf = alpha/(alpha + beta)
          
       
    
    ?     *** Finished rate equations for gate: m ***
    

    
            
                
           

        
    ?      ***  Adding rate equations for gate: z  ***
         
    ? Found a generic form of the rate equation for alpha, using expression: (500.0*(0.015 - (ca_conc*1e6)))/( (exp ((0.015 - (ca_conc*1e6))/0.0013)) -1)
    
    ? Equations can depend on concentration. NEURON uses 'SI Units' internally for concentration, 
    ? but the ChannelML file is in Physiological Units...
    ca_conc = ca_conc / 1000000
    alpha = (500.0*(0.015 - (ca_conc*1e6)))/( (exp ((0.015 - (ca_conc*1e6))/0.0013)) -1)
        
    ? Resetting concentration...
    ca_conc = ca_conc * 1000000
    
     
    ? Found a generic form of the rate equation for beta, using expression: 0.0021
    
    ? Equations can depend on concentration. NEURON uses 'SI Units' internally for concentration, 
    ? but the ChannelML file is in Physiological Units...
    ca_conc = ca_conc / 1000000
    beta = 0.0021
        
    ? Resetting concentration...
    ca_conc = ca_conc * 1000000
    
    ztau = 1/(temp_adj_z*(alpha + beta))
    zinf = alpha/(alpha + beta)
          
       
    
    ?     *** Finished rate equations for gate: z ***
    

         

}


UNITSON


