function INPlotLines(filename)
% Called by INPlotSimpleComplete.m

% Plots cell model outline on threshold map for reference.

switch filename
    
    case 'celltype1.dat'
        title('Large Multipolar Interneuron');
        %Shifts the cell model to align with the stimulation threshold map.
        xshift=575+25;
        yshift=325+25;
        plot(0+xshift, 5+yshift,  'k.', 'MarkerSize', 10)
        line([	0+xshift 	15+xshift], [ 10+yshift  40+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	15+xshift 	17+xshift], [ 40+yshift  45+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	17+xshift 	20+xshift], [ 45+yshift  55+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	23+xshift], [ 55+yshift  65+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	23+xshift 	25+xshift], [ 65+yshift  70+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	25+xshift 	30+xshift], [ 70+yshift  95+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	60+xshift], [ 95+yshift  125+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	60+xshift 	75+xshift], [ 125+yshift  170+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	60+xshift 	50+xshift], [ 125+yshift  140+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	75+xshift], [ 95+yshift  90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	75+xshift 	80+xshift], [ 90+yshift  100+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	75+xshift 	90+xshift], [ 90+yshift  80+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	23+xshift 	105+xshift], [ 65+yshift  55+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	105+xshift 	140+xshift], [ 55+yshift  105+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	105+xshift 	200+xshift], [ 55+yshift  30+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	200+xshift 	200+xshift], [ 30+yshift  40+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	200+xshift 	250+xshift], [ 30+yshift  20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	175+xshift], [ 55+yshift  70+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	175+xshift 	200+xshift], [ 70+yshift  85+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	200+xshift 	210+xshift], [ 85+yshift  100+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	200+xshift 	250+xshift], [ 85+yshift  95+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	250+xshift 	420+xshift], [ 95+yshift  80+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	175+xshift 	360+xshift], [ 70+yshift  80+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	17+xshift 	45+xshift], [ 45+yshift  35+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	45+xshift 	150+xshift], [ 35+yshift  35+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	45+xshift 	85+xshift], [ 35+yshift  20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	15+xshift 	-5+xshift], [ 40+yshift  30+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-5+xshift 	-175+xshift], [ 30+yshift  25+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-5+xshift 	-155+xshift], [ 30+yshift  45+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	25+xshift 	-25+xshift], [ 70+yshift  80+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-25+xshift 	-205+xshift], [ 80+yshift  120+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-25+xshift 	-30+xshift], [ 80+yshift  50+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-30+xshift 	-325+xshift], [ 50+yshift  25+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-30+xshift 	-15+xshift], [ 30+yshift  -55+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-15+xshift 	25+xshift], [ -55+yshift  -65+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	25+xshift 	15+xshift], [ -65+yshift  -100+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-15+xshift 	0+xshift], [ -55+yshift  -90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	25+xshift 	175+xshift], [ -65+yshift  -40+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        
    case 'celltype2.dat'
        title('Slender Multipolar Interneuron');
        xshift = 325+25;
        yshift = 350+25;
        plot(0+xshift, 5+yshift,  'k.', 'MarkerSize', 10)
        line([	0+xshift 	0+xshift], [ 10+yshift  60+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	0+xshift], [ 60+yshift  90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	0+xshift], [ 90+yshift  190+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	-130+xshift], [ 90+yshift  90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	70+xshift], [ 60+yshift  50+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	70+xshift 	70+xshift], [ 50+yshift  90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	70+xshift 	70+xshift], [ 90+yshift  130+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	70+xshift 	30+xshift], [ 130+yshift  170+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	70+xshift 	100+xshift], [ 130+yshift  160+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	70+xshift 	180+xshift], [ 90+yshift  110+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	70+xshift 	70+xshift], [ 50+yshift  -20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	70+xshift 	70+xshift], [ -20+yshift  -80+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	70+xshift 	70+xshift], [ -80+yshift  -130+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	70+xshift 	180+xshift], [ -20+yshift  -20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	70+xshift 	0+xshift], [ -80+yshift  -80+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        
    case 'celltype3.dat'
        title('Bitufted Interneuron');
        xshift = 200+25;
        yshift = 1000+25;
        plot(0+xshift, 5+yshift,  'k.', 'MarkerSize', 10)
        line([	0+xshift 	0+xshift], [ 0+yshift  -30+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	-20+xshift], [ -30+yshift  -50+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	20+xshift], [ -30+yshift  -60+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	0+xshift], [ -60+yshift  -100+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	40+xshift], [ -60+yshift  -90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-20+xshift 	-30+xshift], [ -50+yshift  -50+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-30+xshift 	-50+xshift], [ -50+yshift  -50+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	40+xshift 	50+xshift], [ -90+yshift  -90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	50+xshift 	60+xshift], [ -90+yshift  -90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	60+xshift 	70+xshift], [ -90+yshift  -90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-50+xshift 	-50+xshift], [ -50+yshift  -650+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-30+xshift 	-40+xshift], [ -50+yshift  -200+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-20+xshift 	-10+xshift], [ -50+yshift  -720+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	-10+xshift], [ -100+yshift  -500+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	0+xshift], [ -100+yshift  -670+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	20+xshift], [ -100+yshift  -340+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	50+xshift 	50+xshift], [ -90+yshift  -150+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	60+xshift 	70+xshift], [ -90+yshift  -690+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	70+xshift 	80+xshift], [ -90+yshift  -430+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        
    case 'celltype4.dat'
        title('Small Round Interneuron');
        xshift = 200+25;
        yshift = 400+25;
        plot(0+xshift, 5+yshift,  'k.', 'MarkerSize', 10)
        line([	0+xshift 	0+xshift], [ 10+yshift  20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	20+xshift], [ 20+yshift  40+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	0+xshift], [ 40+yshift  90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	10+xshift], [ 90+yshift  170+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	10+xshift 	40+xshift], [ 170+yshift  300+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	20+xshift], [ 40+yshift  20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	15+xshift], [ 20+yshift  -30+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	15+xshift 	10+xshift], [ -30+yshift  -60+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	10+xshift 	0+xshift], [ -60+yshift  -90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	-20+xshift], [ -110+yshift  -170+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-20+xshift 	-20+xshift], [ -170+yshift  -250+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-20+xshift 	-30+xshift], [ -250+yshift  -310+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-20+xshift 	-30+xshift], [ -250+yshift  -255+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	-30+xshift], [ -90+yshift  -90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-30+xshift 	-50+xshift], [ -90+yshift  -120+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-50+xshift 	-90+xshift], [ -120+yshift  -120+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-90+xshift 	-110+xshift], [ -120+yshift  -180+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-50+xshift 	-70+xshift], [ -120+yshift  -200+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	15+xshift 	-40+xshift], [ -30+yshift  -60+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-40+xshift 	-50+xshift], [ -60+yshift  -70+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-40+xshift 	-20+xshift], [ -60+yshift  -80+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	15+xshift 	-10+xshift], [ -30+yshift  -20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-10+xshift 	-30+xshift], [ -20+yshift  0+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	-20+xshift], [ 90+yshift  110+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-20+xshift 	-40+xshift], [ 110+yshift  170+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	10+xshift 	40+xshift], [ 170+yshift  170+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	40+xshift], [ 40+yshift  110+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	60+xshift], [ 20+yshift  20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	60+xshift 	70+xshift], [ 20+yshift  50+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	70+xshift 	90+xshift], [ 50+yshift  80+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	60+xshift 	80+xshift], [ 20+yshift  20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	80+xshift 	90+xshift], [ 20+yshift  0+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	70+xshift 	100+xshift], [ 50+yshift  50+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	10+xshift 	30+xshift], [ -60+yshift  -60+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	50+xshift], [ -60+yshift  -40+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	50+xshift 	70+xshift], [ -40+yshift  -30+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	40+xshift], [ -110+yshift  -110+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	40+xshift 	60+xshift], [ -110+yshift  -90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	0+xshift], [ -90+yshift  -110+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-20+xshift 	0+xshift], [ -170+yshift  -175+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        
    case 'celltype5.dat'
        title('Small Granular Interneuron');
        xshift = 250+25;
        yshift = 250+25;
        plot(0+xshift, 5+yshift,  'k.', 'MarkerSize', 10)
        line([	0+xshift 	20+xshift], [ 0+yshift  -30+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	30+xshift], [ -30+yshift  -60+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	40+xshift], [ -60+yshift  -90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	-40+xshift], [ -60+yshift  -130+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	80+xshift], [ -60+yshift  -40+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	80+xshift 	100+xshift], [ -40+yshift  30+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	80+xshift 	110+xshift], [ -40+yshift  -20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	40+xshift], [ -30+yshift  -40+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	40+xshift 	110+xshift], [ -40+yshift  -140+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	40+xshift 	50+xshift], [ -40+yshift  20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	50+xshift 	0+xshift], [ 20+yshift  80+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	50+xshift 	60+xshift], [ 20+yshift  40+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	60+xshift 	140+xshift], [ 40+yshift  -30+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	60+xshift 	140+xshift], [ 40+yshift  60+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	60+xshift 	80+xshift], [ 40+yshift  110+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	-10+xshift], [ -30+yshift  -20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-10+xshift 	20+xshift], [ -20+yshift  -100+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-10+xshift 	-40+xshift], [ -20+yshift  -20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-40+xshift 	-10+xshift], [ -20+yshift  30+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-10+xshift 	-50+xshift], [ 30+yshift  80+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-10+xshift 	40+xshift], [ 30+yshift  100+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	40+xshift 	10+xshift], [ 100+yshift  160+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-40+xshift 	-60+xshift], [-20+yshift  -10+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-60+xshift 	-110+xshift], [ -10+yshift  -50+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-110+xshift 	-140+xshift], [ -50+yshift  -80+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-110+xshift 	-60+xshift], [ -50+yshift  -140+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-40+xshift 	-70+xshift], [ -20+yshift  20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-70+xshift 	-110+xshift], [ 20+yshift  50+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-70+xshift 	-40+xshift], [ 20+yshift  130+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-40+xshift 	-30+xshift], [ 130+yshift  150+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-40+xshift 	40+xshift], [ 130+yshift  140+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        
    case 'celltype6.dat'
        title('Round with Dendritic Tuft Interneuron')
        xshift = 800+25;
        yshift = 325+25;
        plot(0+xshift, 5+yshift,  'k.', 'MarkerSize', 10)
        line([	0+xshift 	30+xshift], [ 0+yshift  -30+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	30+xshift], [ -30+yshift  -40+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	20+xshift], [ -40+yshift  -60+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	20+xshift], [ -60+yshift  -70+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	30+xshift], [ -70+yshift  -110+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	40+xshift], [ -110+yshift  -140+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	-10+xshift], [ -30+yshift  60+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-10+xshift 	-70+xshift], [ 60+yshift  90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-70+xshift 	-50+xshift], [ 90+yshift  110+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-50+xshift 	-80+xshift], [ 110+yshift  120+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-80+xshift 	-400+xshift], [ 120+yshift  130+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-70+xshift 	150+xshift], [ 90+yshift  70+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	150+xshift 	230+xshift], [ 70+yshift  110+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	70+xshift], [ -40+yshift  -20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	70+xshift 	60+xshift], [ -20+yshift  10+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	60+xshift 	40+xshift], [ 10+yshift  40+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	60+xshift 	200+xshift], [ 10+yshift  20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	150+xshift], [ -40+yshift  -60+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	310+xshift], [ -70+yshift  -80+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	-40+xshift], [ -110+yshift  -120+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-40+xshift 	-90+xshift], [ -120+yshift  -80+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-90+xshift 	-180+xshift], [ -80+yshift  -100+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	-20+xshift], [ -60+yshift  -40+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-20+xshift 	-470+xshift], [ -40+yshift  -60+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-20+xshift 	-120+xshift], [ -40+yshift  -30+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-120+xshift 	-200+xshift], [ -30+yshift  -40+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-390+xshift 	-570+xshift], [ -10+yshift  10+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	-60+xshift], [ -40+yshift  -30+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-60+xshift 	-390+xshift], [ -30+yshift  -10+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-200+xshift 	-310+xshift], [ -40+yshift  -20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        
    case 'celltype7.dat'
        title('Spiny with Recurrent Axon Interneuron')
        xshift = 175+25;
        yshift = 275+25;
        plot(0+xshift, 5+yshift,  'k.', 'MarkerSize', 10)
        line([	0+xshift 	0+xshift], [ 0+yshift  -30+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	20+xshift], [ -30+yshift  -60+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	30+xshift], [ -60+yshift  -80+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	70+xshift], [ -80+yshift  -90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	30+xshift 	10+xshift], [ -80+yshift  -110+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	-20+xshift], [ -30+yshift  -50+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-20+xshift 	-50+xshift], [ -50+yshift  -30+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-50+xshift 	-50+xshift], [ -30+yshift  50+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-50+xshift 	-20+xshift], [ 50+yshift  210+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	20+xshift], [ -30+yshift  50+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	10+xshift], [ 50+yshift  240+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	10+xshift 	-40+xshift], [ 240+yshift  300+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-40+xshift 	-60+xshift], [ 300+yshift  320+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-40+xshift 	-10+xshift], [ 300+yshift  320+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	10+xshift 	0+xshift], [ 240+yshift  260+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	20+xshift 	60+xshift], [ 50+yshift  280+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	60+xshift 	100+xshift], [ 280+yshift  300+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	100+xshift 	140+xshift], [ 300+yshift  260+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	50+xshift], [ -30+yshift  -50+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	50+xshift 	90+xshift], [ -50+yshift  -20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	90+xshift 	110+xshift], [ -20+yshift  100+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	110+xshift 	80+xshift], [ 100+yshift  270+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	80+xshift 	50+xshift], [ 270+yshift  300+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	80+xshift 	100+xshift], [ 270+yshift  280+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	100+xshift 	120+xshift], [ 280+yshift  340+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        
    case 'celltype8.dat'
        title('Modified Pyramidal Interneuron')
        xshift = 300+25;
        yshift = 350+25;
        plot(0+xshift, 5+yshift,  'k.', 'MarkerSize', 10)
        line([	0+xshift 	10+xshift], [ 0+yshift  -15+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	10+xshift 	0+xshift], [ -15+yshift  -20+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	-5+xshift], [ -20+yshift  -10+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	0+xshift 	-20+xshift], [ -20+yshift  -40+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-20+xshift 	-25+xshift], [ -40+yshift  -35+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-25+xshift 	-40+xshift], [ -35+yshift  -45+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-40+xshift 	-90+xshift], [ -45+yshift  -35+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-40+xshift 	-50+xshift], [ -45+yshift  -55+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-50+xshift 	50+xshift], [ -55+yshift  -75+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-20+xshift 	-35+xshift], [ -40+yshift  -90+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-35+xshift 	40+xshift], [ -90+yshift  -100+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-35+xshift 	-60+xshift], [ -90+yshift  -120+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-60+xshift 	-100+xshift], [ -120+yshift  -115+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
        line([	-60+xshift 	-85+xshift], [ -120+yshift  -145+yshift], [0 0], 'LineWidth', 2, 'Color', 'k')
end

% Returns to INPlotSimpleComplete.m