(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    395985,      10101]
NotebookOptionsPosition[    394467,      10054]
NotebookOutlinePosition[    394879,      10072]
CellTagsIndexPosition[    394836,      10069]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{
    "Systems", " ", "Pharmacology", " ", "Model", " ", "of", " ", "Mammalian",
      " ", "Circadian", " ", "Clock", " ", "Including", " ", "PF"}], "-", 
    "670462"}], "Title"], " "}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"Jae", " ", "Kyoung", " ", "Kim"}], ",", 
   RowBox[{"Daniel", " ", "B", " ", "Forger"}], ",", 
   RowBox[{"Michael", " ", "Marconi"}], ",", 
   RowBox[{"Douglas", " ", "Wood"}], ",", 
   RowBox[{"Angela", " ", "Doran"}], ",", 
   RowBox[{"Travis", " ", "Wager"}], ",", 
   RowBox[{
   "Cheng", " ", "Chang", " ", "and", " ", "Kevin", " ", "M", " ", 
    "Walton"}]}], "Subtitle"]}], "Input",
 CellChangeTimes->{{3.5316682093857937`*^9, 3.531668309925372*^9}, {
  3.56613373260361*^9, 3.566133758438279*^9}, {3.566174303683866*^9, 
  3.5661743067761717`*^9}, {3.5722236385900593`*^9, 3.5722236691154633`*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{
    "This", " ", "model", " ", "is", " ", "developed", " ", "in", " ", "Jae", 
     " ", "\!\(\*\"\\\"\"\)\!\(\*\"Modeling\"\)\!\(\*\" \"\)\!\(\*\"and\"\)\!\
\(\*\" \"\)\!\(\*\"validating\"\)\!\(\*\" \"\)\!\(\*\"chronic\"\)\!\(\*\" \
\"\)\!\(\*\"pharmacological\"\)\!\(\*\" \"\)\!\(\*\"manipulation\"\)\!\(\*\" \
\"\)\!\(\*\"of\"\)\!\(\*\" \"\)\!\(\*\"circadian\"\)\!\(\*\" \
\"\)\!\(\*\"rhythms\"\)\!\(\*\"\\\"\"\)", 
     RowBox[{"CPT", ":", "Pharmacometrics"}]}], "&"}], " ", "Systems", " ", 
   "Pharmacology", " ", 
   RowBox[{
    RowBox[{"(", "2013", ")"}], "."}]}], "Subsubtitle"]], "Input",
 CellChangeTimes->{{3.566133862197897*^9, 3.5661339566873198`*^9}, {
  3.566133994388998*^9, 3.566133995775276*^9}, {3.566134564703212*^9, 
  3.566134566898576*^9}, {3.572223694416048*^9, 3.572223766215448*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{
  "This", "  ", "model", " ", "is", " ", "extended", " ", "based", " ", "on", 
   " ", "the", " ", "Kim", " ", "and", " ", "Forger", " ", "model", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Kim", " ", "&"}], " ", "Forger"}], ",", " ", 
      RowBox[{"MSB", " ", 
       RowBox[{"(", "2012", ")"}]}]}], ")"}], ".", "  "}]}], 
  "Subsection"]], "Input",
 CellChangeTimes->{{3.5722237390752707`*^9, 3.57222377737593*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"Initial", " ", "Conditions"}], "Subtitle"]], "Input",
 CellChangeTimes->{{3.5316661826047163`*^9, 3.5316661842246847`*^9}, 
   3.531668140470046*^9, {3.5432337253436193`*^9, 3.543233725715186*^9}, 
   3.572223755532198*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Initial", " ", "Condition", " ", "for", " ", "the", " ", "multi"}], "-", 
    
    RowBox[{"state", " ", "variable", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", "]"}], "[", 
       "m", "]"}], "[", "n", "]"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Init1", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.3420612363991834`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "8.179771245758342`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "50.57941320972072`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "3.084858510765489`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0985802410460628`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "1.3084555441370038`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "41.165766704888945`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.015608382491794207`", "}"}], ",", 
               RowBox[{"{", "8.720885301950966`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "46.57213430901654`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0031953005375601647`", "}"}], ",", 
               RowBox[{"{", "1.36799289498887`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.42289800101916825`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "1.0925402835728917`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0018172208474570813`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.000051969832456607834`", "}"}], ",", 
               RowBox[{"{", "0.005122234469530184`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.1065745913827944`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0008330734700784042`", "}"}], ",", 
               RowBox[{"{", "0.0566635532527744`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0032917376286310976`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.000014996030154730353`", "}"}], ",", 
               RowBox[{"{", "0.005431344430745013`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.08769094840691996`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0003337441556398164`", "}"}], ",", 
               RowBox[{"{", "0.05489271181066792`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0034854600146215606`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00001543121168014226`", "}"}], ",", 
               RowBox[{"{", "0.005104574272816484`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.09387578379334667`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0003536110985068703`", "}"}], ",", 
               RowBox[{"{", "0.053591842109765024`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.9143646209767509`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.6640388319296585`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.02261620526647949`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.024153127001179508`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.003566426542717158`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.000019446948491991687`", "}"}], ",", 
               RowBox[{"{", "0.0009593633157572193`", "}"}]}], "}"}]}], "}"}],
            ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.25844220368442533`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0009853861095753967`", "}"}], ",", 
               RowBox[{"{", "0.024999109498991166`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0001571030498997009`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.000011241988156917215`", "}"}], ",", 
               RowBox[{"{", "0.0013233693432189286`", "}"}]}], "}"}]}], "}"}],
            ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.010591367829307969`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00023061993448538233`", "}"}], ",", 
               RowBox[{"{", "0.025310956921162836`", "}"}]}], "}"}]}], 
            "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.003906943572357614`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.000013488201348952268`", "}"}], ",", 
               RowBox[{"{", "0.0008093091845965769`", "}"}]}], "}"}]}], "}"}],
            ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.124712274740282`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0004168131259404268`", "}"}], ",", 
               RowBox[{"{", "0.014891880773138683`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00018883274230441384`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "1.7997916251845195`*^-6", "}"}], ",", 
               RowBox[{"{", "0.0010929293853399464`", "}"}]}], "}"}]}], "}"}],
            ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.005847694864620672`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00004358370050515716`", "}"}], ",", 
               RowBox[{"{", "0.01661068549366629`", "}"}]}], "}"}]}], "}"}]}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0042845356189285195`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.000014771592378319274`", "}"}], ",", 
               RowBox[{"{", "0.0008613198533091311`", "}"}]}], "}"}]}], "}"}],
            ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.1376958595595994`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00045981124781785865`", "}"}], ",", 
               RowBox[{"{", "0.01603487525209985`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00020679957949088886`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "1.9401844427852306`*^-6", "}"}], ",", 
               RowBox[{"{", "0.0011515995567390796`", "}"}]}], "}"}]}], "}"}],
            ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.006446263165149906`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00004763488605319544`", "}"}], ",", 
               RowBox[{"{", "0.01770213916985296`", "}"}]}], "}"}]}], "}"}]}],
           "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.005698064997206092`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00019083191864807688`", "}"}], ",", 
               RowBox[{"{", "0.05668344375489035`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.028756909151433502`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00041383171976532257`", "}"}], ",", 
               RowBox[{"{", "0.04946506549670688`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0041450474340475356`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0003862225731469661`", "}"}], ",", 
               RowBox[{"{", "0.12446417224048362`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0074079613548572055`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0006543776273979713`", "}"}], ",", 
               RowBox[{"{", "0.10408853180005757`", "}"}]}], "}"}]}], "}"}]}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.006669740144184649`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00002542209112423298`", "}"}], ",", 
               RowBox[{"{", "0.004845243944628116`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0828541248216783`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0002945640707027717`", "}"}], ",", 
               RowBox[{"{", "0.032357261166932494`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0012141988050762562`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.000011508013921347713`", "}"}], ",", 
               RowBox[{"{", "0.009768583317773775`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.008747399124363007`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00007984935519557792`", "}"}], ",", 
               RowBox[{"{", "0.06078778560702874`", "}"}]}], "}"}]}], "}"}]}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.007063852050803612`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00002642920327460206`", "}"}], ",", 
               RowBox[{"{", "0.004422509243751679`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.08527034138444498`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00030090634602644245`", "}"}], ",", 
               RowBox[{"{", "0.030114250838098423`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0013264050530040427`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.000011249707819832738`", "}"}], ",", 
               RowBox[{"{", "0.00878990944810083`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.009150500594118106`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00007786053056329725`", "}"}], ",", 
               RowBox[{"{", "0.05558596503417361`", "}"}]}], "}"}]}], "}"}]}],
           "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0007928248680611883`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.000025780353419672163`", "}"}], ",", 
               RowBox[{"{", "0.0033458239867342923`", "}"}]}], "}"}]}], "}"}],
            ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0274124885839697`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00038549841376936617`", "}"}], ",", 
               RowBox[{"{", "0.05899370416043617`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0001255123171657433`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00004997690057380442`", "}"}], ",", 
               RowBox[{"{", "0.007351856000655174`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.005502328645107724`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0006319867772882921`", "}"}], ",", 
               RowBox[{"{", "0.12768021452441894`", "}"}]}], "}"}]}], "}"}]}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0025210125949368953`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.000010077905400078566`", "}"}], ",", 
               RowBox[{"{", "0.0024810297377193245`", "}"}]}], "}"}]}], "}"}],
            ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.05812325888303372`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00020742923534716493`", "}"}], ",", 
               RowBox[{"{", "0.023913749818730998`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00030530718232012633`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "4.902173374599667`*^-6", "}"}], ",", 
               RowBox[{"{", "0.005219487814016039`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.007539434826295608`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00006395851528373895`", "}"}], ",", 
               RowBox[{"{", "0.04714353907964912`", "}"}]}], "}"}]}], "}"}]}],
           "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0025977211835363366`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00001017089395981654`", "}"}], ",", 
               RowBox[{"{", "0.002248072566075126`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.060247906870995155`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00021344857807776635`", "}"}], ",", 
               RowBox[{"{", "0.022578312737100606`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.0003200670130454894`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "4.603722758559816`*^-6", "}"}], ",", 
               RowBox[{"{", "0.004701002286841585`", "}"}]}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.007971833585551605`", "}"}], ",", 
               RowBox[{"{", "0.`", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0.00006352606272272561`", "}"}], ",", 
               RowBox[{"{", "0.04407940585392828`", "}"}]}], "}"}]}], "}"}]}],
           "}"}]}], "}"}]}], "}"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Initial", " ", "Condition", " ", "for", " ", "the", " ", "single"}], 
     "-", 
     RowBox[{"state", " ", "variable"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Init2", "=", 
     RowBox[{"{", 
      RowBox[{
      "0.21004770358705036`", ",", "0.7879547112081645`", ",", 
       "1.1383721663365372`", ",", "3.760854376307055`", ",", 
       "1.095465622771389`", ",", "12.37354665811613`", ",", 
       "4.470535676137161`", ",", "4.189465465043962`", ",", 
       "0.5791077386453771`", ",", "8.349625799238817`", ",", 
       "1.4116789475658296`", ",", "35.184199298572295`", ",", 
       "8.56043138049844`", ",", "23.77410578150899`", ",", 
       "0.5893077833141493`", ",", "0.40424721668584945`", ",", 
       "48.09767559849965`", ",", "31.869023309234613`", ",", 
       "161.14372712932516`", ",", "123.95046120625604`", ",", 
       "467.84444843738225`", ",", "0.1932885142503498`", ",", 
       "58.23913168018502`", ",", "0.03971373557862615`", ",", 
       "19.06619007243528`", ",", "0.5999649539384736`", ",", 
       "0.39359004606153003`", ",", "0", ",", "0.11012045498612394`", ",", 
       "67.61745646537098`", ",", "0", ",", "0", ",", "6.5815025579914295`", 
       ",", "0.4162165798701546`", ",", "0.5585648324701572`", ",", "0.`", 
       ",", "0.25595982171319526`", ",", "0.5203673130406197`", ",", 
       "0.19388642676798773`", ",", "0.8044041532454284`"}], "}"}]}], ";"}], 
   "\n"}]}]], "Input",
 CellChangeTimes->{{3.531651170310773*^9, 3.531651234319051*^9}, {
  3.5316660752579727`*^9, 3.53166608034619*^9}, {3.5316661801568747`*^9, 
  3.531666216016047*^9}, {3.5661372044075537`*^9, 3.566137234957316*^9}}],

Cell[BoxData[{
 StyleBox["Parameters", "Subtitle"], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{"Original", " ", "Model", " ", "Prameters"}], 
  "Subsubtitle"]}], "Input",
 CellChangeTimes->{{3.566134056805214*^9, 3.566134067968223*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Transcription", " ", "Rate"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"trPo", "=", "25.9201"}], ";", 
    RowBox[{"trPt", "=", "44.854`"}], ";", 
    RowBox[{"trRo", "=", "23.0747`"}], ";", 
    RowBox[{"trRt", "=", "39.9409`"}], ";", 
    RowBox[{"trB", "=", "46.1038`"}], ";", 
    RowBox[{"trRev", "=", "102.92299999999999`"}], ";", 
    RowBox[{"trNp", "=", "0.3297485941817571`"}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{"Translation", " ", "Rate"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tlp", "=", "1.81031"}], ";", 
    RowBox[{"tlr", "=", "5.03882"}], ";", 
    RowBox[{"tlb", "=", "0.530436"}], ";", 
    RowBox[{"tlrev", "=", "8.90744"}], ";", 
    RowBox[{"tlc", "=", "4.645890"}], ";", 
    RowBox[{"tlnp", "=", "1.25099"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Binding", "/", "Unbinding"}], " ", "Rate", " ", "between", " ", 
     "Proteins"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"agp", "=", "1.3962`"}], ";", 
    RowBox[{"dg", "=", "2.93521`"}], ";", 
    RowBox[{"ac", "=", "0.0456572`"}], ";", 
    RowBox[{"dc", "=", "0.108072`"}], ";", 
    RowBox[{"ar", "=", "0.0235285`"}], ";", 
    RowBox[{"dr", "=", "0.605268`"}], ";", 
    RowBox[{"cbin", "=", "0.0454894`"}], ";", 
    RowBox[{"uncbin", "=", "7.27215`"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bbin", "=", "6.92686`"}], ";", 
    RowBox[{"unbbin", "=", "0.130196`"}], ";", 
    RowBox[{"cbbin", "=", "6.59924`"}], ";", 
    RowBox[{"uncbbin", "=", "0.304176`"}], ";", 
    RowBox[{"ag", "=", "0.162392"}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Binding", "/", "Unbinding"}], " ", "Rate", " ", "on", " ", 
     "Promoters"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bin", "=", "6.97166`"}], ";", 
    RowBox[{"unbin", "=", "0.255032`"}], ";", 
    RowBox[{"binrev", "=", "0.0120525`"}], ";", 
    RowBox[{"unbinrev", "=", "10.9741`"}], ";", 
    RowBox[{"binr", "=", "6.15445`"}], ";", 
    RowBox[{"unbinr", "=", "2.91009`"}], ";", 
    RowBox[{"binc", "=", "0.280863`"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"unbinc", "=", "0.00886752`"}], ";", 
    RowBox[{"binrevb", "=", "0.00626588`"}], ";", 
    RowBox[{"unbinrevb", "=", "5.30559`"}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Translocation", " ", "Rate"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmc", "=", "0.16426`"}], ";", 
    RowBox[{"tmcrev", "=", "9.2631`"}], ";", 
    RowBox[{"nl", "=", "0.643086`"}], ";", 
    RowBox[{"ne", "=", "0.0269078`"}], ";", 
    RowBox[{"nlrev", "=", "9.63702`"}], ";", 
    RowBox[{"nerev", "=", "0.0152514`"}], ";", 
    RowBox[{"lne", "=", "0.594609`"}], ";", 
    RowBox[{"nlbc", "=", "5.26501`"}], ";"}], "\n", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Phosphorylation", " ", "Rate"}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"hoo", "=", "0.527453`"}], ";", 
    RowBox[{"hto", "=", "2.45584`"}], ";", 
    RowBox[{"phos", "=", "0.291429`"}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{"Light", " ", "Effet"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lono", "=", "0.205813"}], ";", 
    RowBox[{"lont", "=", "0.396392"}], ";", 
    RowBox[{"ltI", "=", "300"}], ";", 
    RowBox[{"lta", "=", 
     RowBox[{"0.693695`", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"ltI", "/", "9500"}], ")"}], "^", "0.0451246`"}]}]}], ";", 
    RowBox[{"ltb", "=", "0.013"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"GSK3b", " ", "Activity"}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"trgto", "=", "0.644602`"}], ";", 
    RowBox[{"ugto", "=", "0.0625777`"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Ratio", " ", "beteeen", " ", "Cytoplasm", " ", "and", " ", "Nucleus"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Nf", "=", "3.35063`"}], ";"}], "\n", "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Degradation", " ", "Rate"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"up", "=", "3.537`"}], ";", 
    RowBox[{"uro", "=", "0.17491`"}], ";", 
    RowBox[{"urt", "=", "0.481895`"}], ";", 
    RowBox[{"umNp", "=", "0.369493`"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"umPo", "=", "0.76696222`"}], ";", 
    RowBox[{"umPt", "=", "0.58891980`"}], ";", 
    RowBox[{"umRo", "=", "0.40342526000000006`"}], ";", 
    RowBox[{"umRt", "=", "0.45554418`"}], ";", 
    RowBox[{"ub", "=", "0.018800209999999998`"}], ";", 
    RowBox[{"uc", "=", "0.025165115999999998`"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ubc", "=", "0.34882936000000003`"}], ";", 
    RowBox[{"upu", "=", "0.0700322`"}], ";", 
    RowBox[{"urev", "=", "1.6487614725107194`"}], ";", 
    RowBox[{"uprev", "=", "0.5173026723236928`"}], ";", 
    RowBox[{"umB", "=", "0.7954019999999999`"}], ";", 
    RowBox[{"umRev", "=", "1.510194`"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.531651259026125*^9, 3.531651327976585*^9}, {
   3.531651413810953*^9, 3.5316514593928833`*^9}, {3.53165374463516*^9, 
   3.531653834641397*^9}, {3.531665800410345*^9, 3.531665807570601*^9}, {
   3.531666199574057*^9, 3.5316662017200727`*^9}, {3.5317563239298353`*^9, 
   3.5317563737710238`*^9}, 3.5317564118872766`*^9, {3.5317564435289507`*^9, 
   3.5317564444561462`*^9}, {3.5317564868701363`*^9, 
   3.5317565653516693`*^9}, {3.531756636041912*^9, 3.5317567285527697`*^9}, {
   3.531756763763942*^9, 3.531756818827443*^9}, {3.531756849295059*^9, 
   3.531757052424533*^9}, 3.5317571088552113`*^9, {3.531757142393559*^9, 
   3.5317572371568604`*^9}, {3.531761778140252*^9, 3.531761793850124*^9}, {
   3.5317619705618467`*^9, 3.531761977455779*^9}, {3.5317650226729937`*^9, 
   3.531765027603498*^9}, {3.531765156750782*^9, 3.531765158693611*^9}, 
   3.531939801248106*^9, {3.531952936081143*^9, 3.531952983816248*^9}, {
   3.531953031305662*^9, 3.531953037249586*^9}, 3.5547368122377367`*^9, {
   3.5547368635713987`*^9, 3.554736877699341*^9}, 3.566156127026873*^9, {
   3.5661735869740133`*^9, 3.566173592621551*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"Newly", " ", "Added", " ", "Prameters", " ", "for", " ", "PF"}], 
   "-", "670462"}], "Subsubtitle"]], "Input",
 CellChangeTimes->{{3.566134084975582*^9, 3.5661340873661737`*^9}, {
  3.566174351175856*^9, 3.5661743546557837`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Initial", " ", "free", " ", "plasma", " ", "concentration", " ", "of", 
    " ", "CK1", " ", "inhibitor", " ", 
    RowBox[{"(", 
     RowBox[{"32", "mpk"}], ")"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"prodi", "=", "2562.61"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Transfer", " ", "rate", " ", "from", " ", "plasma", " ", "to", " ", 
     "brain", " ", "for", " ", "CK1", " ", "inhibitor"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nlpin", "=", "6.32905"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Transfer", " ", "rate", " ", "from", " ", "brain", " ", "to", " ", 
     "plasma", " ", "for", " ", "CK1", " ", "inhibitor"}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"nepin", "=", "15.3532`"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Transfer", " ", "rate", " ", "from", " ", "brain", " ", "to", " ", 
     "cell", " ", "for", " ", "CK1", " ", "inhibitor"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nlbin", "=", "0.485643`"}], ";"}], "\n", 
   RowBox[{"(*", 
    RowBox[{
    "Transfer", " ", "rate", " ", "from", " ", "cell", " ", "to", " ", 
     "brain", " ", "for", " ", "CK1", " ", "inhibitor"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nebin", "=", "19.1976`"}], ";"}], "\n", 
   RowBox[{"(*", 
    RowBox[{
    "Nuclear", " ", "localization", " ", "rate", " ", "constant", " ", "for", 
     " ", "CKI", " ", "inhibitor"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nlin", "=", "0.533183`"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Nuclear", " ", "export", " ", "rate", " ", "constant", " ", "for", " ", 
     "CKI", " ", "inhibitor"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nein", "=", "0.192038`"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Nuclear", " ", "export", " ", "rate", " ", "constant", " ", "for", " ", 
     "CKI", " ", "and", " ", "CKI", " ", "inhibitor", " ", "complex"}], 
    "*)"}], "\n", 
   RowBox[{
    RowBox[{"lnei", "=", "0.0472142`"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Binding", " ", "rate", " ", "constant", " ", "for", " ", "CKI", " ", 
     "inhibitor", " ", "to", " ", "CKI"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"inbin", "=", "0.42118`"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Unbinding", " ", "rate", " ", "constant", " ", "for", " ", "CKI", " ", 
     "inhibitor", " ", "to", " ", "CKI"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"inubin", "=", "3.38008`"}], ";"}], "\n", 
   RowBox[{"(*", 
    RowBox[{
    "Clearance", " ", "rate", " ", "constant", " ", "for", " ", "free", " ", 
     "CKI", " ", "inhibitor", " ", "in", " ", "blood", " ", "plasma"}], 
    "*)"}], "\n", 
   RowBox[{
    RowBox[{"uinp", "=", "1.6529873382775981`"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5661341714540052`*^9, 3.5661342038122063`*^9}, {
  3.5661342632589197`*^9, 3.566134433159754*^9}, {3.566134471305431*^9, 
  3.566134614163261*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"Equations", " "}], "Subtitle"]], "Input",
 CellChangeTimes->{{3.531666126996792*^9, 3.531666165552907*^9}, {
  3.5316673330233717`*^9, 3.531667337665584*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"Extended", " ", "Equations", " ", "for", " ", "Single"}], "-", 
   RowBox[{
   "state", " ", "Variables", " ", "when", " ", "light", " ", "is", " ", 
    "on"}]}], "Subsubtitle"]], "Input",
 CellChangeTimes->{{3.566135290174507*^9, 3.566135298567011*^9}, {
  3.566135341901145*^9, 3.566135345802758*^9}, {3.566138780786001*^9, 
  3.5661387831054983`*^9}, {3.566173506808961*^9, 3.566173511829565*^9}, {
  3.572223911086116*^9, 3.572223911486277*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"laone", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Original", " ", "model", " ", "equations"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"E", "-", 
       RowBox[{"box", " ", "activity"}]}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"GR", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"bin", "*", 
         RowBox[{"(", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "kk", "]"}], "[", "0", 
                "]"}], "[", "1", "]"}], "[", "1", "]"}], "[", "t", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"kk", ",", "1", ",", "2"}], "}"}]}], "]"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"G", "[", "t", "]"}], "-", 
           RowBox[{"GR", "[", "t", "]"}]}], ")"}]}], "-", 
        RowBox[{"unbin", "*", 
         RowBox[{"GR", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"G", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"bin", "*", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "0", "]"}], 
            "[", "1", "]"}], "[", "1", "]"}], "[", "t", "]"}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"G", "[", "t", "]"}], "-", 
           RowBox[{"GR", "[", "t", "]"}]}], ")"}]}], "-", 
        RowBox[{"unbin", "*", 
         RowBox[{"G", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"GrR", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"binr", "*", 
         RowBox[{"(", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "kk", "]"}], "[", "0", 
                "]"}], "[", "1", "]"}], "[", "1", "]"}], "[", "t", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"kk", ",", "1", ",", "2"}], "}"}]}], "]"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Gr", "[", "t", "]"}], "-", 
           RowBox[{"GrR", "[", "t", "]"}]}], ")"}]}], "-", 
        RowBox[{"unbinr", "*", 
         RowBox[{"GrR", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Gr", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"binr", "*", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "0", "]"}], 
            "[", "1", "]"}], "[", "1", "]"}], "[", "t", "]"}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Gr", "[", "t", "]"}], "-", 
           RowBox[{"GrR", "[", "t", "]"}]}], ")"}]}], "-", 
        RowBox[{"unbinr", "*", 
         RowBox[{"Gr", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"GcR", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"binc", "*", 
         RowBox[{"(", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "kk", "]"}], "[", "0", 
                "]"}], "[", "1", "]"}], "[", "1", "]"}], "[", "t", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"kk", ",", "1", ",", "2"}], "}"}]}], "]"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Gc", "[", "t", "]"}], "-", 
           RowBox[{"GcR", "[", "t", "]"}]}], ")"}]}], "-", 
        RowBox[{"unbinc", "*", 
         RowBox[{"GcR", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Gc", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"binc", "*", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "0", "]"}], 
            "[", "1", "]"}], "[", "1", "]"}], "[", "t", "]"}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Gc", "[", "t", "]"}], "-", 
           RowBox[{"GcR", "[", "t", "]"}]}], ")"}]}], "-", 
        RowBox[{"unbinc", "*", 
         RowBox[{"Gc", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"RORE", " ", "activity"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"GBR", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"binrev", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"revn", "[", "t", "]"}], "+", 
           RowBox[{"revng", "[", "t", "]"}], "+", 
           RowBox[{"revngp", "[", "t", "]"}], "+", 
           RowBox[{"revnp", "[", "t", "]"}]}], ")"}], "*", 
         RowBox[{"GB", "[", "t", "]"}]}], "-", 
        RowBox[{"unbinrev", "*", 
         RowBox[{"GBR", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"GB", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "binrev"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"revn", "[", "t", "]"}], "+", 
           RowBox[{"revng", "[", "t", "]"}], "+", 
           RowBox[{"revngp", "[", "t", "]"}], "+", 
           RowBox[{"revnp", "[", "t", "]"}]}], ")"}], "*", 
         RowBox[{"GB", "[", "t", "]"}]}], "+", 
        RowBox[{"unbinrev", "*", 
         RowBox[{"GBR", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"GBRb", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"binrevb", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"revn", "[", "t", "]"}], "+", 
           RowBox[{"revng", "[", "t", "]"}], "+", 
           RowBox[{"revngp", "[", "t", "]"}], "+", 
           RowBox[{"revnp", "[", "t", "]"}]}], ")"}], "*", 
         RowBox[{"GBb", "[", "t", "]"}]}], "-", 
        RowBox[{"unbinrevb", "*", 
         RowBox[{"GBRb", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"GBb", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "binrevb"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"revn", "[", "t", "]"}], "+", 
           RowBox[{"revng", "[", "t", "]"}], "+", 
           RowBox[{"revngp", "[", "t", "]"}], "+", 
           RowBox[{"revnp", "[", "t", "]"}]}], ")"}], "*", 
         RowBox[{"GBb", "[", "t", "]"}]}], "+", 
        RowBox[{"unbinrevb", "*", 
         RowBox[{"GBRb", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "Transcription", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"MnPo", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trPo", "*", 
         RowBox[{"G", "[", "t", "]"}]}], "-", 
        RowBox[{"tmc", "*", 
         RowBox[{"MnPo", "[", "t", "]"}]}], "-", 
        RowBox[{"umPo", "*", 
         RowBox[{"MnPo", "[", "t", "]"}]}], "+", 
        RowBox[{"lono", "*", "19.9", "*", "lta", "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"ltn", "[", "t", "]"}]}], ")"}], "*", "trPo"}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"McPo", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tmc", "*", 
         RowBox[{"MnPo", "[", "t", "]"}]}], "-", 
        RowBox[{"umPo", "*", 
         RowBox[{"McPo", "[", "t", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"MnPt", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trPt", "*", 
         RowBox[{"G", "[", "t", "]"}]}], "-", 
        RowBox[{"tmc", "*", 
         RowBox[{"MnPt", "[", "t", "]"}]}], "-", 
        RowBox[{"umPt", "*", 
         RowBox[{"MnPt", "[", "t", "]"}]}], "+", 
        RowBox[{"lont", "*", "19.9", "*", "lta", "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"ltn", "[", "t", "]"}]}], ")"}], "*", "trPt"}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"McPt", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tmc", "*", 
         RowBox[{"MnPt", "[", "t", "]"}]}], "-", 
        RowBox[{"umPt", "*", 
         RowBox[{"McPt", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"MnRt", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trRt", "*", 
         RowBox[{"Gc", "[", "t", "]"}]}], "-", 
        RowBox[{"tmc", "*", 
         RowBox[{"MnRt", "[", "t", "]"}]}], "-", 
        RowBox[{"umRt", "*", 
         RowBox[{"MnRt", "[", "t", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"McRt", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tmc", "*", 
         RowBox[{"MnRt", "[", "t", "]"}]}], "-", 
        RowBox[{"umRt", "*", 
         RowBox[{"McRt", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"MnRev", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trRev", "*", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "0", "]"}], 
            "[", "1", "]"}], "[", "1", "]"}], "[", "t", "]"}], "*", 
         RowBox[{"Gr", "[", "t", "]"}]}], "-", 
        RowBox[{"tmcrev", "*", 
         RowBox[{"MnRev", "[", "t", "]"}]}], "-", 
        RowBox[{"umRev", "*", 
         RowBox[{"MnRev", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"McRev", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tmcrev", "*", 
         RowBox[{"MnRev", "[", "t", "]"}]}], "-", 
        RowBox[{"umRev", "*", 
         RowBox[{"McRev", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"MnRo", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trRo", "*", 
         RowBox[{"G", "[", "t", "]"}], "*", 
         RowBox[{"GB", "[", "t", "]"}]}], "-", 
        RowBox[{"tmc", "*", 
         RowBox[{"MnRo", "[", "t", "]"}]}], "-", 
        RowBox[{"umRo", "*", 
         RowBox[{"MnRo", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"McRo", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tmc", "*", 
         RowBox[{"MnRo", "[", "t", "]"}]}], "-", 
        RowBox[{"umRo", "*", 
         RowBox[{"McRo", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"MnB", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trB", "*", 
         RowBox[{"GBb", "[", "t", "]"}]}], "-", 
        RowBox[{"tmc", "*", 
         RowBox[{"MnB", "[", "t", "]"}]}], "-", 
        RowBox[{"umB", "*", 
         RowBox[{"MnB", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"McB", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tmc", "*", 
         RowBox[{"MnB", "[", "t", "]"}]}], "-", 
        RowBox[{"umB", "*", 
         RowBox[{"McB", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"MnNp", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trNp", "*", 
         RowBox[{"GB", "[", "t", "]"}]}], "-", 
        RowBox[{"tmc", "*", 
         RowBox[{"MnNp", "[", "t", "]"}]}], "-", 
        RowBox[{"umNp", "*", 
         RowBox[{"MnNp", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"McNp", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tmc", "*", 
         RowBox[{"MnNp", "[", "t", "]"}]}], "-", 
        RowBox[{"umNp", "*", 
         RowBox[{"McNp", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Secondary", " ", "Feedback", " ", "Loop"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"B", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tlb", "*", 
         RowBox[{"McB", "[", "t", "]"}]}], "-", 
        RowBox[{"cbin", "*", 
         RowBox[{"B", "[", "t", "]"}], "*", 
         RowBox[{"Cl", "[", "t", "]"}]}], "+", 
        RowBox[{"uncbin", "*", 
         RowBox[{"BC", "[", "t", "]"}]}], "-", 
        RowBox[{"ub", "*", 
         RowBox[{"B", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Cl", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tlnp", "*", 
         RowBox[{"McNp", "[", "t", "]"}]}], "+", "tlc", "-", 
        RowBox[{"cbin", "*", 
         RowBox[{"B", "[", "t", "]"}], "*", 
         RowBox[{"Cl", "[", "t", "]"}]}], "+", 
        RowBox[{"uncbin", "*", 
         RowBox[{"BC", "[", "t", "]"}]}], "-", 
        RowBox[{"uc", "*", 
         RowBox[{"Cl", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"BC", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"cbin", "*", 
         RowBox[{"B", "[", "t", "]"}], "*", 
         RowBox[{"Cl", "[", "t", "]"}]}], "-", 
        RowBox[{"uncbin", "*", 
         RowBox[{"BC", "[", "t", "]"}]}], "-", 
        RowBox[{"phos", "*", 
         RowBox[{"BC", "[", "t", "]"}]}], "-", 
        RowBox[{"ubc", "*", 
         RowBox[{"BC", "[", "t", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"cyrev", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tlrev", "*", 
         RowBox[{"McRev", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"nlrev", "+", "urev"}], ")"}], "*", 
         RowBox[{"cyrev", "[", "t", "]"}]}], "-", 
        RowBox[{"ag", "*", 
         RowBox[{"cyrev", "[", "t", "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "2", "]"}],
              "[", "0", "]"}], "[", "0", "]"}], "[", "t", "]"}], ")"}]}], "+", 
        RowBox[{"nerev", "*", 
         RowBox[{"revn", "[", "t", "]"}]}], "+", 
        RowBox[{"dg", "*", 
         RowBox[{"cyrevg", "[", "t", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"revn", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"nerev", "+", "urev"}], ")"}]}], "*", 
         RowBox[{"revn", "[", "t", "]"}]}], "-", 
        RowBox[{"ag", "*", "Nf", "*", 
         RowBox[{"revn", "[", "t", "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "2", "]"}],
              "[", "1", "]"}], "[", "0", "]"}], "[", "t", "]"}], ")"}]}], "+", 
        RowBox[{"nlrev", "*", 
         RowBox[{"cyrev", "[", "t", "]"}]}], "+", 
        RowBox[{"dg", "*", 
         RowBox[{"(", 
          RowBox[{"revng", "[", "t", "]"}], ")"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"cyrevg", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"ag", "*", 
         RowBox[{"cyrev", "[", "t", "]"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "2", "]"}], 
            "[", "0", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"dg", "+", 
           RowBox[{"gto", "[", "t", "]"}], "+", "urev", "+", "nlrev"}], ")"}],
          "*", 
         RowBox[{"cyrevg", "[", "t", "]"}]}], "+", 
        RowBox[{"nerev", "*", 
         RowBox[{"revng", "[", "t", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"revng", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"ag", "*", "Nf", "*", 
         RowBox[{"revn", "[", "t", "]"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "2", "]"}], 
            "[", "1", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"dg", "+", 
           RowBox[{"gto", "[", "t", "]"}], "+", "urev", "+", "nerev"}], ")"}],
          "*", 
         RowBox[{"revng", "[", "t", "]"}]}], "+", 
        RowBox[{"nlrev", "*", 
         RowBox[{"cyrevg", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{
        RowBox[{"cyrevgp", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"gto", "[", "t", "]"}], "*", 
         RowBox[{"cyrevg", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"dg", "+", "uprev", "+", "nlrev"}], ")"}], "*", 
         RowBox[{"cyrevgp", "[", "t", "]"}]}], "+", 
        RowBox[{"nerev", "*", 
         RowBox[{"revngp", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{
        RowBox[{"revngp", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"gto", "[", "t", "]"}], "*", 
         RowBox[{"revng", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"dg", "+", "uprev", "+", "nerev"}], ")"}], "*", 
         RowBox[{"revngp", "[", "t", "]"}]}], "+", 
        RowBox[{"nlrev", "*", 
         RowBox[{"cyrevgp", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"cyrevp", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"dg", "*", 
         RowBox[{"(", 
          RowBox[{"cyrevgp", "[", "t", "]"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"uprev", "+", "nlrev"}], ")"}], "*", 
         RowBox[{"cyrevp", "[", "t", "]"}]}], "+", 
        RowBox[{"nerev", "*", 
         RowBox[{"revnp", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"revnp", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"dg", "*", 
         RowBox[{"(", 
          RowBox[{"revngp", "[", "t", "]"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"uprev", "+", "nerev"}], ")"}], "*", 
         RowBox[{"revnp", "[", "t", "]"}]}], "+", 
        RowBox[{"nlrev", "*", 
         RowBox[{"cyrevp", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Activity", " ", "of", " ", "GSK3b"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"gto", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trgto", "*", 
         RowBox[{"G", "[", "t", "]"}], "*", 
         RowBox[{"GB", "[", "t", "]"}]}], "-", 
        RowBox[{"ugto", "*", 
         RowBox[{"gto", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "Light", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"ltn", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"60", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"lta", "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"ltn", "[", "t", "]"}]}], ")"}]}], "-", 
          RowBox[{"ltb", "*", 
           RowBox[{"ltn", "[", "t", "]"}]}]}], ")"}]}]}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Newly", " ", "added", " ", "equations"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Free", " ", "Blood", " ", "Plsma", " ", "Concentration"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"pInh", "'"}], "[", "t", "]"}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"uinp", "+", "nlpin"}], ")"}]}], "*", 
         RowBox[{"pInh", "[", "t", "]"}]}], "+", 
        RowBox[{"nepin", "*", 
         RowBox[{"bInh", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Free", " ", "Brain", " ", "Tissue", " ", "Concentration"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"bInh", "'"}], "[", "t", "]"}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"nlbin", "+", "nepin"}], ")"}]}], "*", 
         RowBox[{"bInh", "[", "t", "]"}]}], "+", 
        RowBox[{"nlpin", "*", 
         RowBox[{"pInh", "[", "t", "]"}]}], "+", 
        RowBox[{"nebin", "*", 
         RowBox[{"Inh", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Free", " ", "Cytoplasm", " ", "Concentration"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Inh", "'"}], "[", "t", "]"}], "==", 
       RowBox[{
        RowBox[{"nlbin", "*", 
         RowBox[{"bInh", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"nebin", "+", "nlin"}], ")"}], "*", 
         RowBox[{"Inh", "[", "t", "]"}]}], "+", 
        RowBox[{"nein", "*", 
         RowBox[{"nInh", "[", "t", "]"}]}], "+", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "inbin"}], "*", 
          RowBox[{"Inh", "[", "t", "]"}], "*", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "ll", 
                "]"}], "[", "0", "]"}], "[", "0", "]"}], "[", "t", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"jj", ",", "0", ",", "6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"kk", ",", "0", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"ll", ",", "1", ",", "3", ",", "2"}], "}"}]}], "]"}]}], 
         ")"}], "+", 
        RowBox[{"inubin", "*", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "ll", 
               "]"}], "[", "0", "]"}], "[", "0", "]"}], "[", "t", "]"}], ",", 
           
           RowBox[{"{", 
            RowBox[{"jj", ",", "0", ",", "6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"kk", ",", "0", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"ll", ",", "4", ",", "5"}], "}"}]}], "]"}]}]}]}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Free", " ", "Nucleus", " ", "Concentration"}], "*)"}], 
      RowBox[{
       RowBox[{
        RowBox[{"nInh", "'"}], "[", "t", "]"}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"Inh", "[", "t", "]"}], "*", "nlin"}], "-", 
        RowBox[{
         RowBox[{"(", "nein", ")"}], "*", 
         RowBox[{"nInh", "[", "t", "]"}]}], "-", 
        RowBox[{"(", 
         RowBox[{"inbin", "*", "Nf", "*", 
          RowBox[{"nInh", "[", "t", "]"}], "*", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "ll", 
                "]"}], "[", "1", "]"}], "[", "nn", "]"}], "[", "t", "]"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{"jj", ",", "0", ",", "6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"kk", ",", "0", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"ll", ",", "1", ",", "3", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"nn", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ")"}], "+", 
        RowBox[{"inubin", "*", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "ll", 
               "]"}], "[", "1", "]"}], "[", "nn", "]"}], "[", "t", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"jj", ",", "0", ",", "6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"kk", ",", "0", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"ll", ",", "4", ",", "5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"nn", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}]}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.566138785433442*^9, 3.566138853703446*^9}, 
   3.566173500816382*^9}],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"Extended", " ", "Equations", " ", "for", " ", "Single"}], "-", 
   RowBox[{
   "state", " ", "Variables", " ", "when", " ", "light", " ", "is", " ", 
    "off"}]}], "Subsubtitle"]], "Input",
 CellChangeTimes->{{3.5661735221458197`*^9, 3.566173522592857*^9}, {
  3.572223906394858*^9, 3.572223906792968*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"daone", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Original", " ", "model", " ", "equations"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"E", "-", 
       RowBox[{"box", " ", "activity"}]}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"GR", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"bin", "*", 
         RowBox[{"(", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "kk", "]"}], "[", "0", 
                "]"}], "[", "1", "]"}], "[", "1", "]"}], "[", "t", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"kk", ",", "1", ",", "2"}], "}"}]}], "]"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"G", "[", "t", "]"}], "-", 
           RowBox[{"GR", "[", "t", "]"}]}], ")"}]}], "-", 
        RowBox[{"unbin", "*", 
         RowBox[{"GR", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"G", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"bin", "*", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "0", "]"}], 
            "[", "1", "]"}], "[", "1", "]"}], "[", "t", "]"}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"G", "[", "t", "]"}], "-", 
           RowBox[{"GR", "[", "t", "]"}]}], ")"}]}], "-", 
        RowBox[{"unbin", "*", 
         RowBox[{"G", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"GrR", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"binr", "*", 
         RowBox[{"(", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "kk", "]"}], "[", "0", 
                "]"}], "[", "1", "]"}], "[", "1", "]"}], "[", "t", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"kk", ",", "1", ",", "2"}], "}"}]}], "]"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Gr", "[", "t", "]"}], "-", 
           RowBox[{"GrR", "[", "t", "]"}]}], ")"}]}], "-", 
        RowBox[{"unbinr", "*", 
         RowBox[{"GrR", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Gr", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"binr", "*", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "0", "]"}], 
            "[", "1", "]"}], "[", "1", "]"}], "[", "t", "]"}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Gr", "[", "t", "]"}], "-", 
           RowBox[{"GrR", "[", "t", "]"}]}], ")"}]}], "-", 
        RowBox[{"unbinr", "*", 
         RowBox[{"Gr", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"GcR", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"binc", "*", 
         RowBox[{"(", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "kk", "]"}], "[", "0", 
                "]"}], "[", "1", "]"}], "[", "1", "]"}], "[", "t", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"kk", ",", "1", ",", "2"}], "}"}]}], "]"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Gc", "[", "t", "]"}], "-", 
           RowBox[{"GcR", "[", "t", "]"}]}], ")"}]}], "-", 
        RowBox[{"unbinc", "*", 
         RowBox[{"GcR", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Gc", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"binc", "*", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "0", "]"}], 
            "[", "1", "]"}], "[", "1", "]"}], "[", "t", "]"}], "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Gc", "[", "t", "]"}], "-", 
           RowBox[{"GcR", "[", "t", "]"}]}], ")"}]}], "-", 
        RowBox[{"unbinc", "*", 
         RowBox[{"Gc", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"RORE", " ", "activity"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"GBR", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"binrev", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"revn", "[", "t", "]"}], "+", 
           RowBox[{"revng", "[", "t", "]"}], "+", 
           RowBox[{"revngp", "[", "t", "]"}], "+", 
           RowBox[{"revnp", "[", "t", "]"}]}], ")"}], "*", 
         RowBox[{"GB", "[", "t", "]"}]}], "-", 
        RowBox[{"unbinrev", "*", 
         RowBox[{"GBR", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"GB", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "binrev"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"revn", "[", "t", "]"}], "+", 
           RowBox[{"revng", "[", "t", "]"}], "+", 
           RowBox[{"revngp", "[", "t", "]"}], "+", 
           RowBox[{"revnp", "[", "t", "]"}]}], ")"}], "*", 
         RowBox[{"GB", "[", "t", "]"}]}], "+", 
        RowBox[{"unbinrev", "*", 
         RowBox[{"GBR", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"GBRb", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"binrevb", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"revn", "[", "t", "]"}], "+", 
           RowBox[{"revng", "[", "t", "]"}], "+", 
           RowBox[{"revngp", "[", "t", "]"}], "+", 
           RowBox[{"revnp", "[", "t", "]"}]}], ")"}], "*", 
         RowBox[{"GBb", "[", "t", "]"}]}], "-", 
        RowBox[{"unbinrevb", "*", 
         RowBox[{"GBRb", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"GBb", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "binrevb"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"revn", "[", "t", "]"}], "+", 
           RowBox[{"revng", "[", "t", "]"}], "+", 
           RowBox[{"revngp", "[", "t", "]"}], "+", 
           RowBox[{"revnp", "[", "t", "]"}]}], ")"}], "*", 
         RowBox[{"GBb", "[", "t", "]"}]}], "+", 
        RowBox[{"unbinrevb", "*", 
         RowBox[{"GBRb", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "Transcription", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"MnPo", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trPo", "*", 
         RowBox[{"G", "[", "t", "]"}]}], "-", 
        RowBox[{"tmc", "*", 
         RowBox[{"MnPo", "[", "t", "]"}]}], "-", 
        RowBox[{"umPo", "*", 
         RowBox[{"MnPo", "[", "t", "]"}]}], "+", 
        RowBox[{"0", "*", "lono", "*", "19.9", "*", "lta", "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"ltn", "[", "t", "]"}]}], ")"}], "*", "trPo"}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"McPo", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tmc", "*", 
         RowBox[{"MnPo", "[", "t", "]"}]}], "-", 
        RowBox[{"umPo", "*", 
         RowBox[{"McPo", "[", "t", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"MnPt", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trPt", "*", 
         RowBox[{"G", "[", "t", "]"}]}], "-", 
        RowBox[{"tmc", "*", 
         RowBox[{"MnPt", "[", "t", "]"}]}], "-", 
        RowBox[{"umPt", "*", 
         RowBox[{"MnPt", "[", "t", "]"}]}], "+", 
        RowBox[{"0", "*", "lont", "*", "19.9", "*", "lta", "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"ltn", "[", "t", "]"}]}], ")"}], "*", "trPt"}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"McPt", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tmc", "*", 
         RowBox[{"MnPt", "[", "t", "]"}]}], "-", 
        RowBox[{"umPt", "*", 
         RowBox[{"McPt", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"MnRt", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trRt", "*", 
         RowBox[{"Gc", "[", "t", "]"}]}], "-", 
        RowBox[{"tmc", "*", 
         RowBox[{"MnRt", "[", "t", "]"}]}], "-", 
        RowBox[{"umRt", "*", 
         RowBox[{"MnRt", "[", "t", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"McRt", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tmc", "*", 
         RowBox[{"MnRt", "[", "t", "]"}]}], "-", 
        RowBox[{"umRt", "*", 
         RowBox[{"McRt", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"MnRev", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trRev", "*", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "0", "]"}], 
            "[", "1", "]"}], "[", "1", "]"}], "[", "t", "]"}], "*", 
         RowBox[{"Gr", "[", "t", "]"}]}], "-", 
        RowBox[{"tmcrev", "*", 
         RowBox[{"MnRev", "[", "t", "]"}]}], "-", 
        RowBox[{"umRev", "*", 
         RowBox[{"MnRev", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"McRev", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tmcrev", "*", 
         RowBox[{"MnRev", "[", "t", "]"}]}], "-", 
        RowBox[{"umRev", "*", 
         RowBox[{"McRev", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"MnRo", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trRo", "*", 
         RowBox[{"G", "[", "t", "]"}], "*", 
         RowBox[{"GB", "[", "t", "]"}]}], "-", 
        RowBox[{"tmc", "*", 
         RowBox[{"MnRo", "[", "t", "]"}]}], "-", 
        RowBox[{"umRo", "*", 
         RowBox[{"MnRo", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"McRo", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tmc", "*", 
         RowBox[{"MnRo", "[", "t", "]"}]}], "-", 
        RowBox[{"umRo", "*", 
         RowBox[{"McRo", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"MnB", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trB", "*", 
         RowBox[{"GBb", "[", "t", "]"}]}], "-", 
        RowBox[{"tmc", "*", 
         RowBox[{"MnB", "[", "t", "]"}]}], "-", 
        RowBox[{"umB", "*", 
         RowBox[{"MnB", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"McB", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tmc", "*", 
         RowBox[{"MnB", "[", "t", "]"}]}], "-", 
        RowBox[{"umB", "*", 
         RowBox[{"McB", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"MnNp", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trNp", "*", 
         RowBox[{"GB", "[", "t", "]"}]}], "-", 
        RowBox[{"tmc", "*", 
         RowBox[{"MnNp", "[", "t", "]"}]}], "-", 
        RowBox[{"umNp", "*", 
         RowBox[{"MnNp", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"McNp", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tmc", "*", 
         RowBox[{"MnNp", "[", "t", "]"}]}], "-", 
        RowBox[{"umNp", "*", 
         RowBox[{"McNp", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Secondary", " ", "Feedback", " ", "Loop"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"B", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tlb", "*", 
         RowBox[{"McB", "[", "t", "]"}]}], "-", 
        RowBox[{"cbin", "*", 
         RowBox[{"B", "[", "t", "]"}], "*", 
         RowBox[{"Cl", "[", "t", "]"}]}], "+", 
        RowBox[{"uncbin", "*", 
         RowBox[{"BC", "[", "t", "]"}]}], "-", 
        RowBox[{"ub", "*", 
         RowBox[{"B", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Cl", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tlnp", "*", 
         RowBox[{"McNp", "[", "t", "]"}]}], "+", "tlc", "-", 
        RowBox[{"cbin", "*", 
         RowBox[{"B", "[", "t", "]"}], "*", 
         RowBox[{"Cl", "[", "t", "]"}]}], "+", 
        RowBox[{"uncbin", "*", 
         RowBox[{"BC", "[", "t", "]"}]}], "-", 
        RowBox[{"uc", "*", 
         RowBox[{"Cl", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"BC", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"cbin", "*", 
         RowBox[{"B", "[", "t", "]"}], "*", 
         RowBox[{"Cl", "[", "t", "]"}]}], "-", 
        RowBox[{"uncbin", "*", 
         RowBox[{"BC", "[", "t", "]"}]}], "-", 
        RowBox[{"phos", "*", 
         RowBox[{"BC", "[", "t", "]"}]}], "-", 
        RowBox[{"ubc", "*", 
         RowBox[{"BC", "[", "t", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"cyrev", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"tlrev", "*", 
         RowBox[{"McRev", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"nlrev", "+", "urev"}], ")"}], "*", 
         RowBox[{"cyrev", "[", "t", "]"}]}], "-", 
        RowBox[{"ag", "*", 
         RowBox[{"cyrev", "[", "t", "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "2", "]"}],
              "[", "0", "]"}], "[", "0", "]"}], "[", "t", "]"}], ")"}]}], "+", 
        RowBox[{"nerev", "*", 
         RowBox[{"revn", "[", "t", "]"}]}], "+", 
        RowBox[{"dg", "*", 
         RowBox[{"cyrevg", "[", "t", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"revn", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"nerev", "+", "urev"}], ")"}]}], "*", 
         RowBox[{"revn", "[", "t", "]"}]}], "-", 
        RowBox[{"ag", "*", "Nf", "*", 
         RowBox[{"revn", "[", "t", "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "2", "]"}],
              "[", "1", "]"}], "[", "0", "]"}], "[", "t", "]"}], ")"}]}], "+", 
        RowBox[{"nlrev", "*", 
         RowBox[{"cyrev", "[", "t", "]"}]}], "+", 
        RowBox[{"dg", "*", 
         RowBox[{"(", 
          RowBox[{"revng", "[", "t", "]"}], ")"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"cyrevg", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"ag", "*", 
         RowBox[{"cyrev", "[", "t", "]"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "2", "]"}], 
            "[", "0", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"dg", "+", 
           RowBox[{"gto", "[", "t", "]"}], "+", "urev", "+", "nlrev"}], ")"}],
          "*", 
         RowBox[{"cyrevg", "[", "t", "]"}]}], "+", 
        RowBox[{"nerev", "*", 
         RowBox[{"revng", "[", "t", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"revng", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"ag", "*", "Nf", "*", 
         RowBox[{"revn", "[", "t", "]"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "2", "]"}], 
            "[", "1", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"dg", "+", 
           RowBox[{"gto", "[", "t", "]"}], "+", "urev", "+", "nerev"}], ")"}],
          "*", 
         RowBox[{"revng", "[", "t", "]"}]}], "+", 
        RowBox[{"nlrev", "*", 
         RowBox[{"cyrevg", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{
        RowBox[{"cyrevgp", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"gto", "[", "t", "]"}], "*", 
         RowBox[{"cyrevg", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"dg", "+", "uprev", "+", "nlrev"}], ")"}], "*", 
         RowBox[{"cyrevgp", "[", "t", "]"}]}], "+", 
        RowBox[{"nerev", "*", 
         RowBox[{"revngp", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      
      RowBox[{
       RowBox[{
        RowBox[{"revngp", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"gto", "[", "t", "]"}], "*", 
         RowBox[{"revng", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"dg", "+", "uprev", "+", "nerev"}], ")"}], "*", 
         RowBox[{"revngp", "[", "t", "]"}]}], "+", 
        RowBox[{"nlrev", "*", 
         RowBox[{"cyrevgp", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"cyrevp", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"dg", "*", 
         RowBox[{"(", 
          RowBox[{"cyrevgp", "[", "t", "]"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"uprev", "+", "nlrev"}], ")"}], "*", 
         RowBox[{"cyrevp", "[", "t", "]"}]}], "+", 
        RowBox[{"nerev", "*", 
         RowBox[{"revnp", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"revnp", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"dg", "*", 
         RowBox[{"(", 
          RowBox[{"revngp", "[", "t", "]"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"uprev", "+", "nerev"}], ")"}], "*", 
         RowBox[{"revnp", "[", "t", "]"}]}], "+", 
        RowBox[{"nlrev", "*", 
         RowBox[{"cyrevp", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Activity", " ", "of", " ", "GSK3b"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"gto", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"trgto", "*", 
         RowBox[{"G", "[", "t", "]"}], "*", 
         RowBox[{"GB", "[", "t", "]"}]}], "-", 
        RowBox[{"ugto", "*", 
         RowBox[{"gto", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "Light", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"ltn", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"-", "ltb"}], "*", 
        RowBox[{"ltn", "[", "t", "]"}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Newly", " ", "added", " ", "equations"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Free", " ", "Blood", " ", "Plsma", " ", "Concentration"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"pInh", "'"}], "[", "t", "]"}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"uinp", "+", "nlpin"}], ")"}]}], "*", 
         RowBox[{"pInh", "[", "t", "]"}]}], "+", 
        RowBox[{"nepin", "*", 
         RowBox[{"bInh", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Free", " ", "Brain", " ", "Tissue", " ", "Concentration"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"bInh", "'"}], "[", "t", "]"}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"nlbin", "+", "nepin"}], ")"}]}], "*", 
         RowBox[{"bInh", "[", "t", "]"}]}], "+", 
        RowBox[{"nlpin", "*", 
         RowBox[{"pInh", "[", "t", "]"}]}], "+", 
        RowBox[{"nebin", "*", 
         RowBox[{"Inh", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Free", " ", "Cytoplasm", " ", "Concentration"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Inh", "'"}], "[", "t", "]"}], "==", 
       RowBox[{
        RowBox[{"nlbin", "*", 
         RowBox[{"bInh", "[", "t", "]"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"nebin", "+", "nlin"}], ")"}], "*", 
         RowBox[{"Inh", "[", "t", "]"}]}], "+", 
        RowBox[{"nein", "*", 
         RowBox[{"nInh", "[", "t", "]"}]}], "+", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "inbin"}], "*", 
          RowBox[{"Inh", "[", "t", "]"}], "*", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "ll", 
                "]"}], "[", "0", "]"}], "[", "0", "]"}], "[", "t", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"jj", ",", "0", ",", "6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"kk", ",", "0", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"ll", ",", "1", ",", "3", ",", "2"}], "}"}]}], "]"}]}], 
         ")"}], "+", 
        RowBox[{"inubin", "*", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "ll", 
               "]"}], "[", "0", "]"}], "[", "0", "]"}], "[", "t", "]"}], ",", 
           
           RowBox[{"{", 
            RowBox[{"jj", ",", "0", ",", "6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"kk", ",", "0", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"ll", ",", "4", ",", "5"}], "}"}]}], "]"}]}]}]}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Free", " ", "Nucleus", " ", "Concentration"}], "*)"}], 
      RowBox[{
       RowBox[{
        RowBox[{"nInh", "'"}], "[", "t", "]"}], "==", 
       RowBox[{
        RowBox[{
         RowBox[{"Inh", "[", "t", "]"}], "*", "nlin"}], "-", 
        RowBox[{
         RowBox[{"(", "nein", ")"}], "*", 
         RowBox[{"nInh", "[", "t", "]"}]}], "-", 
        RowBox[{"(", 
         RowBox[{"inbin", "*", "Nf", "*", 
          RowBox[{"nInh", "[", "t", "]"}], "*", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "ll", 
                "]"}], "[", "1", "]"}], "[", "nn", "]"}], "[", "t", "]"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{"jj", ",", "0", ",", "6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"kk", ",", "0", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"ll", ",", "1", ",", "3", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"nn", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ")"}], "+", 
        RowBox[{"inubin", "*", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "ll", 
               "]"}], "[", "1", "]"}], "[", "nn", "]"}], "[", "t", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"jj", ",", "0", ",", "6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"kk", ",", "0", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"ll", ",", "4", ",", "5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"nn", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}]}]}], 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.566138785433442*^9, 3.566138853703446*^9}, {
   3.566144139267209*^9, 3.5661441404979486`*^9}, {3.5661441958093777`*^9, 
   3.566144210714425*^9}, 3.566150525848299*^9, {3.566152499137088*^9, 
   3.566152529858076*^9}, 3.566154525235327*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   StyleBox[
    RowBox[{
     RowBox[{"Extended", " ", "Equations", " ", "for", " ", "Multi"}], "-", 
     RowBox[{"state", " ", "Variables"}]}], "Subsubtitle"], 
   "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Detailed", " ", "description", " ", "of", " ", "multi"}], 
        "-", 
        RowBox[{"state", " ", "variables", " ", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", "]"}], 
           "[", "m", "]"}], "[", "n", "]"}], " ", "can", " ", "be", " ", 
         "found", " ", "in", " ", "Kim"}]}], "&"}], "Forge"}], ",", " ", 
     RowBox[{"MSB", " ", "2012."}]}], "Subsubtitle"], 
   StyleBox[" ", "Subsubtitle"], 
   StyleBox["\[IndentingNewLine]", "Subsubtitle"], 
   StyleBox[
    RowBox[{
     RowBox[{"Newly", " ", "added", " ", "variables", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "4", "]"}], "[",
         "m", "]"}], "[", "n", "]"}], "  ", "and", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "5", "]"}], "[",
         "m", "]"}], "[", "n", "]"}], " ", "represent", " ", "CK1", " ", 
      "bound", " ", "CK1", " ", "inhibitor", " ", "and", " ", 
      RowBox[{"GSK3b", ":", 
       RowBox[{
       "CK1", " ", "bound", " ", "to", " ", "CK1", " ", "inhibitor"}]}]}], 
     ",", 
     RowBox[{"repsectively", ".", " "}]}], "Subsubtitle"]}]}]], "Input",
 CellChangeTimes->{{3.5661380716301937`*^9, 3.566138078216537*^9}, 
   3.566138717740789*^9, {3.566174378162181*^9, 3.566174421096039*^9}},
 EmphasizeSyntaxErrors->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"atwo", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", "]"}], 
           "[", "m", "]"}], "[", "n", "]"}], "'"}], "[", "t", "]"}], 
       "\[Equal]", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"CK1", "-", 
         RowBox[{"CK1", " ", "Inhibitor", " ", 
          RowBox[{"Binidng", "/", "Unbinidng"}]}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "inbin"}], "*", 
            RowBox[{"Inh", "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{"inubin", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "4", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "3"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "inbin"}], "*", 
            RowBox[{"Inh", "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{"inubin", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "5", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "4"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"inbin", "*", 
            RowBox[{"Inh", "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "1", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"inubin", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "5"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"inbin", "*", 
            RowBox[{"Inh", "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "3", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"inubin", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "inbin"}], "*", "Nf", "*", 
            RowBox[{"nInh", "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{"inubin", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "4", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "3"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "inbin"}], "*", "Nf", "*", 
            RowBox[{"nInh", "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{"inubin", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "5", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "4"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"inbin", "*", "Nf", "*", 
            RowBox[{"nInh", "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "1", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"inubin", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "5"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"inbin", "*", "Nf", "*", 
            RowBox[{"nInh", "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "3", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"inubin", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", "Trnaslation", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{"tlp", "*", 
           RowBox[{"McPo", "[", "t", "]"}]}], ",", "0"}], "]"}], "+", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "3"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{"tlp", "*", 
           RowBox[{"McPt", "[", "t", "]"}]}], ",", "0"}], "]"}], "+", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{"tlr", "*", 
           RowBox[{"McRo", "[", "t", "]"}]}], ",", "0"}], "]"}], "+", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{"tlr", "*", 
           RowBox[{"McRt", "[", "t", "]"}]}], ",", "0"}], "]"}], "+", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"PER", "-", 
          RowBox[{"CRY", " ", 
           RowBox[{"Binidng", "/", "Unbinidng"}]}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "2"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "4"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "5"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "6"}], ")"}]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ar"}], "*", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}], 
            "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "0", "]"}], "[", "kk", "]"}], "[", "0", 
                  "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "1", ",", "2"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"dr", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "j", "]"}], "[", "kk", "]"}], "[", "l", 
                  "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "1", ",", "2"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"k", "\[Equal]", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"k", "\[Equal]", "2"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ar"}], "*", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}], 
            "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "4", ",", "5", ",", "6"}], "}"}]}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "0", ",", "5"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"dr", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "k", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "4", ",", "5", ",", "6"}], "}"}]}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "0", ",", "5"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "2"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "4"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "5"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "6"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"k", "\[Equal]", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"k", "\[Equal]", "2"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"ar", "*", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}], 
            "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "k", "]"}], "[", "0", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "0", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"dr", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "2"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "4"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "5"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "6"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ar"}], "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "0", "]"}], "[", "kk", "]"}], "[", "0", 
                  "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "1", ",", "2"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"dr", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "j", "]"}], "[", "kk", "]"}], "[", "l", 
                  "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "1", ",", "2"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"k", "\[Equal]", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"k", "\[Equal]", "2"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ar"}], "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "4", ",", "5", ",", "6"}], "}"}]}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "0", ",", "5"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"dr", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "k", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "4", ",", "5", ",", "6"}], "}"}]}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "0", ",", "5"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "2"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "4"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "5"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "6"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"k", "\[Equal]", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"k", "\[Equal]", "2"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"ar", "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "0", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "k", "]"}], "[", "0", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"dr", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "2"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "4"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "5"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "6"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ar"}], "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "0", "]"}], "[", "kk", "]"}], "[", "0", 
                  "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "1", ",", "2"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"dr", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "j", "]"}], "[", "kk", "]"}], "[", "l", 
                  "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "1", ",", "2"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"k", "\[Equal]", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"k", "\[Equal]", "2"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ar"}], "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "4", ",", "5", ",", "6"}], "}"}]}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "0", ",", "5"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"dr", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "k", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "4", ",", "5", ",", "6"}], "}"}]}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "0", ",", "5"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "2"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "4"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "5"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "6"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"k", "\[Equal]", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"k", "\[Equal]", "2"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"ar", "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "0", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "k", "]"}], "[", "0", 
                "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"dr", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"PER", "-", 
          RowBox[{"CKI", " ", 
           RowBox[{"Binidng", "/", "Unbinidng"}]}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"j", ">", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ac"}], "*", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}], 
            "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "1", ",", "4", ",", "3"}], "}"}]}], "]"}]}],
            "+", 
           RowBox[{"dc", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "1", ",", "4", ",", "3"}], "}"}]}], 
             "]"}]}]}], ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "4"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ac"}], "*", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}], 
            "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "0", 
                  "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "1", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"dc", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "l", 
                  "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "1", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "4"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"ac", "*", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}], 
            "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "0", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"dc", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"j", ">", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ac"}], "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "1", ",", "4", ",", "3"}], "}"}]}], "]"}]}],
            "+", 
           RowBox[{"dc", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "1", ",", "4", ",", "3"}], "}"}]}], 
             "]"}]}]}], ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "4"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ac"}], "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "0", 
                  "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "1", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"dc", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "l", 
                  "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "1", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "4"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"ac", "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "0", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"dc", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ac"}], "*", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}], 
            "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "1", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{"dc", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "3", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ac"}], "*", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}], 
            "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "2", 
                  "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "3", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"dc", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "3", 
                  "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "3", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "3"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"ac", "*", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}], 
            "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "2", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "1", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"dc", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ac"}], "*", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}], 
            "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "4", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{"dc", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "5", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "4"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ac"}], "*", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}], 
            "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "2", 
                  "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "3", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"dc", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "5", 
                  "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "3", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "5"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"ac", "*", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}], 
            "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "2", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "4", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"dc", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"j", ">", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ac"}], "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "1", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{"dc", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "3", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ac"}], "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "2", 
                  "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "3", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"dc", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "3", 
                  "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "3", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "3"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"ac", "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "1", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "2", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"dc", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"j", ">", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ac"}], "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "4", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{"dc", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "5", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "4"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ac"}], "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "j", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "2", 
                  "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "3", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"dc", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "5", 
                  "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "3", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "5"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"ac", "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "4", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "2", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"dc", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"PER", "-", 
          RowBox[{"GSK3b", " ", 
           RowBox[{"Binidng", "/", "Unbinidng"}]}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "0"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "1"}], ")"}]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}]}],
             "*", "agp", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "2", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{"dg", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", 
                RowBox[{"l", "+", "2"}], "]"}], "[", "m", "]"}], "[", "n", 
              "]"}], "[", "t", "]"}]}]}], ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "4"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}]}],
             "*", "agp", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "2", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{"dg", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "5", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "2"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "3"}], ")"}]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}], 
            "*", "agp", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", 
                RowBox[{"l", "-", "2"}], "]"}], "[", "m", "]"}], "[", "n", 
              "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "2", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"dg", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "5"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}], 
            "*", "agp", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "4", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "2", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"dg", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"m", "\[Equal]", "1"}], ",", "Nf", ",", "1"}], "]"}]}],
             "*", "agp", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "ll",
                   "]"}], "[", "m", "]"}], "[", "nn", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "3", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1", ",", "4"}], "}"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"nn", ",", "0", ",", "1"}], "}"}]}], "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{"dg", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "ll",
                   "]"}], "[", "m", "]"}], "[", "nn", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "3", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "3", ",", "5"}], "}"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"nn", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"PER", "-", "BMAL1", "-", 
          RowBox[{
           RowBox[{"CLOCK", "/", "NPAS2"}], " ", 
           RowBox[{"Binding", "/", "Unbinding"}]}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "bbin"}], "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "0", 
                "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{"unbbin", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", ">", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "bbin"}], "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "0", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "ll",
                   "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "1", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "0", ",", "5"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"unbbin", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "kk", "]"}], "[", "ll",
                   "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "1", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "0", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "0", ",", "5"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", ">", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"bbin", "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "0", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"unbbin", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"CRY", "-", "BMAL1", "-", 
          RowBox[{
           RowBox[{"CLOCK", "/", "NPAS2"}], " ", 
           RowBox[{"Binding", "/", "Unbinding"}]}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", ">", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "cbbin"}], "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "0", 
                "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{"uncbbin", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "cbbin"}], "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "0", "]"}], "[", "kk", "]"}], "[", "0", 
                  "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "1", ",", "2"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"uncbbin", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "0", "]"}], "[", "kk", "]"}], "[", "0", 
                  "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"kk", ",", "1", ",", "2"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", ">", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"cbbin", "*", "Nf", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "0", "]"}], "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "0", "]"}], "[", "0", "]"}], "[", "0", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{"uncbbin", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"REV", "-", "ERBs", "-", 
          RowBox[{"GSK3b", " ", 
           RowBox[{"Binding", "/", "Unbinding"}]}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ag"}], "*", 
            RowBox[{"cyrev", "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{
            RowBox[{"(", "dg", ")"}], "*", 
            RowBox[{"cyrevg", "[", "t", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", "dg", ")"}], "*", 
            RowBox[{"cyrevgp", "[", "t", "]"}]}]}], ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ag"}], "*", "Nf", "*", 
            RowBox[{"revn", "[", "t", "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{
            RowBox[{"(", "dg", ")"}], "*", 
            RowBox[{"revng", "[", "t", "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", "dg", ")"}], "*", 
            RowBox[{"revngp", "[", "t", "]"}]}]}], ",", "0"}], "]"}], "+", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "PER", " ", "Binding", " ", "Protiens", " ", "Subcellular", " ", 
          "Translocation"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "2"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "4"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "5"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "6"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "ne"}], "*", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"n", "\[Equal]", "0"}], ")"}], ",", "1", ",", "0"}], 
             "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"n", "\[Equal]", "0"}], ")"}], ",", "1", ",", "0"}], 
             "]"}], "*", "nl", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "0", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "2"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "4"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "5"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "6"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"ne", "*", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"n", "\[Equal]", "0"}], ")"}], ",", "1", ",", "0"}], 
             "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "1", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "-", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"n", "\[Equal]", "0"}], ")"}], ",", "1", ",", "0"}], 
             "]"}], "*", "nl", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"BMAL1", "-", 
          RowBox[{
           RowBox[{"CLOCK", "/", "NPAS2"}], " ", "Subcellular", " ", 
           "Translocation"}]}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{"nlbc", "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "0", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", "nlbc"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"Kinase", " ", "Subcellular", " ", "Translocation"}], "*)"}],
         "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "2"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", "lne"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "2"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{"lne", "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "1", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"CK1", "-", 
          RowBox[{
          "CK1", " ", "inhibitor", " ", "Complex", " ", "Subcellular", " ", 
           "Translocation"}]}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"(", 
             RowBox[{"l", "\[Equal]", "4"}], ")"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", "lnei"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"(", 
             RowBox[{"l", "\[Equal]", "4"}], ")"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{"lnei", "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "1", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"PER", " ", "Phosphorylation", " ", "with", " ", "CKI"}], 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"(", 
             RowBox[{"j", "\[Equal]", "1"}], ")"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", "hoo"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"(", 
             RowBox[{"j", "\[Equal]", "2"}], ")"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"+", "hoo"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "1", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "3"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "5"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "3"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", "hto"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "4"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "6"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "3"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{"hto", "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", 
                 RowBox[{"j", "-", "1"}], "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"PER2", " ", "Phosphorylation", " ", "with", " ", "GSK3b"}], 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "3"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "4"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "2"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "3"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "5"}], ")"}]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"gto", "[", "t", "]"}]}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "5"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "\[Equal]", "6"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "2"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "3"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"l", "\[Equal]", "5"}], ")"}]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"gto", "[", "t", "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", 
                 RowBox[{"j", "-", "2"}], "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"BMAL", "-", 
          RowBox[{
           RowBox[{"CLCOK", "/", "NPAS2"}], " ", "Phosphorylation", " ", 
           "with", " ", "GSK3b"}]}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{"phos", "*", 
           RowBox[{"BC", "[", "t", "]"}]}], ",", "0"}], "]"}], "+", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"CRY", " ", "Degradation"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", "uro"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", "urt"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", "uro"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", "urt"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"uro", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "1", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
           "+", 
           RowBox[{"urt", "*", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "2", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"PER", " ", "Degradation"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"j", "==", "1"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "==", "3"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "==", "5"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "==", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"m", "==", "0"}], ")"}], "&&", 
               RowBox[{"(", 
                RowBox[{"n", "==", "1"}], ")"}]}], ",", "0", ",", "1"}], 
             "]"}]}], "*", "upu", "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"(", 
             RowBox[{"j", "==", "2"}], ")"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "==", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"m", "==", "0"}], ")"}], "&&", 
               RowBox[{"(", 
                RowBox[{"n", "==", "1"}], ")"}]}], ",", "0", ",", "1"}], 
             "]"}]}], "*", "up", "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"j", "==", "4"}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{"j", "==", "6"}], ")"}]}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "==", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"m", "==", "0"}], ")"}], "&&", 
               RowBox[{"(", 
                RowBox[{"n", "==", "1"}], ")"}]}], ",", "0", ",", "1"}], 
             "]"}]}], "*", "up", "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "==", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "==", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "==", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "==", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"up", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "nn", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "4", ",", "6", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"nn", ",", "0", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "1", ",", "3", ",", "2"}], "}"}]}], "]"}]}],
            "+", 
           RowBox[{"up", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "nn", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "2", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"nn", ",", "0", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "1", ",", "3", ",", "2"}], "}"}]}], "]"}]}],
            "+", 
           RowBox[{"upu", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "nn", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "1", ",", "5", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"nn", ",", "0", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "1", ",", "3", ",", "2"}], "}"}]}], 
             "]"}]}]}], ",", "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "==", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "==", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "==", "4"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "==", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"up", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "nn", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "4", ",", "6", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"nn", ",", "0", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "4", ",", "5"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"up", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "nn", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "2", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"nn", ",", "0", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "4", ",", "5"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"upu", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "nn", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "1", ",", "5", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"nn", ",", "0", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "4", ",", "5"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "==", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "==", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "==", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "==", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"up", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "nn", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "4", ",", "6", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "3", ",", "5"}], "}"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"nn", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "+", 
           "\[IndentingNewLine]", 
           RowBox[{"up", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "nn", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "2", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "3", ",", "5"}], "}"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"nn", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"upu", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "nn", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "1", ",", "5", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "3", ",", "5"}], "}"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"nn", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "==", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "==", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "==", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "==", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "==", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"up", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "4", ",", "6", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "0", ",", "5"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"up", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "2", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "0", ",", "5"}], "}"}]}], "]"}]}], "+", 
           RowBox[{"upu", "*", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "jj", "]"}], "[", "0", "]"}], "[", "ll", 
                  "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"jj", ",", "1", ",", "5", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"ll", ",", "0", ",", "5"}], "}"}]}], "]"}]}]}], ",", 
          "0"}], "]"}], "+", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"BMAL1", "-", 
          RowBox[{
           RowBox[{"CLOCK", "/", "NPAS2"}], " ", "Degradation"}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", "ubc"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", ">", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{"ubc", "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "1", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "1"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", "ubc"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "t", "]"}]}], 
          ",", "0"}], "]"}], "+", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"REV", "-", 
          RowBox[{"ERBS", " ", "Degradation"}]}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"urev", "*", 
            RowBox[{"cyrevg", "[", "t", "]"}]}], "+", 
           RowBox[{"uprev", "*", 
            RowBox[{"cyrevgp", "[", "t", "]"}]}]}], ",", "0"}], "]"}], "+", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"k", "\[Equal]", "0"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"l", "\[Equal]", "2"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"m", "\[Equal]", "1"}], ")"}], "&&", 
           RowBox[{"(", 
            RowBox[{"n", "\[Equal]", "0"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"urev", "*", 
            RowBox[{"revng", "[", "t", "]"}]}], "+", 
           RowBox[{"uprev", "*", 
            RowBox[{"revngp", "[", "t", "]"}]}]}], ",", "0"}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.531666228613925*^9, 3.531666240348755*^9}, {
   3.531666366556016*^9, 3.53166652598601*^9}, {3.531756451735792*^9, 
   3.531756452170289*^9}, {3.531757243257128*^9, 3.531757247662985*^9}, 
   3.531761812052266*^9, {3.554736820279859*^9, 3.5547368212077427`*^9}, {
   3.566134725084689*^9, 3.5661347717361727`*^9}, {3.566134834389222*^9, 
   3.566134971706583*^9}, {3.566135066317586*^9, 3.5661351111665487`*^9}, {
   3.5661351768871393`*^9, 3.566135218503944*^9}, {3.566135260126439*^9, 
   3.566135274254878*^9}, {3.566135329466524*^9, 3.5661355703742313`*^9}, {
   3.566135627780591*^9, 3.566135658223051*^9}, {3.566135696777132*^9, 
   3.566135761155053*^9}, {3.566135882244348*^9, 3.566135980450783*^9}, {
   3.566136020731022*^9, 3.566136043729602*^9}, {3.566136076422051*^9, 
   3.5661360975877247`*^9}, {3.5661362688113117`*^9, 3.566136370615715*^9}, {
   3.566136402047984*^9, 3.5661364116505957`*^9}, {3.566136510844758*^9, 
   3.566136538241935*^9}, {3.566136585268985*^9, 3.566136688117531*^9}, {
   3.566136763926684*^9, 3.5661368251151876`*^9}, {3.5661368586730843`*^9, 
   3.566136884159655*^9}, {3.5661374028675137`*^9, 3.566137469712371*^9}, {
   3.566137663644182*^9, 3.566137677143381*^9}, {3.5661385719785147`*^9, 
   3.5661385898410683`*^9}, 3.566138986250787*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.566138118558591*^9, 3.5661381307455387`*^9}, {
   3.5661381791265917`*^9, 3.566138229955743*^9}, 3.566138704987912*^9}],

Cell[BoxData[
 StyleBox[
  RowBox[{
  "Simulation", " ", "of", " ", "Chronic", " ", "Dosing", " ", "under", " ", 
   "LD", " ", "cycle"}], "Subtitle"]], "Input",
 CellChangeTimes->{{3.5661445702843018`*^9, 3.5661445830145063`*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"Parameters", " ", "for", " ", "Dosing", " ", "Condition"}], 
  "Subsubtitle"]], "Input",
 CellChangeTimes->{{3.566144636250359*^9, 3.566144639095492*^9}, 
   3.566144792925613*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Dosing", " ", "Timing", " ", 
    RowBox[{"(", "hr", ")"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dtt", "=", "11"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Light", " ", "Duration", " ", 
     RowBox[{"(", "hr", ")"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ldd", "=", "12"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Dosing", " ", "Days"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"days", "=", "21"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Dosing", " ", "Amount", " ", 
     RowBox[{"(", "mpk", ")"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dose", "=", "32"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.566144653441592*^9, 3.5661447122669563`*^9}, {
   3.566159046650378*^9, 3.566159068566884*^9}, {3.56616042268292*^9, 
   3.5661604243340187`*^9}, 3.566169415702774*^9, {3.5661698601788607`*^9, 
   3.5661698612275753`*^9}, {3.566170891393249*^9, 3.566170899084346*^9}, 
   3.566171253852394*^9, {3.5661716071813383`*^9, 3.566171620355648*^9}, {
   3.5661719847189007`*^9, 3.566171985326148*^9}, {3.5661725752058287`*^9, 
   3.566172603814258*^9}, 3.5661730852872343`*^9, {3.566173655108026*^9, 
   3.566173666010647*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{
  "Entrainment", " ", "to", " ", "LD", " ", "cycle", " ", "before", " ", 
   "dosing", " ", "for", " ", "2", " ", "weeks"}], "Subsubtitle"]], "Input",
 CellChangeTimes->{{3.566144636250359*^9, 3.566144639095492*^9}, 
   3.566144792925613*^9, {3.566174467591181*^9, 3.5661744766498013`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"jjj", "=", "1"}], ",", 
     RowBox[{"jjj", "<", "29"}], ",", 
     RowBox[{"jjj", "++"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"jjj", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"athree", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"G", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"GR", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"gto", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"MnRo", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "4", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"McRo", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "5", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"MnRt", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "6", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"McRt", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "7", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"MnPo", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "8", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"McPo", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "9", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"MnPt", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "10", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"McPt", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "11", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"MnB", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "12", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"McB", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "13", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"B", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "14", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"GBb", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "15", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"GBRb", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "16", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"Cl", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "17", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"MnRev", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "18", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"McRev", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "19", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"cyrev", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "20", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"revn", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "21", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"cyrevg", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "22", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"revng", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "23", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"cyrevgp", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "24", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"revngp", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "25", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"GB", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "26", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"GBR", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "27", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"cyrevp", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "29", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"revnp", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "30", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"BC", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "33", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"Gr", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "34", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"GrR", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "35", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"ltn", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
            RowBox[{
             RowBox[{"McNp", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "37", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"MnNp", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "38", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"Gc", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "39", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"GcR", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init2", "[", 
              RowBox[{"[", "40", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"pInh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
            RowBox[{
             RowBox[{"bInh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
            RowBox[{
             RowBox[{"Inh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
            RowBox[{
             RowBox[{"nInh", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"afour", "=", 
          RowBox[{"Flatten", "[", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                  "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "0", "]"}], 
              "\[Equal]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"l", ">", "3"}], ",", "0", ",", 
                RowBox[{"Init1", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"j", "+", "1"}], ",", 
                   RowBox[{"k", "+", "1"}], ",", 
                   RowBox[{"l", "+", "1"}], ",", 
                   RowBox[{"m", "+", "1"}], ",", 
                   RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}]}], 
               "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
         ";"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Init11", "=", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                 "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", 
              RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
         RowBox[{"Init22", "=", 
          RowBox[{"Flatten", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"G", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"GR", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"gto", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"MnRo", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"McRo", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"MnRt", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"McRt", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"MnPo", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"McPo", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"MnPt", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"McPt", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"MnB", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"McB", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"B", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"GBb", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"GBRb", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"Cl", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"MnRev", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"McRev", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"cyrev", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"revn", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"cyrevg", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"revng", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"cyrevgp", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"revngp", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"GB", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"GBR", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", "0", 
             ",", 
             RowBox[{
              RowBox[{"cyrevp", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"revnp", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", "0", 
             ",", "0", ",", 
             RowBox[{
              RowBox[{"BC", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"Gr", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"GrR", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"ltn", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"McNp", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"MnNp", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"Gc", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
             RowBox[{
              RowBox[{"GcR", "[", 
               RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}]}], "}"}], 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"athree", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"G", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"GR", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"gto", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"MnRo", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "4", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"McRo", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "5", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"MnRt", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "6", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"McRt", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "7", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"MnPo", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "8", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"McPo", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "9", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"MnPt", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "10", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"McPt", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "11", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"MnB", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "12", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"McB", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "13", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"B", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "14", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"GBb", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "15", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"GBRb", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "16", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"Cl", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "17", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"MnRev", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "18", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"McRev", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "19", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"cyrev", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "20", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"revn", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "21", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"cyrevg", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "22", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"revng", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "23", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"cyrevgp", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "24", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"revngp", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "25", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"GB", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "26", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"GBR", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "27", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"cyrevp", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "29", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"revnp", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "30", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"BC", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "33", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"Gr", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "34", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"GrR", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "35", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"ltn", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
            RowBox[{
             RowBox[{"McNp", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "37", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"MnNp", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "38", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"Gc", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "39", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"GcR", "[", "0", "]"}], "\[Equal]", 
             RowBox[{"Init22", "[", 
              RowBox[{"[", "40", "]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"pInh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
            RowBox[{
             RowBox[{"bInh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
            RowBox[{
             RowBox[{"Inh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
            RowBox[{
             RowBox[{"nInh", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
         ";", "\[IndentingNewLine]", 
         RowBox[{"afour", "=", 
          RowBox[{"Flatten", "[", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                  "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "0", "]"}], 
              "\[Equal]", 
              RowBox[{"Init11", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"j", "+", "1"}], ",", 
                 RowBox[{"k", "+", "1"}], ",", 
                 RowBox[{"l", "+", "1"}], ",", 
                 RowBox[{"m", "+", "1"}], ",", 
                 RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}]}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"afive", "=", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "GR", ",", "G", ",", "MnRo", ",", "McRo", ",", "MnRt", ",", "McRt", 
           ",", "MnPo", ",", "McPo", ",", "MnPt", ",", "McPt", ",", "MnB", 
           ",", "McB", ",", "B", ",", "Cl", ",", "MnRev", ",", "McRev", ",", 
           "cyrev", ",", "revn", ",", "cyrevg", ",", "revng", ",", "cyrevgp", 
           ",", "revngp", ",", "cyrevp", ",", "revnp", ",", "GB", ",", "GBR", 
           ",", "BC", ",", "pInh", ",", "nInh", ",", "bInh", ",", "Inh", ",", 
           "ltn", ",", "Gr", ",", "GrR", ",", "McNp", ",", "MnNp", ",", "Gc", 
           ",", "GcR", ",", "GBb", ",", "GBRb", ",", "gto"}], "}"}], ",", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"qrt2", "=", 
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"laone", ",", "atwo", ",", "athree", ",", "afour"}], "]"}], 
         ",", "afive", ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "ldd"}], "}"}], ",", 
         RowBox[{"MaxSteps", "\[Rule]", "100000"}], ",", 
         RowBox[{"MaxStepSize", "\[Rule]", "0.1"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Init11", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", "]"}],
              "[", "m", "]"}], "[", "n", "]"}], "[", "ldd", "]"}], "/.", 
          "qrt2"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
      RowBox[{"Init22", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"G", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"GR", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"gto", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"MnRo", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"McRo", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"MnRt", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"McRt", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"MnPo", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"McPo", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"MnPt", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"McPt", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"MnB", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"McB", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"B", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"GBb", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"GBRb", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"Cl", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"MnRev", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"McRev", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"cyrev", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"revn", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"cyrevg", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"revng", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"cyrevgp", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"revngp", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"GB", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"GBR", "[", "ldd", "]"}], "/.", "qrt2"}], ",", "0", ",", 
          RowBox[{
           RowBox[{"cyrevp", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"revnp", "[", "ldd", "]"}], "/.", "qrt2"}], ",", "0", ",", 
          "0", ",", 
          RowBox[{
           RowBox[{"BC", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"Gr", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"GrR", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"ltn", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"McNp", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"MnNp", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"Gc", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
          RowBox[{
           RowBox[{"GcR", "[", "ldd", "]"}], "/.", "qrt2"}]}], "}"}], "]"}]}],
       ";", 
      RowBox[{"athree", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"G", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"GR", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"gto", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"MnRo", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"McRo", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "5", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"MnRt", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "6", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"McRt", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "7", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"MnPo", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "8", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"McPo", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "9", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"MnPt", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "10", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"McPt", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "11", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"MnB", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "12", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"McB", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "13", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"B", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "14", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"GBb", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "15", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"GBRb", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "16", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"Cl", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "17", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"MnRev", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "18", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"McRev", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "19", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"cyrev", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "20", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"revn", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "21", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"cyrevg", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "22", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"revng", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "23", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"cyrevgp", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "24", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"revngp", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "25", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"GB", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "26", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"GBR", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "27", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"cyrevp", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "29", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"revnp", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "30", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"BC", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "33", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"Gr", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "34", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"GrR", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "35", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"ltn", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "36", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"McNp", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "37", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"MnNp", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "38", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"Gc", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "39", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"GcR", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"Init22", "[", 
           RowBox[{"[", "40", "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"pInh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"bInh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"Inh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"nInh", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], ";", 
      
      RowBox[{"afour", "=", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
               "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "0", "]"}], 
           "\[Equal]", 
           RowBox[{"Init11", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"j", "+", "1"}], ",", 
              RowBox[{"k", "+", "1"}], ",", 
              RowBox[{"l", "+", "1"}], ",", 
              RowBox[{"m", "+", "1"}], ",", 
              RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"qrt22", "=", 
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Join", "[", 
          RowBox[{"daone", ",", "atwo", ",", "athree", ",", "afour"}], "]"}], 
         ",", "afive", ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", 
           RowBox[{"24", "-", "ldd"}]}], "}"}], ",", 
         RowBox[{"MaxSteps", "\[Rule]", "100000"}], ",", 
         RowBox[{"MaxStepSize", "\[Rule]", "0.1"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"jjj", "\[Equal]", "28"}], ",", 
        RowBox[{"XXo", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"MnB", "[", "t", "]"}], "+", 
             RowBox[{"McB", "[", "t", "]"}]}], "/.", 
            RowBox[{"qrt2", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "ldd", ",", "0.02"}], "}"}]}], 
          "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"jjj", "\[Equal]", "28"}], ",", 
        RowBox[{"XXt", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"MnB", "[", "t", "]"}], "+", 
             RowBox[{"McB", "[", "t", "]"}]}], "/.", 
            RowBox[{"qrt22", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0.02", ",", 
             RowBox[{"24", "-", "ldd"}], ",", "0.02"}], "}"}]}], "]"}]}]}], 
       "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Measurement", " ", "of", " ", "Phase", " ", "before", " ", "Dosing"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"XX", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"XXo", ",", "XXt"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"tBm", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Position", "[", 
          RowBox[{"XX", ",", 
           RowBox[{"Min", "[", "XX", "]"}]}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "-", "1"}], ")"}], "*", "0.02"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"imInit11", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", "]"}], 
         "[", "m", "]"}], "[", "n", "]"}], "[", 
       RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"imInit22", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"G", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"GR", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"gto", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"MnRo", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"McRo", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"MnRt", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"McRt", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"MnPo", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"McPo", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"MnPt", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"McPt", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"MnB", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"McB", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"B", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"GBb", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"GBRb", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"Cl", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"MnRev", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"McRev", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"cyrev", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"revn", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"cyrevg", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"revng", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"cyrevgp", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"revngp", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"GB", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"GBR", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", "0", ",", 
      RowBox[{
       RowBox[{"cyrevp", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"revnp", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", "0", ",", 
      "0", ",", 
      RowBox[{
       RowBox[{"BC", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"Gr", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"GrR", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"ltn", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"McNp", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"MnNp", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"Gc", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
      RowBox[{
       RowBox[{"GcR", "[", 
        RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", "0", ",", 
      "0", ",", "0"}], "}"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.566161075053082*^9, {3.566170937889534*^9, 3.566170965100277*^9}, 
   3.566171638206554*^9, {3.56617248678998*^9, 3.566172523357822*^9}, {
   3.566172609868486*^9, 3.566172681749069*^9}, {3.5661744817490187`*^9, 
   3.566174482919025*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"Chronic", " ", "Dosing"}], "Subsubtitle"]], "Input",
 CellChangeTimes->{{3.566173887847229*^9, 3.566173890847055*^9}, {
  3.566173971364202*^9, 3.566173973450534*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nprod", "=", 
   RowBox[{"prodi", "*", 
    RowBox[{"dose", "/", "32"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmo", "=", 
    RowBox[{"{", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"ldd", ">", "dtt"}], ",", "\[IndentingNewLine]", "\n", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jjj", "=", "1"}], ",", 
       RowBox[{"jjj", "<", 
        RowBox[{"days", "+", "1"}]}], ",", 
       RowBox[{"jjj", "++"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"jjj", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"athree", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"G", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"gto", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnRo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "4", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McRo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "5", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnRt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "6", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McRt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "7", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnPo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "8", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McPo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "9", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnPt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "10", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McPt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "11", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnB", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "12", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McB", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "13", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"B", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "14", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GBb", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "15", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GBRb", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "16", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Cl", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "17", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnRev", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "18", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McRev", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "19", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrev", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "20", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revn", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "21", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrevg", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "22", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revng", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "23", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrevgp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "24", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revngp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "25", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GB", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "26", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GBR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "27", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrevp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "29", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revnp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "30", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"BC", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "33", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Gr", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "34", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GrR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "35", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"ltn", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"McNp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "37", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnNp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "38", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Gc", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "39", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GcR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "40", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"pInh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"bInh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"Inh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"nInh", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
           ";", 
           RowBox[{"afour", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                    "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "0", "]"}], 
                "\[Equal]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"l", ">", "3"}], ",", "0", ",", 
                  RowBox[{"imInit11", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "+", "1"}], ",", 
                    RowBox[{"k", "+", "1"}], ",", 
                    RowBox[{"l", "+", "1"}], ",", 
                    RowBox[{"m", "+", "1"}], ",", 
                    RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}]}], 
                 "]"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
           ";"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"mInit11", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                   "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", 
                RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"mInit22", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"G", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"GR", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"gto", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"MnRo", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"McRo", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"MnRt", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"McRt", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"MnPo", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"McPo", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"MnPt", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"McPt", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"MnB", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"McB", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"B", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"GBb", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"GBRb", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"Cl", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"MnRev", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"McRev", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"cyrev", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"revn", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"cyrevg", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"revng", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"cyrevgp", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"revngp", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"GB", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"GBR", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", "0", 
               ",", 
               RowBox[{
                RowBox[{"cyrevp", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"revnp", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", "0", 
               ",", "0", ",", 
               RowBox[{
                RowBox[{"BC", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"Gr", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"GrR", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"ltn", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"McNp", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"MnNp", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"Gc", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"GcR", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"pInh", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"Inh", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"nInh", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"bInh", "[", 
                 RowBox[{"24", "-", "ldd"}], "]"}], "/.", "qrt3"}]}], "}"}], 
             "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"athree", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"G", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"gto", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnRo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "4", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McRo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "5", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnRt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "6", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McRt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "7", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnPo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "8", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McPo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "9", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnPt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "10", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McPt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "11", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnB", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "12", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McB", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "13", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"B", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "14", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GBb", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "15", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GBRb", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "16", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Cl", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "17", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnRev", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "18", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McRev", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "19", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrev", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "20", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revn", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "21", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrevg", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "22", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revng", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "23", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrevgp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "24", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revngp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "25", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GB", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "26", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GBR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "27", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrevp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "29", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revnp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "30", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"BC", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "33", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Gr", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "34", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GrR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "35", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"ltn", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"McNp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "37", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnNp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "38", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Gc", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "39", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GcR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "40", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"pInh", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "41", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Inh", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "42", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"nInh", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "43", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"bInh", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "44", "]"}], "]"}]}]}], "}"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"afour", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                    "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "0", "]"}], 
                "\[Equal]", 
                RowBox[{"mInit11", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"j", "+", "1"}], ",", 
                   RowBox[{"k", "+", "1"}], ",", 
                   RowBox[{"l", "+", "1"}], ",", 
                   RowBox[{"m", "+", "1"}], ",", 
                   RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
           ";"}]}], "]"}], ";", 
        RowBox[{"qrt2", "=", 
         RowBox[{"NDSolve", "[", 
          RowBox[{
           RowBox[{"Join", "[", 
            RowBox[{"laone", ",", "atwo", ",", "athree", ",", "afour"}], 
            "]"}], ",", "afive", ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "dtt"}], "}"}], ",", 
           RowBox[{"MaxSteps", "\[Rule]", "100000"}], ",", 
           RowBox[{"MaxStepSize", "\[Rule]", "0.1"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"mInit11", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "dtt", "]"}], "/.",
             "qrt2"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"mInit22", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"G", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"GR", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"gto", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"MnRo", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"McRo", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"MnRt", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"McRt", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"MnPo", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"McPo", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"MnPt", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"McPt", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"MnB", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"McB", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"B", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"GBb", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"GBRb", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"Cl", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"MnRev", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"McRev", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"cyrev", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"revn", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"cyrevg", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"revng", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"cyrevgp", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"revngp", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"GB", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"GBR", "[", "dtt", "]"}], "/.", "qrt2"}], ",", "0", ",", 
            
            RowBox[{
             RowBox[{"cyrevp", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"revnp", "[", "dtt", "]"}], "/.", "qrt2"}], ",", "0", 
            ",", "0", ",", 
            RowBox[{
             RowBox[{"BC", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"Gr", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"GrR", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"ltn", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"McNp", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"MnNp", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"Gc", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"GcR", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"pInh", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"Inh", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"nInh", "[", "dtt", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"bInh", "[", "dtt", "]"}], "/.", "qrt2"}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"athree", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"G", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"gto", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnRo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McRo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "5", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnRt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "6", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McRt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "7", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnPo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "8", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McPo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "9", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnPt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "10", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McPt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "11", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnB", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "12", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McB", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "13", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"B", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "14", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GBb", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "15", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GBRb", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "16", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"Cl", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "17", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnRev", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "18", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McRev", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "19", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrev", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "20", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revn", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "21", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrevg", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "22", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revng", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "23", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrevgp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "24", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revngp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "25", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GB", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "26", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GBR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "27", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrevp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "29", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revnp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "30", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"BC", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "33", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"Gr", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "34", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GrR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "35", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"ltn", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "36", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McNp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "37", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnNp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "38", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"Gc", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "39", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GcR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "40", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"pInh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{
             RowBox[{"mInit22", "[", 
              RowBox[{"[", "41", "]"}], "]"}], "+", "nprod"}]}], ",", 
           RowBox[{
            RowBox[{"Inh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "42", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"nInh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "43", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"bInh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "44", "]"}], "]"}]}]}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"afour", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                 "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "0", "]"}], 
             "\[Equal]", 
             RowBox[{"mInit11", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"j", "+", "1"}], ",", 
                RowBox[{"k", "+", "1"}], ",", 
                RowBox[{"l", "+", "1"}], ",", 
                RowBox[{"m", "+", "1"}], ",", 
                RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"qrt22", "=", 
         RowBox[{"NDSolve", "[", 
          RowBox[{
           RowBox[{"Join", "[", 
            RowBox[{"laone", ",", "atwo", ",", "athree", ",", "afour"}], 
            "]"}], ",", "afive", ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"ldd", "-", "dtt"}]}], "}"}], ",", 
           RowBox[{"MaxSteps", "\[Rule]", "100000"}], ",", 
           RowBox[{"MaxStepSize", "\[Rule]", "0.1"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"mInit11", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", 
             RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"mInit22", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"G", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"GR", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"gto", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"MnRo", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"McRo", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"MnRt", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"McRt", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"MnPo", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"McPo", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"MnPt", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"McPt", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"MnB", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"McB", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"B", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"GBb", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"GBRb", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"Cl", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"MnRev", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"McRev", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"cyrev", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"revn", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"cyrevg", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"revng", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"cyrevgp", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"revngp", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"GB", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"GBR", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", "0", 
            ",", 
            RowBox[{
             RowBox[{"cyrevp", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"revnp", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", "0", 
            ",", "0", ",", 
            RowBox[{
             RowBox[{"BC", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"Gr", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"GrR", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"ltn", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"McNp", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"MnNp", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"Gc", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"GcR", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"pInh", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"Inh", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"nInh", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"bInh", "[", 
              RowBox[{"ldd", "-", "dtt"}], "]"}], "/.", "qrt22"}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"athree", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"G", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"gto", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnRo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McRo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "5", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnRt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "6", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McRt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "7", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnPo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "8", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McPo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "9", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnPt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "10", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McPt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "11", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnB", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "12", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McB", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "13", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"B", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "14", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GBb", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "15", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GBRb", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "16", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"Cl", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "17", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnRev", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "18", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McRev", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "19", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrev", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "20", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revn", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "21", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrevg", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "22", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revng", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "23", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrevgp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "24", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revngp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "25", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GB", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "26", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GBR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "27", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrevp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "29", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revnp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "30", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"BC", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "33", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"Gr", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "34", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GrR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "35", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"ltn", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
           RowBox[{
            RowBox[{"McNp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "37", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnNp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "38", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"Gc", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "39", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GcR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "40", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"pInh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "41", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"Inh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "42", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"nInh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "43", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"bInh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "44", "]"}], "]"}]}]}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"afour", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                 "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "0", "]"}], 
             "\[Equal]", 
             RowBox[{"mInit11", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"j", "+", "1"}], ",", 
                RowBox[{"k", "+", "1"}], ",", 
                RowBox[{"l", "+", "1"}], ",", 
                RowBox[{"m", "+", "1"}], ",", 
                RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"qrt3", "=", 
         RowBox[{"NDSolve", "[", 
          RowBox[{
           RowBox[{"Join", "[", 
            RowBox[{"daone", ",", "atwo", ",", "athree", ",", "afour"}], 
            "]"}], ",", "afive", ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"24", "-", "ldd"}]}], "}"}], ",", 
           RowBox[{"MaxSteps", "\[Rule]", "100000"}], ",", 
           RowBox[{"MaxStepSize", "\[Rule]", "0.1"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"XXo", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"MnB", "[", "t", "]"}], "+", 
             RowBox[{"McB", "[", "t", "]"}]}], "/.", 
            RowBox[{"qrt2", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "dtt", ",", "0.02"}], "}"}]}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"XXt", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"MnB", "[", "t", "]"}], "+", 
             RowBox[{"McB", "[", "t", "]"}]}], "/.", 
            RowBox[{"qrt22", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0.02", ",", 
             RowBox[{"ldd", "-", "dtt"}], ",", "0.02"}], "}"}]}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"XXh", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"MnB", "[", "t", "]"}], "+", 
             RowBox[{"McB", "[", "t", "]"}]}], "/.", 
            RowBox[{"qrt3", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0.02", ",", 
             RowBox[{"24", "-", "ldd"}], ",", "0.02"}], "}"}]}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"XX", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"XXo", ",", "XXt", ",", "XXh"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"tBmt", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Position", "[", 
               RowBox[{"XX", ",", 
                RowBox[{"Min", "[", "XX", "]"}]}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "1"}], ")"}], "*", 
          "0.02"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"tmo", "=", 
         RowBox[{"Join", "[", 
          RowBox[{
           RowBox[{"Flatten", "[", "tmo", "]"}], ",", 
           RowBox[{"{", "tBmt", "}"}]}], "]"}]}], ";"}]}], "]"}], ";"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
    
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jjj", "=", "1"}], ",", 
       RowBox[{"jjj", "<", 
        RowBox[{"days", "+", "1"}]}], ",", 
       RowBox[{"jjj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"jjj", "\[Equal]", "1"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"athree", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"G", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"gto", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnRo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "4", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McRo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "5", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnRt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "6", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McRt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "7", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnPo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "8", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McPo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "9", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnPt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "10", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McPt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "11", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnB", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "12", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McB", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "13", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"B", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "14", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GBb", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "15", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GBRb", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "16", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Cl", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "17", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnRev", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "18", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McRev", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "19", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrev", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "20", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revn", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "21", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrevg", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "22", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revng", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "23", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrevgp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "24", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revngp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "25", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GB", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "26", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GBR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "27", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrevp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "29", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revnp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "30", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"BC", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "33", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Gr", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "34", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GrR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "35", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"ltn", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"McNp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "37", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnNp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "38", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Gc", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "39", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GcR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"imInit22", "[", 
                RowBox[{"[", "40", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"pInh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"Inh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"nInh", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"bInh", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
           ";", 
           RowBox[{"afour", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                    "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "0", "]"}], 
                "\[Equal]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"l", ">", "3"}], ",", "0", ",", 
                  RowBox[{"imInit11", "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"j", "+", "1"}], ",", 
                    RowBox[{"k", "+", "1"}], ",", 
                    RowBox[{"l", "+", "1"}], ",", 
                    RowBox[{"m", "+", "1"}], ",", 
                    RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}]}], 
                 "]"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
           ";"}], ",", 
          RowBox[{
           RowBox[{"mInit11", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                   "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", 
                RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"mInit22", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"G", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"GR", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"gto", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"MnRo", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"McRo", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"MnRt", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"McRt", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"MnPo", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"McPo", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"MnPt", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"McPt", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"MnB", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"McB", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"B", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"GBb", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"GBRb", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"Cl", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"MnRev", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"McRev", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"cyrev", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"revn", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"cyrevg", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"revng", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"cyrevgp", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"revngp", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"GB", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"GBR", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", "0", 
               ",", 
               RowBox[{
                RowBox[{"cyrevp", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"revnp", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", "0", 
               ",", "0", ",", 
               RowBox[{
                RowBox[{"BC", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"Gr", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"GrR", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"ltn", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"McNp", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"MnNp", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"Gc", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"GcR", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"pInh", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"Inh", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"nInh", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}], ",", 
               RowBox[{
                RowBox[{"bInh", "[", 
                 RowBox[{"24", "-", "dtt"}], "]"}], "/.", "qrt3"}]}], "}"}], 
             "]"}]}], ";", 
           RowBox[{"athree", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"G", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"gto", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnRo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "4", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McRo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "5", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnRt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "6", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McRt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "7", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnPo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "8", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McPo", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "9", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnPt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "10", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McPt", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "11", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnB", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "12", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McB", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "13", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"B", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "14", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GBb", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "15", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GBRb", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "16", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Cl", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "17", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnRev", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "18", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"McRev", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "19", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrev", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "20", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revn", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "21", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrevg", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "22", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revng", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "23", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrevgp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "24", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revngp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "25", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GB", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "26", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GBR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "27", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"cyrevp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "29", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"revnp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "30", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"BC", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "33", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Gr", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "34", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GrR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "35", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"ltn", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"McNp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "37", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"MnNp", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "38", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Gc", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "39", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"GcR", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "40", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"pInh", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "41", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"Inh", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "42", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"nInh", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "43", "]"}], "]"}]}], ",", 
              RowBox[{
               RowBox[{"bInh", "[", "0", "]"}], "\[Equal]", 
               RowBox[{"mInit22", "[", 
                RowBox[{"[", "44", "]"}], "]"}]}]}], "}"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"afour", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                    "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "0", "]"}], 
                "\[Equal]", 
                RowBox[{"mInit11", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"j", "+", "1"}], ",", 
                   RowBox[{"k", "+", "1"}], ",", 
                   RowBox[{"l", "+", "1"}], ",", 
                   RowBox[{"m", "+", "1"}], ",", 
                   RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}]}], ",", 
               RowBox[{"{", 
                RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], 
           ";"}]}], "]"}], ";", 
        RowBox[{"qrt2", "=", 
         RowBox[{"NDSolve", "[", 
          RowBox[{
           RowBox[{"Join", "[", 
            RowBox[{"laone", ",", "atwo", ",", "athree", ",", "afour"}], 
            "]"}], ",", "afive", ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "ldd"}], "}"}], ",", 
           RowBox[{"MaxSteps", "\[Rule]", "100000"}], ",", 
           RowBox[{"MaxStepSize", "\[Rule]", "0.1"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"mInit11", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "ldd", "]"}], "/.",
             "qrt2"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"mInit22", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"G", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"GR", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"gto", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"MnRo", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"McRo", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"MnRt", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"McRt", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"MnPo", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"McPo", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"MnPt", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"McPt", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"MnB", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"McB", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"B", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"GBb", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"GBRb", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"Cl", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"MnRev", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"McRev", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"cyrev", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"revn", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"cyrevg", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"revng", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"cyrevgp", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"revngp", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"GB", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"GBR", "[", "ldd", "]"}], "/.", "qrt2"}], ",", "0", ",", 
            
            RowBox[{
             RowBox[{"cyrevp", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"revnp", "[", "ldd", "]"}], "/.", "qrt2"}], ",", "0", 
            ",", "0", ",", 
            RowBox[{
             RowBox[{"BC", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"Gr", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"GrR", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"ltn", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"McNp", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"MnNp", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"Gc", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"GcR", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"pInh", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"Inh", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"nInh", "[", "ldd", "]"}], "/.", "qrt2"}], ",", 
            RowBox[{
             RowBox[{"bInh", "[", "ldd", "]"}], "/.", "qrt2"}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"athree", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"G", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"gto", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnRo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McRo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "5", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnRt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "6", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McRt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "7", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnPo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "8", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McPo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "9", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnPt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "10", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McPt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "11", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnB", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "12", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McB", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "13", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"B", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "14", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GBb", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "15", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GBRb", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "16", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"Cl", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "17", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnRev", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "18", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McRev", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "19", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrev", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "20", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revn", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "21", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrevg", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "22", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revng", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "23", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrevgp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "24", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revngp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "25", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GB", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "26", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GBR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "27", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrevp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "29", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revnp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "30", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"BC", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "33", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"Gr", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "34", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GrR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "35", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"ltn", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "36", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McNp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "37", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnNp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "38", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"Gc", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "39", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GcR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "40", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"pInh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "41", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"Inh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "42", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"nInh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "43", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"bInh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "44", "]"}], "]"}]}]}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"afour", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                 "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "0", "]"}], 
             "\[Equal]", 
             RowBox[{"mInit11", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"j", "+", "1"}], ",", 
                RowBox[{"k", "+", "1"}], ",", 
                RowBox[{"l", "+", "1"}], ",", 
                RowBox[{"m", "+", "1"}], ",", 
                RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"qrt22", "=", 
         RowBox[{"NDSolve", "[", 
          RowBox[{
           RowBox[{"Join", "[", 
            RowBox[{"daone", ",", "atwo", ",", "athree", ",", "afour"}], 
            "]"}], ",", "afive", ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"dtt", "-", "ldd"}]}], "}"}], ",", 
           RowBox[{"MaxSteps", "\[Rule]", "100000"}], ",", 
           RowBox[{"MaxStepSize", "\[Rule]", "0.1"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"mInit11", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", 
             RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"mInit22", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"G", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"GR", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"gto", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"MnRo", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"McRo", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"MnRt", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"McRt", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"MnPo", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"McPo", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"MnPt", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"McPt", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"MnB", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"McB", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"B", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"GBb", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"GBRb", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"Cl", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"MnRev", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"McRev", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"cyrev", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"revn", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"cyrevg", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"revng", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"cyrevgp", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"revngp", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"GB", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"GBR", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", "0", 
            ",", 
            RowBox[{
             RowBox[{"cyrevp", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"revnp", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", "0", 
            ",", "0", ",", 
            RowBox[{
             RowBox[{"BC", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"Gr", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"GrR", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"ltn", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"McNp", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"MnNp", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"Gc", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"GcR", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"pInh", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"Inh", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"nInh", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}], ",", 
            RowBox[{
             RowBox[{"bInh", "[", 
              RowBox[{"dtt", "-", "ldd"}], "]"}], "/.", "qrt22"}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"athree", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"G", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"gto", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnRo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McRo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "5", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnRt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "6", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McRt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "7", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnPo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "8", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McPo", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "9", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnPt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "10", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McPt", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "11", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnB", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "12", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McB", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "13", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"B", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "14", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GBb", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "15", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GBRb", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "16", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"Cl", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "17", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnRev", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "18", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"McRev", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "19", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrev", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "20", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revn", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "21", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrevg", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "22", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revng", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "23", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrevgp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "24", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revngp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "25", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GB", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "26", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GBR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "27", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"cyrevp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "29", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"revnp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "30", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"BC", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "33", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"Gr", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "34", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GrR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "35", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"ltn", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
           RowBox[{
            RowBox[{"McNp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "37", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"MnNp", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "38", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"Gc", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "39", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"GcR", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "40", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"pInh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{
             RowBox[{"mInit22", "[", 
              RowBox[{"[", "41", "]"}], "]"}], "+", "nprod"}]}], ",", 
           RowBox[{
            RowBox[{"Inh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "42", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"nInh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "43", "]"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"bInh", "[", "0", "]"}], "\[Equal]", 
            RowBox[{"mInit22", "[", 
             RowBox[{"[", "44", "]"}], "]"}]}]}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"afour", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"x", "[", "j", "]"}], "[", "k", "]"}], "[", "l", 
                 "]"}], "[", "m", "]"}], "[", "n", "]"}], "[", "0", "]"}], 
             "\[Equal]", 
             RowBox[{"mInit11", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"j", "+", "1"}], ",", 
                RowBox[{"k", "+", "1"}], ",", 
                RowBox[{"l", "+", "1"}], ",", 
                RowBox[{"m", "+", "1"}], ",", 
                RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", "0", ",", "6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"l", ",", "0", ",", "5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", "0", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"n", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"qrt3", "=", 
         RowBox[{"NDSolve", "[", 
          RowBox[{
           RowBox[{"Join", "[", 
            RowBox[{"daone", ",", "atwo", ",", "athree", ",", "afour"}], 
            "]"}], ",", "afive", ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"24", "-", "dtt"}]}], "}"}], ",", 
           RowBox[{"MaxSteps", "\[Rule]", "100000"}], ",", 
           RowBox[{"MaxStepSize", "\[Rule]", "0.1"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "Measurement", " ", "of", " ", "Phas", " ", "during", " ", "Chronic",
           " ", "Dosing"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"XXo", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"MnB", "[", "t", "]"}], "+", 
             RowBox[{"McB", "[", "t", "]"}]}], "/.", 
            RowBox[{"qrt2", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "ldd", ",", "0.02"}], "}"}]}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"XXt", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"MnB", "[", "t", "]"}], "+", 
             RowBox[{"McB", "[", "t", "]"}]}], "/.", 
            RowBox[{"qrt22", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0.02", ",", 
             RowBox[{
              RowBox[{"-", "ldd"}], "+", "dtt"}], ",", "0.02"}], "}"}]}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"XXh", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"MnB", "[", "t", "]"}], "+", 
             RowBox[{"McB", "[", "t", "]"}]}], "/.", 
            RowBox[{"qrt3", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0.02", ",", 
             RowBox[{"24", "-", "dtt"}], ",", "0.02"}], "}"}]}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"XX", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"XXo", ",", "XXt", ",", "XXh"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"tBmt", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Position", "[", 
               RowBox[{"XX", ",", 
                RowBox[{"Min", "[", "XX", "]"}]}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "1"}], ")"}], "*", 
          "0.02"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"tmo", "=", 
         RowBox[{"Join", "[", 
          RowBox[{
           RowBox[{"Flatten", "[", "tmo", "]"}], ",", 
           RowBox[{"{", "tBmt", "}"}]}], "]"}]}], ";"}]}], "]"}], ";"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"{", 
    RowBox[{"tmo", "-", "tBm"}], "}"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.558825310075603*^9, 3.558825511440859*^9}, {
   3.55882565482724*^9, 3.5588256845047827`*^9}, 3.5588257797176437`*^9, {
   3.5623490925300922`*^9, 3.562349384350348*^9}, {3.56235003231621*^9, 
   3.562350039663786*^9}, {3.562350138999613*^9, 3.562350141883975*^9}, 
   3.56235017218145*^9, {3.562350250782755*^9, 3.5623502689342737`*^9}, {
   3.5623504260867653`*^9, 3.562350433049272*^9}, 3.5623505618839808`*^9, 
   3.5623506921829863`*^9, {3.5623512895870028`*^9, 3.562351292090147*^9}, 
   3.5623514391242228`*^9, {3.56235187235192*^9, 3.562351874843458*^9}, {
   3.562352290744619*^9, 3.562352300275064*^9}, {3.562352585755266*^9, 
   3.562352618545154*^9}, {3.5626666394237537`*^9, 3.562666640925899*^9}, {
   3.564938225475029*^9, 3.5649382398050003`*^9}, {3.5649409393347797`*^9, 
   3.564940941977206*^9}, {3.564941105945068*^9, 3.564941137725905*^9}, {
   3.564941470840741*^9, 3.5649415599029007`*^9}, {3.564941592159647*^9, 
   3.564941688779828*^9}, {3.5649417446601343`*^9, 3.564941747280982*^9}, 
   3.5649417895638247`*^9, {3.564941826547824*^9, 3.564941998579496*^9}, {
   3.564942075793037*^9, 3.564942077930691*^9}, {3.564942397940503*^9, 
   3.564942400099799*^9}, {3.564963241951673*^9, 3.564963244725966*^9}, {
   3.564964162480678*^9, 3.56496416582244*^9}, {3.566145004369615*^9, 
   3.566145056791232*^9}, {3.566152165557129*^9, 3.5661521787363367`*^9}, {
   3.5661522412995768`*^9, 3.566152280812973*^9}, {3.56615254765656*^9, 
   3.56615255111935*^9}, {3.566152614269566*^9, 3.566152638255692*^9}, {
   3.566156046780632*^9, 3.566156078295052*^9}, {3.566157263010973*^9, 
   3.566157286043408*^9}, {3.566157316663488*^9, 3.5661573185648727`*^9}, {
   3.5661609820753937`*^9, 3.566160987702614*^9}, 3.566161093102737*^9, 
   3.566171646307048*^9, {3.566172692700941*^9, 3.566172802372284*^9}, {
   3.566173276858266*^9, 3.566173294883959*^9}, {3.566173724963757*^9, 
   3.566173725387579*^9}, {3.5661739818128033`*^9, 3.5661739826597757`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
   "0.`", ",", "1.1600000000000001`", ",", "2.460000000000001`", ",", 
    "3.4400000000000013`", ",", "4.120000000000001`", ",", 
    "4.540000000000001`", ",", "4.780000000000001`", ",", 
    "4.940000000000001`", ",", "5.0600000000000005`", ",", 
    "5.140000000000001`", ",", "5.220000000000001`", ",", "5.26`", ",", 
    "5.32`", ",", "5.360000000000001`", ",", "5.4`", ",", "5.42`", ",", 
    "5.460000000000001`", ",", "5.48`", ",", "5.520000000000001`", ",", 
    "5.540000000000001`", ",", "5.5600000000000005`"}], "}"}], "}"}]], "Print",\

 CellChangeTimes->{3.566160913859961*^9, 3.56616127472832*^9, 
  3.566169611384047*^9, 3.5661700440828123`*^9, 3.566171092782008*^9, 
  3.5661714609800253`*^9, 3.566171748792951*^9, 3.566172304400169*^9, 
  3.566173039928204*^9, 3.566173230438703*^9, 3.566173831225403*^9}]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
  "Plot", " ", "of", " ", "Phase", " ", "Change", " ", "during", " ", 
   "Chronic", " ", "Dosing"}], "Subsubtitle"]], "Input",
 CellChangeTimes->{{3.566173887847229*^9, 3.566173890847055*^9}, {
  3.566173971364202*^9, 3.5661740100347157`*^9}, {3.566174525250708*^9, 
  3.566174529599658*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"tmo", "[", 
        RowBox[{"[", "jj", "]"}], "]"}], "-", "tBm"}], ",", 
      RowBox[{"{", 
       RowBox[{"jj", ",", "1", ",", "days"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", 
      RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
      RowBox[{"FontSize", "\[Rule]", "20"}]}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "8"}]}], "}"}]}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "7", ",", "14", ",", "21", ",", "28"}], "}"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", 
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "4"}], ",", 
         RowBox[{"-", "5"}], ",", 
         RowBox[{"-", "6"}], ",", 
         RowBox[{"-", "7"}], ",", 
         RowBox[{"-", "8"}]}], "}"}], "*", "2"}]}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Days", ",", "Phase"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5661737861174507`*^9, 3.5661738668856583`*^9}, {
  3.566174061577158*^9, 3.566174088294278*^9}}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQEf7BlQgcOEQ181Yvo/7YdwORw2uD+sElnHfADC
F3DoeB24Q66VG8oXcagRWQdUIQDlSzhoxfQDTRCC8mUcFFpBGoShfAWHIyDj
D8H4Sg52XNcXF9iKQPkqUPthfDWHR1UgC2B8DQewci5RKF/LwQPkPHcYX8eh
yBakAsbXc5g1EwRgfAOHdWD/wPiGDjdAxl2H8Y0c3oC89xrGN3YQA2sQg/JN
oP6D8U2h7hc7AABXQ1di
   "], {{{}, {}, 
     {RGBColor[1, 0, 0], PointSize[Large], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20, 21}]}}, {
     {RGBColor[1, 0, 0], PointSize[Large], 
      PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
        19, 20, 21}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["Days", TraditionalForm], 
    FormBox["Phase", TraditionalForm]},
  AxesOrigin->{0, -8},
  AxesStyle->Directive[
    Thickness[Large], FontSize -> 20],
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 20},
  ImageSize->{513., Automatic},
  PlotRange->{{0., 21.}, {-8, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {7, 
      FormBox["7", TraditionalForm]}, {14, 
      FormBox["14", TraditionalForm]}, {21, 
      FormBox["21", TraditionalForm]}, {28, 
      FormBox["28", TraditionalForm]}}, {{2, 
      FormBox["2", TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-6, 
      FormBox[
       RowBox[{"-", "6"}], TraditionalForm]}, {-8, 
      FormBox[
       RowBox[{"-", "8"}], TraditionalForm]}, {-10, 
      FormBox[
       RowBox[{"-", "10"}], TraditionalForm]}, {-12, 
      FormBox[
       RowBox[{"-", "12"}], TraditionalForm]}, {-14, 
      FormBox[
       RowBox[{"-", "14"}], TraditionalForm]}, {-16, 
      FormBox[
       RowBox[{"-", "16"}], TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.566173834259454*^9, 3.566173868642701*^9}, {
  3.566174069853547*^9, 3.566174088804469*^9}}]
}, Open  ]]
},
WindowSize->{1440, 789},
WindowMargins->{{-3, Automatic}, {-53, Automatic}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (November 6, \
2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 915, 21, 150, "Input"],
Cell[1475, 43, 872, 17, 52, "Input"],
Cell[2350, 62, 492, 13, 29, "Input"],
Cell[2845, 77, 259, 5, 39, "Input"],
Cell[3107, 84, 37499, 994, 658, "Input"],
Cell[40609, 1080, 238, 5, 59, "Input"],
Cell[40850, 1087, 6374, 141, 553, "Input"],
Cell[47227, 1230, 278, 6, 31, "Input"],
Cell[47508, 1238, 3215, 79, 358, "Input"],
Cell[50726, 1319, 194, 4, 39, "Input"],
Cell[50923, 1325, 498, 10, 31, "Input"],
Cell[51424, 1337, 25784, 696, 973, "Input"],
Cell[77211, 2035, 355, 8, 31, "Input"],
Cell[77569, 2045, 25767, 692, 973, "Input"],
Cell[103339, 2739, 1848, 49, 108, "Input"],
Cell[105190, 2790, 122182, 3278, 2038, "Input"],
Cell[227375, 6070, 168, 2, 27, "Input"],
Cell[227546, 6074, 231, 5, 39, "Input"],
Cell[227780, 6081, 216, 5, 31, "Input"],
Cell[227999, 6088, 1333, 29, 133, "Input"],
Cell[229335, 6119, 326, 6, 31, "Input"],
Cell[229664, 6127, 44065, 1088, 913, "Input"],
Cell[273732, 7217, 203, 4, 31, "Input"],
Cell[CellGroupData[{
Cell[273960, 7225, 115292, 2687, 2188, "Input"],
Cell[389255, 9914, 881, 16, 20, "Print"]
}, Open  ]],
Cell[390151, 9933, 329, 7, 31, "Input"],
Cell[CellGroupData[{
Cell[390505, 9944, 1830, 51, 43, "Input"],
Cell[392338, 9997, 2113, 54, 330, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
