function [sign_eigenval]=Max_plane_1el

%Draws the iapp-gsyn plane of maximum improvement due to stimulation
%over the full range of stimulation strengths

%Generates figures 8A and 8B in PLoS One paper

load PCA_eigenval_w0.3.mat
S= 0;
M = 0;
sign_eigenval = zeros(38,10,5);
for i = 1:38
    for j = 1:10
       for k = 1:5
            if size(pca_eigenval{i,j,k}) ~= 0
                n = 10;
                S = sum(pca_eigenval{i,j,k});
                M = pca_eigenval{i,j,k}(n);
              while n >= 1
               n = n - 1;
               if M > 0.8*S
                   sign_eigenval(i,j,k) = 10 - n;
                   n = 0;
               else M = M + pca_eigenval{i,j,k}(n);
               end                 
              end
            else
            sign_eigenval(i,j,k) = 0;
            end
       end
    end
end

x1_ix = 0;

for iapp = 4:8
  x1_ix=x1_ix+1;
  x2_ix = 0;
  for gsyn = .5:.1:1.4
    x2_ix=x2_ix+1;
    x3_ix = 0;
    imax = 0;
    for Kn = 0:2:74
        x3_ix=x3_ix+1;
        ii = sign_eigenval(x3_ix,x2_ix,x1_ix)-sign_eigenval(1,x2_ix,x1_ix);
            
     if ii > imax 
        imax = ii;
     end;
    end
            if imax <= 0
                scatter(gsyn,iapp,'ok')
            elseif imax ==1
                scatter(gsyn,iapp,'g','filled')
             elseif imax ==2
                scatter(gsyn,iapp,'r','filled')    
            elseif imax >= 3
                scatter(gsyn,iapp,'k','filled')
            end    
            hold on
  end
end  
xlabel('g_{syn}');ylabel('I_{app}');
fOut3 = sprintf('MaxdiffPCAplane_w0.3.fig');
hgsave(fOut3);

end


