function [sign_eigenval]=Sign_subset

%uses PCA analysis to find the # of significant eigenvalues among those 
%computed via PCAgenerator.m

%we would use 80% threshold to choose the significant subset of eigenvalues

load PCA_eigenval_w0.3.mat
S = 0;
M = 0;
sign_eigenval = zeros(31,10,5);
for i = 1:31
    for j = 1:10
       for k = 1:5
            if size(pca_eigenval{i,j,k}) ~= 0
                n = 10;
                S = sum(pca_eigenval{i,j,k});
                M = pca_eigenval{i,j,k}(n);
              while n >= 1
               n = n - 1;
               if M > 0.8*S
                   sign_eigenval(i,j,k) = 10 - n;
                   n = 0;
               else M = M + pca_eigenval{i,j,k}(n);
               end                 
              end
            else
            sign_eigenval(i,j,k) = 0;
            end
       end
    end
end
save('Sign_eig_w0.3.mat','sign_eigenval')

%Don't use Choongseok data
%format = '%*f32%*f32%f32';
%fid = fopen('pca_number.dat', 'r');
%pca_number = textscan(fid, format);
%fclose(fid);

x1_ix = 0;

for iapp = 4:8
  x1_ix=x1_ix+1;
  x2_ix = 0;
  for gsyn = .5:.1:1.4
    x2_ix=x2_ix+1;
    x3_ix = 0;
    for Kn = 0:2:60
        x3_ix=x3_ix+1;
        %use our own eigenvalues with Cn=0 as a baseline      
        ii = sign_eigenval(x3_ix,x2_ix,x1_ix)-sign_eigenval(1,x2_ix,x1_ix);
            
            if ii <= -2
                color='k';
            elseif ii == -1
                color='r';
            elseif ii == 0 
                color='w';
            elseif ii == 1
                color='b';
            elseif ii ==2
                color='y';
            elseif ii >= 3
                color='g';
            end
                   
           scatter(gsyn,Kn,50,color,'filled')
           hold on
   end
 end
    
val='# of PCA components with stim - without stim';
xlabel('gsyn');ylabel('Kn');
title(strcat(val,': <=2 blk, -1 r, 0 w, 1 b, 2 y, >=3 g'))
fOut2 = sprintf('diffgsynKnplane_w0.3_%s%1.1f.fig','Iapp',iapp);
hgsave(fOut2);

end

end


