%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                           GenerateInputFileBurst.m                      %
%                           ------------------------                      %
% copyright            : (C) 2013 by Jesus Garrido                        %
% email                : jesus.garrido@unipv.it                           %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function GenerateInputFileBurst(FileName, MFInit, MFNumber, FirstBurstTime, IntraBurstFrequency, SpikeProbability, SpikeTimeStd, SpikesPerBurst, InterBurstFrequency, NumberOfBursts, NoiseMatrix)
    fid=fopen(FileName,'w');
    fprintf(fid,'// Generated by GenerateInputFileGaussian\n');
    % Number of inputs
   
    NumberOfTrains = SpikesPerBurst*NumberOfBursts;
    
    Spiker = rand(NumberOfBursts,SpikesPerBurst,MFNumber);
    ref = find(Spiker<=SpikeProbability);
    SpikeNumber = length(ref);
    
    InterBurstPeriod = 1/InterBurstFrequency;
    IntraBurstPeriod = 1/IntraBurstFrequency;
        
    fprintf(fid,'%i\n',SpikeNumber+size(NoiseMatrix,1));
    Values = randn(NumberOfBursts,SpikesPerBurst,MFNumber).*SpikeTimeStd;
    
    for iBurst=1:1:NumberOfBursts,
        for iSpike=1:1:SpikesPerBurst,
            for neuron=0:1:MFNumber-1,
                if (Spiker(iBurst,iSpike,neuron+1)<=SpikeProbability)
                    fprintf(fid,'%f 1 0 %i 1\n',FirstBurstTime+InterBurstPeriod*(iBurst-1)+IntraBurstPeriod*(iSpike-1)+Values(neuron+1),MFInit+neuron);
                end
            end            
        end
    end
    
    for i=1:1:size(NoiseMatrix,1),
        fprintf(fid,'%f 1 0 %i 1\n',NoiseMatrix(i,1),NoiseMatrix(i,2));
    end
    fclose(fid);
    
   