/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToNominal
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    private static final long serialVersionUID = 4864084427902797605L;
    private Range m_AttIndices = new Range("last");

    public String globalInfo() {
        return "Converts a range of string attributes (unspecified number of values) to nominal (set number of values). You should ensure that all string values that will appear are represented in the first batch of the data.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_AttIndices.setUpper(instanceInfo.numAttributes() - 1);
        return false;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isOutputFormatDefined()) {
            Instance newInstance = (Instance)instance.copy();
            this.push(newInstance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isOutputFormatDefined()) {
            this.setOutputFormat();
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.push((Instance)this.getInputFormat().instance(i).copy());
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tSets the range of attribute indices (default last).", "R", 1, "-R <col>"));
        newVector.addElement(new Option("\tInvert the range specified by -R.", "V", 1, "-V <col>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String attIndices = Utils.getOption('R', options);
        if (attIndices.length() != 0) {
            this.setAttributeRange(attIndices);
        } else {
            this.setAttributeRange("last");
        }
        String invertSelection = Utils.getOption('V', options);
        if (invertSelection.length() != 0) {
            this.m_AttIndices.setInvert(true);
        } else {
            this.m_AttIndices.setInvert(false);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[this.m_AttIndices.getInvert() ? 7 : 6];
        int current = 0;
        options[current++] = "-R";
        options[current++] = "" + this.getAttributeRange();
        while (current < options.length) {
            options[current++] = "";
        }
        if (this.m_AttIndices.getInvert()) {
            options[current++] = "-V";
        }
        return options;
    }

    public String attributeRangeTipText() {
        return "Sets which attributes to process. This attributes must be string attributes (\"first\" and \"last\" are valid values as well as ranges and lists)";
    }

    public String getAttributeRange() {
        return this.m_AttIndices.getRanges();
    }

    public void setAttributeRange(String rangeList) {
        this.m_AttIndices.setRanges(rangeList);
    }

    private void setOutputFormat() {
        FastVector newAtts = new FastVector(this.getInputFormat().numAttributes());
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (!this.m_AttIndices.isInRange(j) || !att.isString()) {
                newAtts.addElement(att);
                continue;
            }
            FastVector newVals = new FastVector(att.numValues());
            for (int i = 0; i < att.numValues(); ++i) {
                newVals.addElement(att.value(i));
            }
            newAtts.addElement(new Attribute(att.name(), newVals));
        }
        Instances newData = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        newData.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(newData);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5547 $");
    }

    public static void main(String[] argv) {
        StringToNominal.runFilter(new StringToNominal(), argv);
    }
}

