/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.ThresholdDataEvent;
import weka.gui.beans.ThresholdDataListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.VisualizableErrorEvent;
import weka.gui.beans.VisualizableErrorListener;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class ModelPerformanceChart
extends JPanel
implements ThresholdDataListener,
VisualizableErrorListener,
Visible,
UserRequestAcceptor,
Serializable,
BeanContextChild {
    private static final long serialVersionUID = -4602034200071195924L;
    protected BeanVisual m_visual;
    protected transient PlotData2D m_masterPlot;
    protected transient JFrame m_popupFrame;
    protected boolean m_framePoppedUp = false;
    protected boolean m_design;
    protected transient BeanContext m_beanContext = null;
    private transient VisualizePanel m_visPanel;
    protected BeanContextChildSupport m_bcSupport = new BeanContextChildSupport(this);

    public ModelPerformanceChart() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!ge.isHeadless()) {
            this.appearanceFinal();
        }
    }

    public String globalInfo() {
        return "Visualize performance charts (such as ROC).";
    }

    protected void appearanceDesign() {
        this.removeAll();
        this.m_visual = new BeanVisual("ModelPerformanceChart", "weka/gui/beans/icons/ModelPerformanceChart.gif", "weka/gui/beans/icons/ModelPerformanceChart_animated.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setUpFinal();
    }

    protected void setUpFinal() {
        if (this.m_visPanel == null) {
            this.m_visPanel = new VisualizePanel();
        }
        this.add((Component)this.m_visPanel, "Center");
    }

    public synchronized void acceptDataSet(ThresholdDataEvent e) {
        if (this.m_visPanel == null) {
            this.m_visPanel = new VisualizePanel();
        }
        if (this.m_masterPlot == null) {
            this.m_masterPlot = e.getDataSet();
        }
        try {
            if (!this.m_masterPlot.getPlotInstances().relationName().equals(e.getDataSet().getPlotInstances().relationName())) {
                this.m_masterPlot = e.getDataSet();
                this.m_visPanel.setMasterPlot(this.m_masterPlot);
                this.m_visPanel.validate();
                this.m_visPanel.repaint();
            } else {
                this.m_visPanel.addPlot(e.getDataSet());
                this.m_visPanel.validate();
                this.m_visPanel.repaint();
            }
            this.m_visPanel.setXIndex(4);
            this.m_visPanel.setYIndex(5);
        }
        catch (Exception ex) {
            System.err.println("Problem setting up visualization (ModelPerformanceChart)");
            ex.printStackTrace();
        }
    }

    public synchronized void acceptDataSet(VisualizableErrorEvent e) {
        if (this.m_visPanel == null) {
            this.m_visPanel = new VisualizePanel();
        }
        if (this.m_masterPlot == null) {
            this.m_masterPlot = e.getDataSet();
        }
        try {
            this.m_visPanel.setMasterPlot(this.m_masterPlot);
        }
        catch (Exception ex) {
            System.err.println("Problem setting up visualization (ModelPerformanceChart)");
            ex.printStackTrace();
        }
        this.m_visPanel.validate();
        this.m_visPanel.repaint();
    }

    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultDataVisualizer.gif", "weka/gui/beans/icons/DefaultDataVisualizer_animated.gif");
    }

    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_masterPlot != null) {
            newVector.addElement("Show chart");
            newVector.addElement("?Clear all plots");
        }
        return newVector.elements();
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.m_bcSupport.addPropertyChangeListener(name, pcl);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.m_bcSupport.removePropertyChangeListener(name, pcl);
    }

    public void addVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.m_bcSupport.addVetoableChangeListener(name, vcl);
    }

    public void removeVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.m_bcSupport.removeVetoableChangeListener(name, vcl);
    }

    public void setBeanContext(BeanContext bc) {
        this.m_beanContext = bc;
        this.m_design = this.m_beanContext.isDesignTime();
        if (this.m_design) {
            this.appearanceDesign();
        } else {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (!ge.isHeadless()) {
                this.appearanceFinal();
            }
        }
    }

    public BeanContext getBeanContext() {
        return this.m_beanContext;
    }

    public void performRequest(String request) {
        block7: {
            if (request.compareTo("Show chart") == 0) {
                try {
                    if (!this.m_framePoppedUp) {
                        this.m_framePoppedUp = true;
                        final JFrame jf = new JFrame("Model Performance Chart");
                        jf.setSize(800, 600);
                        jf.getContentPane().setLayout(new BorderLayout());
                        jf.getContentPane().add((Component)this.m_visPanel, "Center");
                        jf.addWindowListener(new WindowAdapter(){

                            public void windowClosing(WindowEvent e) {
                                jf.dispose();
                                ModelPerformanceChart.this.m_framePoppedUp = false;
                            }
                        });
                        jf.setVisible(true);
                        this.m_popupFrame = jf;
                        break block7;
                    }
                    this.m_popupFrame.toFront();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.m_framePoppedUp = false;
                }
            } else if (request.equals("Clear all plots")) {
                this.m_visPanel.removeAllPlots();
                this.m_visPanel.validate();
                this.m_visPanel.repaint();
                this.m_visPanel = null;
                this.m_masterPlot = null;
            } else {
                throw new IllegalArgumentException(request + " not supported (Model Performance Chart)");
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.err.println("Usage: ModelPerformanceChart <dataset>");
                System.exit(1);
            }
            BufferedReader r = new BufferedReader(new FileReader(args[0]));
            Instances inst = new Instances(r);
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            ModelPerformanceChart as = new ModelPerformanceChart();
            PlotData2D pd = new PlotData2D(inst);
            pd.setPlotName(inst.relationName());
            ThresholdDataEvent roc = new ThresholdDataEvent(as, pd);
            as.acceptDataSet(roc);
            jf.getContentPane().add((Component)as, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

