    TITLE Endoplasmic Reticulum
	
    UNITS {
	(molar) = (1/liter)	
	(mM)	= (millimolar)
	(nA) = (nanoamp)
    (mA) = (milliampere)

	
    (um) = (micron)
    FARADAY = (faraday) (coulomb)
    PI = (pi) (1)
    }

    NEURON {
	RANGE tau, beta, gamma, scale, t1, ical, ip3min, spkcnt, ip3ip
	USEION cal READ cali WRITE ical
	POINTER ip3im, ip3id
	}

    STATE {
	cali (mM)
    caer (mM)
	Jip3h (1)
	Jip3m (1)
	 
	Jip3z (mM/ms)
	ERrelz (mM/ms)
	ERfilz (mM/ms)
	ERlekz (mM/ms)

	ier (mA/cm2)

    }

    PARAMETER {
    fer = 0.0025              : ca buffering coefficient in ER from John Rinzel 1997
    kerm = 0.2e-3 (mM) : from Huang 2004
    kerrel = 3e-12  (/s): from Huang, to be adjusted
    kerfila = 0.75e-12 (mM/s) : from John Rinzel 1997
    kerfilb = 0.2e-3 (mM) : from John Rinzel 1997
    kerlek = 6.15e-14 (/s): from Huang, to be adjusted
    rhover = 0.15 : ratio of volume to cytoplasmic volume
    : total cell vol = vol_cytoplasm + vol_er
    : where vol_er = rhover * vol_cytoplasm
    : thus vol_er = v_cell * rhover / (1 + rhover)
    caer0 = 0.20 (mM)
	Jip3h0 =0.2
	Jip3m0 =0.2
	
	Vip3 = 1e-9:1e-5 (1/cm2/s):1e-8(1/cm2/ms):
	dact = 8.2e-5 (mM):8.2e-2(uM)
	dinh = 1.05e-3 (mM):1.05(uM)
	dip3 = 0.13e-3 (mM):0.13(uM)
	ddis = 0.94e-3 (mM):0.94(uM)
	aip3  = 0.42e6 (1/mM/s):0.42(1/uM/ms)
	bip3 = 4.1 (1/s):4.1e-3(1/ms)
	ainh = 2e-4 (mM/s):2e-4(uM/ms)
	   
    }

    ASSIGNED {
       diam (um)
       ical (mA/cm2)

		ip3ip (mM)
		ip3id (mM)
		ip3im (mM)

	}

    INITIAL {
       : custom initialization may be needed
   caer = caer0 : initial calcium concentration in ER
   Jip3h = Jip3h0
   Jip3m = Jip3m0
   
    }

    BREAKPOINT {
       SOLVE states METHOD derivimplicit
	:cnexp  euler  derivimplicit
	  
	     ip3ip=ip3im+ip3id

	  
	ical = -2*FARADAY*(2e8*Jip3(cali,caer, ip3ip, Vip3, dact, dinh, dip3, ddis) +errel(cali,caer,kerrel,kerm)-erfil(cali,caer,kerfila,kerfilb)+erlek(cali,caer,kerlek)) * diam * (1e-7) / 4
	
	
 	:ix = -ical
	ier=ical
	

	Jip3z=Jip3(cali,caer, ip3ip, Vip3, dact, dinh, dip3, ddis)
	ERrelz=errel(cali,caer,kerrel,kerm)
	ERfilz=erfil(cali,caer,kerfila,kerfilb)
	ERlekz=erlek(cali,caer,kerlek)
    }

DERIVATIVE states {
    caer' = -(0.001)*( Jip3(cali,caer, ip3ip, Vip3, dact, dinh, dip3, ddis)
+errel(cali,caer,kerrel,kerm)-erfil(cali,caer,kerfila,kerfilb)+erlek(cali,caer,kerlek))/(rhover/fer)

	Jip3h'=(Jip3hinf(ip3ip, cali, dinh, dip3, ddis)-Jip3h)/Jip3th (ip3ip , ainh , cali , dinh , dip3 , ddis )
	Jip3m'=(Jip3minf(ip3ip, cali, dip3, dact)-Jip3m)/Jip3tm (cali , bip3, aip3 )
}


	FUNCTION errel(cali (mM),caer (mM),kerrel (/s),kerm (mM)) (mM/s) { : from Huang
		errel = kerrel*pow((cali/(cali+kerm)),1)*(caer-cali)
	}

    FUNCTION erfil(cali (mM),caer (mM),kerfila (mM/s),kerfilb (mM)) (mM/s) { : from John Rinzel 1997
       erfil = kerfila * pow(cali/(1 (mM)),2) / ( pow(cali/(1 (mM)),2) + pow(kerfilb/(1 (mM)),2) )
    }

    FUNCTION erlek(cali (mM),caer(mM),kerlek (/s)) (mM/s) { : from Huang
		erlek = kerlek*(caer-cali)
    }
	
	
	FUNCTION Jip3(cali (mM),caer (mM), ip3ip (mM), Vip3 (1/cm2/ms), dact (mM), dinh (mM), dip3 (mM), ddis (mM)) (mM/s) {
       :Jip3 = Vip3*pow(Jip3m(ip3ip, cali, dip3, dact),3)*pow(Jip3hinf(ip3ip, cali, dinh, dip3, ddis),3)*(caer-cali)
	   Jip3 = Vip3*pow(Jip3m,3)*pow(Jip3h,3)*(caer-cali)
    }
	
	FUNCTION Jip3minf (ip3ip (mM), cali (mM), dip3 (mM), dact (mM)){
	Jip3minf = (ip3ip/(ip3ip+dip3)) * (cali/(cali+dact))
	}
	
	
	FUNCTION Jip3tm (cali (mM), bip3 (1/ms), aip3 (1/mM/ms)){
	Jip3tm = 1/(bip3+aip3*cali)	
	}
	
	FUNCTION Jip3hinf (ip3ip (mM), cali (mM), dinh (mM), dip3 (mM), ddis (mM)){
	Jip3hinf = Jip3Q(ip3ip, dinh, dip3, ddis) / (Jip3Q(ip3ip, dinh, dip3, ddis) + cali)
	}
	
	FUNCTION Jip3th (ip3ip (mM), ainh (mM/ms), cali (mM), dinh (mM), dip3 (mM), ddis (mM)){
	Jip3th = 1/(ainh*Jip3Q(ip3ip, dinh, dip3, ddis)+cali)
	}
	
	FUNCTION Jip3Q (ip3ip (mM), dinh (mM), dip3 (mM), ddis (mM)){
	Jip3Q = dinh*((ip3ip+dip3)/(ip3ip+ddis))
	}
	

