NEURON {
	POINT_PROCESS calciumgap
	NONSPECIFIC_CURRENT ig
	USEION ca READ cai WRITE ica
	RANGE r, cap, ig, ica
	POINTER vgap, cagap
}
UNITS {
	(mV)	=	(millivolt)
	(mA)	=	(milliamp)
}
PARAMETER {
	v (mV)
	vgap (mV)
	cai (micromolar)
	cagap (micromolar)
	r = 1e10 (megaohm)
	cap = 0.3
}
ASSIGNED {
	ig (nanoamp)
	ica (nanoamp)
}
BREAKPOINT {
	ica = cap*((v - vgap)-(25.69*log(cagap/cai)))/r
	ig = ((v - vgap)/r) - ica
}
