% common functions here

% mimic XPP's Init Conds->Range values
vary_steps = ...
    @(start_val, end_val, num_steps) start_val + ...
    (0:num_steps)*(end_val - start_val)/num_steps;

plot_cip_stats = ...
    @(b_db, str, colx, coly) ...
    subsref(get(get(plot_bars(delColumns(statsMeanSE(swapRowsPages(groupBy(b_db(:, {'TraceNum', colx, coly}), ...
                                                  'TraceNum'))), 'RowIndex'), ...
              str, struct('pageVariable', colx, ...
                          'groupValuesLoc', 1, ...
                          'noTitle', 1, ...
                          'quiet', 1, ...
                          'axisProps', struct('Box', 'off'), ...
                          'dispBarsLines', 'lines', ...
                          'dispNvals', 0)), 'plot_stack'), 'plots'), ...
            setfield(struct('type', '{}'), 'subs', {1}));
% $$$ set('axis_labels', {'current [pA]', 'cell 1 - firing rate [Hz]'})

plot_XPP_Irange_xy = ...
    @(filename, I_range, x_test, x_name, y_test, y_name, params_struct) ...
    set(plotScatter(XPPrange2CIPdb(filename, ...
                      [10 510], I_range, ...
                                   struct('threshold', 1, 'downThreshold', -0.5, ...
                                          'minInit2MaxAmp', 2, ...
                                          'minMin2MaxAmp', 2, 'paramsStruct', ...
                             params_struct)), ...
                           x_test, y_test, ['XPP model CIP scatter: ' x_test ' vs. ' y_test], 'model', ...
                           struct('noTitle', 1, 'LineStyle', '-', 'fixedSize', [2.5 2], ...
                                  'axisProps', struct('Box', 'off'))), ...
                   'axis_labels', {x_name, y_name});

plot_XPP_Irange = ...
    @(filename, I_range, y_test, y_name, params_struct) ...
    plot_XPP_Irange_xy(filename, I_range, 'cip_level_pA', 'current [pA]', y_test, y_name, params_struct);

% f-I
plot_XPP_fI_Irange = ...
    @(filename, I_range, params_struct) ...
    plot_XPP_Irange(filename, I_range, ...
                    'PulseSpikeRateISI', 'firing rate [Hz]', ...
                    params_struct);


plot_XPP_delay_I_Irange = ...
    @(filename, I_range, params_struct) ...
    plot_XPP_Irange(filename, I_range, ...
                    'PulseFirstSpikeTime', '1st spike delay [ms]', ...
                    params_struct);

plot_XPP_pulsepot_I_Irange = ...
    @(filename, I_range, params_struct) ...
    plot_XPP_Irange(filename, I_range, ...
                    'PulsePotAvg', 'Avg. Mem. Pot. [mV]', ...
                    params_struct);

% V-f 
plot_XPP_pulsepot_rate_Irange = ...
    @(filename, I_range, params_struct) ...
    plot_XPP_Irange_xy(filename, I_range, 'PulseSpikeRateISI', 'firing rate [Hz]', ...
                       'PulsePotAvg', 'Avg. Mem. Pot. [mV]', params_struct);

% f-V curve
plot_XPP_rate_pulsepot_Irange = ...
    @(filename, I_range, params_struct) ...
    plot_XPP_Irange_xy(filename, I_range, 'PulsePotAvg', 'Avg. Mem. Pot. [mV]', ...
                       'PulseSpikeRateISI', 'firing rate [Hz]', params_struct);

plot_XPP_spikeinitVm_I_Irange = ...
    @(filename, I_range, params_struct) ...
    plot_XPP_Irange(filename, I_range, ...
                    'PulseSpikeInitVmMean', 'Spike threshold [mV]', ...
                    params_struct);

plot_XPP_spikeinitVm_rate_Irange = ...
    @(filename, I_range, params_struct) ...
    plot_XPP_Irange_xy(filename, I_range, 'PulseSpikeRateISI', 'firing rate [Hz]', ...
                       'PulseSpikeInitVmMean', 'Spike threshold [mV]', params_struct);

plot_XPP_spikeminVm_I_Irange = ...
    @(filename, I_range, params_struct) ...
    plot_XPP_Irange(filename, I_range, ...
                    'PulseSpikeMinVmMean', 'Spike min. [mV]', ...
                    params_struct);

plot_XPP_spikeminVm_rate_Irange = ...
    @(filename, I_range, params_struct) ...
    plot_XPP_Irange_xy(filename, I_range, 'PulseSpikeRateISI', 'firing rate [Hz]', ...
                       'PulseSpikeMinVmMean', 'Spike min. [mV]', params_struct);

