clear all

addpath 'Skuld_2_2' 'Urd_v1_2' 'VerdandiLite_v1_0'

global Network

disp('Preparing simulations')
tic 

% --- Time integration ---

Network.dt = 0.1; % Integration step (in ms)
Network.nStep = 20000; % Number of time steps

Network.OutputVm = 1; % 1=Output membrane potentials to Vm.txt, 0=no such output
Network.OutputSp = 1; % 1=Output spike times to Spikes.txt, 0=no such output

fInit = fopen('Inits.txt','w');
fprintf(fInit,'%u\t%g\n%u\t%u',Network.nStep,Network.dt,Network.OutputVm,Network.OutputSp);
fclose(fInit);

% Model of the Basal Ganglia following Rubin Terman 2002.
% Uses Izhikevich neurons.
% Parameters need tweaking...

% --- Populations ---
N = 41;

AddPopulation(...
    'Name','STN',...
    'nCell', N, ...
    'Type','Izhikevich',... 
    'I',4+25,... 
    'a','Normal',[0.005 0.001],...
    'b',0.2,...
    'c','Normal',[-65 2],...
    'd',0.5,...
    'V','Normal', [-65 5],...
    'w',0,...
    'Position',rand(N,3));

AddPopulation(...
    'Name','GPe',...
    'nCell', N, ...
    'Type','Izhikevich',... 
    'I',20.5+2,... % set additional applied current to 2 for tremor
    'a','Normal',[0.008 0.001],...
    'b',0.15,...
    'c','Normal',[-50 1],...
    'd',0.8,...
    'V','Normal', [-65 5],...
    'w',0,...
    'Position',rand(N,3));

AddPopulation(...
    'Name','Striatum',...
    'nCell',10,...
    'Type','Poisson',...
    'Lambda',20,...
    'Position',rand(10,3));

% --- Connections ---    
AddConnectivity(...
    'From','STN',...
    'To','GPe',...
    'Type','Exponential',...
    'Tau',6,'E',0,'g',0.3,...
    'Connections','Matrix',eye(N), ...
    'Delay','Function', 1);
  

AddConnectivity(...
    'From','GPe',...
    'To','GPe',...
    'Type','Exponential',...
    'Tau',25,'E',-80,'g',1*0.5*0.5*1,... % switch to 0.2 for tremor
    'Connections','Matrix',circshift(eye(N),1)+circshift(eye(N),-1), ...
    'Delay','Function', 0);

AddConnectivity(...
    'From','GPe',...
    'To','STN',...
    'Type','Exponential',...
    'Tau',25,'E',-100,'g',0.5*0.5*0.9,...
    'Connections','Matrix',circshift(eye(N),2)+circshift(eye(N),-2), ...
    'Delay','Function', 1);

AddConnectivity(...
    'From','Striatum',...
    'To',{'STN','GPe'},...
    'Type','Exponential',...
    'Tau',25,'E',-80,'g',0.5,...
    'Connections','Generate','Probability',0.6,'Weight',@(r) 1+rand(size(r)),...
    'Delay','Function',0);


WriteCells;
WriteConnectivity;

toc
disp('Running simulations')
tic 


if(ismac)
    system('VerdandiLite_v1_0/VerdandiLite_OSX');
elseif(ispc)
    system('VerdandiLite_v1_0\VerdandiLite_WIN32.exe');
else
    error('No binaries available for VerdandiLite. Please compile C++ source files and add modify these Matlab lines.')
end


toc

SkuldOut
Skuld('SkuldSet.mat')