clear all

addpath 'Skuld_2_2' 'Urd_v1_2' 'VerdandiLite_v1_0'

global Network

disp('Preparing simulations')
tic 

% --- Time integration ---

Network.dt = 0.1; % Integration step (in ms)
Network.nStep = 10000; % Number of time steps

Network.OutputVm = 1; % 1=Output membrane potentials to Vm.txt, 0=no such output
Network.OutputSp = 1; % 1=Output spike times to Spikes.txt, 0=no such output

fInit = fopen('Inits.txt','w');
fprintf(fInit,'%u\t%g\n%u\t%u',Network.nStep,Network.dt,Network.OutputVm,Network.OutputSp);
fclose(fInit);

% Generate a simple 2E, 1I cell network:
%
%         I
%       /  ^
%      /   |
%     L    |
%   E1 <=> E2
%

% --- Populations ---
AddPopulation(...
    'Name','Ecells',...
    'nCell', 2, ...
    'Type','LeakyIntegrate',... 
    'C', [15; 14],...
    'VRest', -65,...
    'VThreshold', -66,...
    'VReset', -75,...
    'V','Normal',[-70, 3],...
    'Position',[0,0,0; 1,0,0]);

AddPopulation(...
    'Name','Icells',...
    'nCell', 1, ...
    'Type','LeakyIntegrate',... 
    'C', 10,...
    'VRest', -70,...
    'VThreshold', -66,...
    'VReset', -80,...
    'V','Normal',[-70, 4],...
    'Position',[1,1,0]);

% --- Connections ---    
AddConnectivity(...
    'From','Ecells',...
    'To',{'Ecells','Icells'},...
    'Type','Delta',...
    'Connections','Matrix',...
        [0, 2;
         1, 0;
         0, 4],...
    'Delay','Function',2);
   
AddConnectivity(...
    'From','Icells',...
    'To',{'Ecells'},...
    'Type','Exponential',...
    'Tau',10,'E',-80,'g',0.4,...
    'Connections','Matrix',...
        [1;
         0],...
    'Delay','Function',@(r) r+2);



% --- Output to files 
WriteCells;
WriteConnectivity;
toc

% --- run simulation in C++ environment
disp('Running simulations')
tic 

if(ismac)
    system('VerdandiLite_v1_0/VerdandiLite_OSX');
elseif(ispc)
    system('VerdandiLite_v1_0\VerdandiLite_WIN32.exe');
else
    error('No binaries available for VerdandiLite. Please compile C++ source files and add modify these Matlab lines.')
end


toc

SkuldOut
Skuld('SkuldSet.mat')