/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.be;

import org.catacomb.be.Position;
import org.catacomb.report.E;

public class Direction {
    double vx;
    double vy;
    double cosine;
    double sine;

    public Direction(Direction d) {
        this(d.getXCpt(), d.getYCpt());
    }

    public Direction(double a, double b) {
        this.vx = a;
        this.vy = b;
        double d = Math.sqrt(this.vx * this.vx + this.vy * this.vy);
        if (d == 0.0) {
            d = 1.0;
            this.vx = 1.0;
            E.warning("created direction with zero vector");
        }
        this.cosine = this.vx / d;
        this.sine = this.vy / d;
    }

    public double getCosine() {
        return this.cosine;
    }

    public double getSine() {
        return this.sine;
    }

    public double getXCpt() {
        return this.vx;
    }

    public double getYCpt() {
        return this.vy;
    }

    public Position destination(double d) {
        return new Position(d * this.cosine, d * this.sine);
    }

    public static Direction fromTo(Position pa, Position pb) {
        return new Direction(pb.getX() - pa.getX(), pb.getY() - pa.getY());
    }
}

