/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.catacomb.graph.gui.WorldTransform;

public class AxisPainter {
    Graphics2D graphics;
    WorldTransform wt;

    public AxisPainter(Graphics2D g, WorldTransform t) {
        this.graphics = g;
        this.wt = t;
    }

    public void drawAxes() {
        int lm = this.wt.getLeftMargin();
        int bm = this.wt.getBottomMargin();
        int width = this.wt.getWidth();
        int height = this.wt.getHeight();
        this.graphics.setColor(Color.lightGray);
        this.graphics.fillRect(0, 0, lm, height);
        this.graphics.fillRect(0, height - bm, width, bm);
        this.graphics.setColor(Color.black);
        this.drawXAxis();
        this.drawYAxis();
    }

    public void labelAxes(String xlabel, String ylabel) {
        int ily;
        int ilx;
        int lm = this.wt.getLeftMargin();
        int bm = this.wt.getBottomMargin();
        int width = this.wt.getWidth();
        int height = this.wt.getHeight();
        FontMetrics fm = this.graphics.getFontMetrics();
        if (xlabel != null) {
            ilx = (width - lm) / 2 - fm.stringWidth(xlabel) / 2;
            ily = height - 3;
            this.graphics.drawString(xlabel, lm + ilx, ily);
        }
        if (ylabel != null) {
            ilx = 18;
            ily = (height - bm) / 2 + fm.stringWidth(ylabel) / 2;
            AffineTransform at = this.graphics.getTransform();
            this.graphics.translate((double)ilx, (double)ily);
            this.graphics.rotate(-1.5707963267948966);
            this.graphics.drawString(ylabel, 0, 0);
            this.graphics.setTransform(at);
        }
    }

    public final void drawXAxis() {
        int[] intervals = new int[]{1, 2, 5};
        int ntick = 5;
        int lm = this.wt.getLeftMargin();
        int bm = this.wt.getBottomMargin();
        int width = this.wt.getWidth();
        int height = this.wt.getHeight();
        this.graphics.drawLine(lm, height - bm, width, height - bm);
        double[] xr = this.wt.getXRange();
        double xran = Math.abs(xr[1] - xr[0]);
        double dx = 1.5 * xran / (double)ntick;
        double log = Math.log(dx) / Math.log(10.0);
        double powten = (int)Math.floor(log);
        int iiind = (int)(2.999 * (log - powten));
        int ii = intervals[iiind];
        dx = Math.pow(10.0, powten) * (double)ii;
        int i0 = (int)(xr[0] / dx);
        int i1 = (int)(xr[1] / dx);
        int i = i0;
        while (i <= i1) {
            double xx = (double)i * dx;
            String lab = "0";
            if (i != 0) {
                lab = dx >= 0.999 && dx < 10000.0 ? String.valueOf((int)xx) : String.valueOf((float)xx);
            }
            int off = lab.length();
            off = 1 - 4 * off;
            if ((double)i * dx < 0.0) {
                off -= 4;
            }
            int ix = (int)((double)lm + (double)(width - lm) * (xx - xr[0]) / (xr[1] - xr[0]));
            this.graphics.drawString(lab, ix + off, height - bm + 20);
            this.graphics.drawLine(ix, height - bm, ix, height - bm + 5);
            ++i;
        }
    }

    public final void drawYAxis() {
        FontMetrics fm = this.graphics.getFontMetrics();
        int[] intervals = new int[]{1, 2, 5};
        int ntick = 5;
        int height = this.wt.getHeight();
        int lm = this.wt.getLeftMargin();
        int bm = this.wt.getBottomMargin();
        this.graphics.drawLine(lm, height - bm, lm, 0);
        double[] yr = this.wt.getYRange();
        double ylow = yr[0];
        double yhigh = yr[1];
        double yran = Math.abs(yhigh - ylow);
        double dy = 1.5 * yran / (double)ntick;
        double log = Math.log(dy) / Math.log(10.0);
        double powten = (int)Math.floor(log);
        int iiind = (int)(2.999 * (log - powten));
        int ii = intervals[iiind];
        dy = Math.pow(10.0, powten) * (double)ii;
        int i0 = (int)(ylow / dy);
        int i1 = (int)(yhigh / dy);
        int i = i0;
        while (i <= i1) {
            double yy = (double)i * dy;
            String lab = "0";
            if (i != 0) {
                lab = dy >= 0.999 && dy < 10000.0 ? String.valueOf((int)yy) : String.valueOf((float)yy);
            }
            int iy = height - bm - (int)((double)(height - bm) * (yy - ylow) / (yhigh - ylow));
            int off = fm.stringWidth(lab);
            this.graphics.drawString(lab, lm - 12 - off, iy + 4);
            this.graphics.drawLine(lm - 5, iy, lm, iy);
            ++i;
        }
    }
}

