/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview;

import java.io.File;
import org.catacomb.dataview.DataViewer;
import org.catacomb.dataview.DataviewController;
import org.catacomb.interlish.structure.Element;
import org.catacomb.report.E;
import org.catacomb.serial.ElementImporter;
import org.catacomb.util.FileUtil;

public class BatchImageMaker {
    File fsrc;
    File fviewdir;
    File fdestdir;

    public static void main(String[] argv) {
        BatchImageMaker bim = new BatchImageMaker(argv);
        bim.process();
    }

    public BatchImageMaker(String[] argv) {
        this.fsrc = new File(argv[0]);
        this.fviewdir = new File(argv[1]);
        this.fdestdir = new File(argv[2]);
    }

    public void process() {
        E.info("about to read " + this.fsrc);
        Element srcelt = ElementImporter.getElement(this.fsrc);
        Element[] elta = srcelt.getElementArray();
        int i = 0;
        while (i < elta.length) {
            Element elt = elta[i];
            if (elt.getName().equals("figure")) {
                this.makeFigure(elt);
            } else if (elt.getName().equals("movie")) {
                this.makeMovie(elt);
            } else {
                E.warning("unknown element type in figure list " + elt);
            }
            ++i;
        }
    }

    public void makeFigure(Element elt) {
        if (!elt.hasAttribute("view")) {
            E.error("not processing element (no view attribute) " + elt);
            return;
        }
        String sconf = elt.getAttribute("view");
        int ifr = -1;
        if (elt.hasAttribute("frame")) {
            ifr = Integer.parseInt(elt.getAttribute("frame"));
        }
        String sroot = String.valueOf(elt.getAttribute("path")) + elt.getAttribute("label");
        if (ifr >= 0) {
            sroot = String.valueOf(sroot) + "_" + ifr;
        }
        File fim = new File(this.fdestdir, String.valueOf(sroot) + ".png");
        File ftn = new File(this.fdestdir, String.valueOf(sroot) + "-tn.png");
        fim.getParentFile().mkdirs();
        if (!fim.exists() || !ftn.exists()) {
            File fconf = new File(this.fviewdir, String.valueOf(sconf) + ".xml");
            DataViewer dv = new DataViewer(fconf);
            DataviewController dvc = dv.getController();
            if (!fim.exists()) {
                dvc.saveImage(fim, ifr);
                E.info("written image " + fim);
            }
            if (!ftn.exists()) {
                dvc.saveThumbnailImage(ftn, ifr);
                E.info("written image " + ftn);
            }
            dvc.exit();
        }
    }

    public void makeMovie(Element elt) {
        if (!elt.hasAttribute("view")) {
            E.error("not processing element (no view attribute) " + elt);
            return;
        }
        String sconf = elt.getAttribute("view");
        String sroot = String.valueOf(elt.getAttribute("path")) + elt.getAttribute("label");
        File fmo = new File(this.fdestdir, String.valueOf(sroot) + ".gif");
        File ftn = new File(this.fdestdir, String.valueOf(sroot) + "-tn.gif");
        File fsubdest = fmo.getParentFile();
        fsubdest.mkdirs();
        if (!fmo.exists() || !ftn.exists()) {
            File fconf = new File(this.fviewdir, String.valueOf(sconf) + ".xml");
            DataViewer dv = new DataViewer(fconf);
            DataviewController dvc = dv.getController();
            this.copyFiles(fconf, fsubdest);
            if (!fmo.exists()) {
                dvc.makeMovie(fmo);
                E.info("written movie " + fmo);
            }
            if (!ftn.exists()) {
                dvc.makeThumbnailMovie(ftn);
                E.info("written movie " + ftn);
            }
            dvc.exit();
        }
    }

    private void copyFiles(File fconf, File fdd) {
        File fpar = fconf.getParentFile();
        String fnm = fconf.getName();
        String sr = fnm.substring(0, fnm.lastIndexOf("."));
        String sr1 = String.valueOf(sr) + "-cache.bnd";
        String sr2 = String.valueOf(sr) + ".sdj";
        FileUtil.copyFile(fconf, new File(fdd, fconf.getName()));
        FileUtil.copyFile(new File(fpar, sr1), new File(fdd, sr1));
        FileUtil.copyFile(new File(fpar, sr2), new File(fdd, sr2));
    }
}

