/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.catacomb.datalish.Box;
import org.catacomb.dataview.GraphMaker;
import org.catacomb.dataview.LinePlotElement;
import org.catacomb.dataview.PlotElement;
import org.catacomb.dataview.PointsPlotElement;
import org.catacomb.dataview.PolygonPlotElement;
import org.catacomb.dataview.RasterRowElement;
import org.catacomb.dataview.StringPlotElement;
import org.catacomb.graph.gui.PaintInstructor;
import org.catacomb.graph.gui.Painter;

public class Plot
implements PaintInstructor {
    Color bgColor;
    ArrayList<PlotElement> elements = new ArrayList();
    String xlabel;
    String ylabel;
    double xmin = Double.NaN;
    double xmax = Double.NaN;
    double ymin = Double.NaN;
    double ymax = Double.NaN;
    Box wkBox = new Box();

    public static void main(String[] argv) {
        Plot p = new Plot();
        double[] xdat = new double[]{0.1, 0.6, 3.2, 5.8};
        double[] ydat = new double[]{4.5, 3.0, 2.0, 5.0};
        p.setData(xdat, ydat);
        p.makeImage(300, 300, "tst.png");
    }

    public void addLine(double[] xpts, double[] ypts, Color c) {
        this.addLine(xpts, ypts, c, "");
    }

    public void addLine(double[][] xy, Color c) {
        int n = xy.length;
        double[] xpts = new double[n];
        double[] ypts = new double[n];
        int i = 0;
        while (i < n) {
            xpts[i] = xy[i][0];
            ypts[i] = xy[i][0];
            ++i;
        }
        this.addLine(xpts, ypts, c);
    }

    public void addPolygon(double[][] xy, Color c) {
        int n = xy.length;
        double[] xpts = new double[n + 1];
        double[] ypts = new double[n + 1];
        int i = 0;
        while (i < n) {
            xpts[i] = xy[i][0];
            ypts[i] = xy[i][1];
            ++i;
        }
        xpts[n] = xy[0][0];
        ypts[n] = xy[0][1];
        this.addLine(xpts, ypts, c);
    }

    public void addPolygon(double[] xpts, double[] ypts, Color c) {
        this.elements.add(new PolygonPlotElement(xpts, ypts, c));
    }

    public void addLine(double[] xpts, double[] ypts, Color c, String s) {
        this.elements.add(new LinePlotElement(xpts, ypts, c, s));
    }

    public void addPoints(double[] xpts, double[] ypts, Color c) {
        this.elements.add(new PointsPlotElement(xpts, ypts, c));
    }

    public void addSmallPoints(double[] xpts, double[] ypts, Color c) {
        this.elements.add(new PointsPlotElement(xpts, ypts, c, 1, 3));
    }

    public void addDots(double[] xpts, double[] ypts, Color c) {
        this.elements.add(new PointsPlotElement(xpts, ypts, c, 1, 1));
    }

    public void setData(double[] xp, double[] yp) {
        this.elements.add(new LinePlotElement(xp, yp));
    }

    public void setXRange(double xl, double xh) {
        this.xmin = xl;
        this.xmax = xh;
    }

    public void setYRange(double yl, double hy) {
        this.ymin = yl;
        this.ymax = hy;
    }

    public void setXLabel(String s) {
        this.xlabel = s;
    }

    public void setYLabel(String s) {
        this.ylabel = s;
    }

    public void makeImage(int w, int h, String fnm) {
        this.makeImage(w, h, new File(fnm));
    }

    public void makeImage(int w, int h, File fout) {
        double[] xyxy = new double[]{this.xmin, this.ymin, this.xmax, this.ymax};
        this.makeImage(w, h, xyxy, fout);
    }

    public void makeImage(int w, int h, double[] xyxy, File fout) {
        Box b = new Box();
        if (Double.isNaN(xyxy[0]) || Double.isNaN(xyxy[1]) || Double.isNaN(xyxy[2]) || Double.isNaN(xyxy[3])) {
            Box blim = this.getLimitBox();
            double dx = blim.getXmax() - blim.getXmin();
            double dy = blim.getYmax() - blim.getYmin();
            double f = 0.07;
            b.extendXTo(Double.isNaN(xyxy[0]) ? blim.getXmin() - f * dx : xyxy[0]);
            b.extendYTo(Double.isNaN(xyxy[1]) ? blim.getYmin() - f * dy : xyxy[1]);
            b.extendXTo(Double.isNaN(xyxy[2]) ? blim.getXmax() + f * dx : xyxy[2]);
            b.extendYTo(Double.isNaN(xyxy[3]) ? blim.getYmax() + f * dy : xyxy[3]);
        } else {
            b.extendTo(xyxy[0], xyxy[1]);
            b.extendTo(xyxy[2], xyxy[3]);
        }
        b.tidyLimits();
        this.makeImage(w, h, b, fout);
    }

    public void makeImage(int w, int h, Box b, File fout) {
        GraphMaker gm = new GraphMaker(w, h, this.bgColor);
        if (this.xlabel != null) {
            gm.setXAxisLabel(this.xlabel);
        }
        if (this.ylabel != null) {
            gm.setYAxisLabel(this.ylabel);
        }
        gm.setXRange(b.getXmin(), b.getXmax());
        gm.setYRange(b.getYmin(), b.getYmax());
        gm.drawData(this, fout);
    }

    @Override
    public boolean antialias() {
        return true;
    }

    @Override
    public Box getLimitBox() {
        Box b = new Box();
        for (PlotElement pe : this.elements) {
            pe.push(b);
        }
        return b;
    }

    public void autorange(boolean fixedAR) {
        Box b = this.getLimitBox();
        b.enlarge(0.1);
        if (fixedAR) {
            double dx = b.getXmax() - b.getXmin();
            double dy = b.getYmax() - b.getYmin();
            if (dy > dx) {
                double cx = 0.5 * (b.getXmin() + b.getXmax());
                this.setXRange(cx - dy / 2.0, cx + dy / 2.0);
                this.setYRange(b.getYmin(), b.getYmax());
            } else {
                double cy = 0.5 * (b.getYmin() + b.getYmax());
                this.setXRange(b.getXmin(), b.getXmax());
                this.setYRange(cy - dx / 2.0, cy + dx / 2.0);
            }
        } else {
            this.setXRange(b.getXmin(), b.getXmax());
            this.setYRange(b.getYmin(), b.getYmax());
        }
    }

    @Override
    public void instruct(Painter p) {
        for (PlotElement pe : this.elements) {
            pe.instruct(p);
        }
        int ileg = 0;
        for (PlotElement pe : this.elements) {
            String s = pe.getLabel();
            if (s == null || s.length() <= 0) continue;
            p.setColor(pe.getColor());
            p.paintLegend(ileg, s);
            ++ileg;
        }
    }

    public void addSortedLine(double[] xpts, double[] ypts, Color col) {
        int np = xpts.length;
        ArrayList<Double> xa = new ArrayList<Double>();
        HashMap<Double, Double> dhm = new HashMap<Double, Double>();
        int i = 0;
        while (i < xpts.length) {
            Double x = new Double(xpts[i]);
            Double y = new Double(ypts[i]);
            xa.add(x);
            dhm.put(x, y);
            ++i;
        }
        Collections.sort(xa);
        double[] xpa = new double[xpts.length];
        double[] ypa = new double[xpts.length];
        int i2 = 0;
        while (i2 < np) {
            Double d = (Double)xa.get(i2);
            xpa[i2] = d;
            ypa[i2] = (Double)dhm.get(d);
            ++i2;
        }
        this.addLine(xpa, ypa, col);
    }

    public void addString(double x, double y, String sc) {
        this.elements.add(new StringPlotElement(x, y, sc));
    }

    public void addString(double x, double y, Color c, String sc) {
        this.elements.add(new StringPlotElement(x, y, c, sc));
    }

    public void addArrowString(double x, double y, String sc) {
        this.elements.add(new StringPlotElement(x, y, Color.white, sc, 10, -10));
    }

    public void addArrowString(double x, double y, Color c, String sc) {
        this.elements.add(new StringPlotElement(x, y, c, sc, 10, -10));
    }

    public void addRasterRow(double[] times, double[] vs, double vmin, double vmax, double y, double thr) {
        this.elements.add(new RasterRowElement(times, vs, vmin, vmax, y, thr));
    }

    public void setBackgroundColor(Color bg) {
        this.bgColor = bg;
    }
}

