/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.formats;

import java.io.File;
import org.catacomb.datalish.Box;
import org.catacomb.dataview.display.ViewConfig;
import org.catacomb.dataview.formats.DataHandler;
import org.catacomb.dataview.formats.Mesh2plusTimeDisplay;
import org.catacomb.graph.gui.Painter;
import org.catacomb.report.E;
import org.catacomb.util.ArrayUtil;

public class MeshSummary
implements DataHandler {
    Mesh2plusTimeDisplay meshDH;
    double[] xdat;
    double[][] ydat;
    double ymin;
    double ymax;

    public MeshSummary(DataHandler dh) {
        this.meshDH = (Mesh2plusTimeDisplay)dh;
        this.xdat = this.meshDH.getFrameValues();
        String[] sa = dh.getPlotNames();
        E.info("setting plot " + sa[sa.length - 1]);
        this.setPlot(sa[sa.length - 1]);
    }

    @Override
    public int getContentStyle() {
        return 1;
    }

    @Override
    public double[] getFrameValues() {
        return null;
    }

    @Override
    public String getMagic() {
        return null;
    }

    @Override
    public double getMaxValue() {
        return 0.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public String[] getPlotNames() {
        return this.meshDH.getPlotNames();
    }

    @Override
    public String[] getViewOptions() {
        return null;
    }

    @Override
    public void read(File f) {
    }

    @Override
    public void setFrame(int ifr) {
    }

    @Override
    public void setPlot(String s) {
        this.ydat = new double[5][this.xdat.length];
        int i = 0;
        while (i < this.xdat.length) {
            double[] pdat = this.meshDH.getFrameData(s, i);
            this.ydat[0][i] = ArrayUtil.minD(pdat);
            this.ydat[1][i] = ArrayUtil.maxD(pdat);
            this.ydat[2][i] = ArrayUtil.avg(pdat);
            double sigma = ArrayUtil.sd(pdat);
            this.ydat[3][i] = this.ydat[2][i] - sigma;
            this.ydat[4][i] = this.ydat[2][i] + sigma;
            ++i;
        }
        this.ymin = ArrayUtil.min(this.ydat);
        this.ymax = ArrayUtil.max(this.ydat);
    }

    @Override
    public void setViewStyle(String s) {
    }

    @Override
    public boolean antialias() {
        return false;
    }

    @Override
    public Box getLimitBox() {
        Box b = new Box(this.xdat[0], this.ymin, this.xdat[this.xdat.length - 1], this.ymax);
        return b;
    }

    @Override
    public void instruct(Painter p) {
        if (this.ydat != null) {
            int nx = this.xdat.length;
            p.setColorRed();
            p.drawPolyline(this.xdat, this.ydat[0], nx);
            p.drawPolyline(this.xdat, this.ydat[1], nx);
            p.setColorWhite();
            p.drawPolyline(this.xdat, this.ydat[2], nx);
            p.setColorBlue();
            p.drawPolyline(this.xdat, this.ydat[3], nx);
            p.drawPolyline(this.xdat, this.ydat[4], nx);
        }
    }

    @Override
    public DataHandler getCoHandler() {
        return null;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    @Override
    public String getXAxisLabel() {
        return null;
    }

    @Override
    public String getYAxisLabel() {
        return null;
    }

    @Override
    public ViewConfig getViewConfig(String s) {
        return null;
    }

    @Override
    public void setZValue(double d) {
    }
}

