/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.formats;

import java.io.File;
import java.util.StringTokenizer;
import org.catacomb.datalish.Box;
import org.catacomb.dataview.display.ViewConfig;
import org.catacomb.dataview.formats.DataHandler;
import org.catacomb.graph.gui.Painter;
import org.catacomb.util.FileUtil;

public class SWCDisplay
implements DataHandler {
    Node[] nodes;
    static String[] viewOptions = new String[]{"lines", "boxes", "frame", "solid"};
    String viewStyle = "lines";

    @Override
    public String[] getViewOptions() {
        return viewOptions;
    }

    @Override
    public void setViewStyle(String s) {
        this.viewStyle = s;
    }

    @Override
    public String getMagic() {
        return "cctswc00";
    }

    @Override
    public void read(File f) {
        String s = FileUtil.readStringFromFile(f);
        StringTokenizer st = new StringTokenizer(s, "\n");
        int npx = st.countTokens();
        this.nodes = new Node[npx];
        while (st.hasMoreTokens()) {
            String sl = st.nextToken();
            StringTokenizer stl = new StringTokenizer(sl, " ");
            if (stl.countTokens() < 6) continue;
            int ip = this.nextInt(stl);
            double x = this.nextDouble(stl);
            double y = this.nextDouble(stl);
            double z = this.nextDouble(stl);
            double r = this.nextDouble(stl);
            int ipar = this.nextInt(stl);
            Node parent = null;
            if (ipar >= 0) {
                parent = this.nodes[ipar];
            }
            this.nodes[ip] = new Node(ip, x, y, z, r, parent);
        }
    }

    private int nextInt(StringTokenizer stl) {
        return Integer.parseInt(stl.nextToken());
    }

    private double nextDouble(StringTokenizer stl) {
        return Double.parseDouble(stl.nextToken());
    }

    @Override
    public boolean antialias() {
        return false;
    }

    @Override
    public void instruct(Painter p) {
        if (this.viewStyle.equals("lines")) {
            this.instructLines(p);
        } else if (this.viewStyle.equals("boxes")) {
            this.instructBoxes(p);
        } else if (this.viewStyle.equals("frame")) {
            this.instructFrame(p);
        } else if (this.viewStyle.equals("filled")) {
            this.instructFilled(p);
        }
    }

    private void instructLines(Painter p) {
        Node[] nodeArray = this.nodes;
        int n = this.nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node != null) {
                Node pn = node.parent;
                if (pn != null) {
                    p.setColorWhite();
                    p.drawLine(node.x, node.y, pn.x, pn.y);
                }
                p.fillIntCircle(node.x, node.y, 3);
            }
            ++n2;
        }
    }

    private void instructBoxes(Painter p) {
        Node[] nodeArray = this.nodes;
        int n = this.nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node pn;
            Node node = nodeArray[n2];
            if (node != null && (pn = node.parent) != null) {
                p.setColorWhite();
                p.drawCarrotSides(node.x, node.y, node.r, pn.x, pn.y, pn.r);
            }
            ++n2;
        }
    }

    private void instructFrame(Painter p) {
        Node[] nodeArray = this.nodes;
        int n = this.nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node != null) {
                Node pn = node.parent;
                if (pn != null) {
                    p.setColorWhite();
                    p.drawCarrotSides(node.x, node.y, node.r, pn.x, pn.y, pn.r);
                }
                p.drawCircle(node.x, node.y, node.r);
            }
            ++n2;
        }
    }

    private void instructFilled(Painter p) {
        Node[] nodeArray = this.nodes;
        int n = this.nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node != null) {
                Node pn = node.parent;
                if (pn != null) {
                    p.setColorWhite();
                    p.drawLine(node.x, node.y, pn.x, pn.y);
                }
                p.fillIntCircle(node.x, node.y, 3);
            }
            ++n2;
        }
    }

    @Override
    public Box getLimitBox() {
        return null;
    }

    @Override
    public String[] getPlotNames() {
        return null;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public double getMaxValue() {
        return 0.0;
    }

    @Override
    public double[] getFrameValues() {
        return null;
    }

    @Override
    public int getContentStyle() {
        return 1;
    }

    @Override
    public void setFrame(int ifr) {
    }

    @Override
    public void setPlot(String s) {
    }

    @Override
    public DataHandler getCoHandler() {
        return null;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    @Override
    public String getXAxisLabel() {
        return null;
    }

    @Override
    public String getYAxisLabel() {
        return null;
    }

    @Override
    public ViewConfig getViewConfig(String s) {
        return null;
    }

    @Override
    public void setZValue(double d) {
    }

    class Node {
        int index;
        Node parent;
        double x;
        double y;
        double z;
        double r;

        public Node(int i, double ax, double ay, double az, double ar, Node par) {
            this.index = i;
            this.x = ax;
            this.y = ay;
            this.z = az;
            this.r = ar;
            this.parent = par;
        }
    }
}

