/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.blocks;

import java.util.ArrayList;
import org.catacomb.datalish.SColor;
import org.catacomb.druid.blocks.Dialog;
import org.catacomb.druid.blocks.Frame;
import org.catacomb.druid.build.Context;
import org.catacomb.druid.build.GUIPath;
import org.catacomb.druid.build.Realizer;
import org.catacomb.druid.gui.base.DruEditorWindow;
import org.catacomb.druid.gui.base.DruFrame;
import org.catacomb.interlish.resource.Role;
import org.catacomb.interlish.structure.AddableTo;
import org.catacomb.report.E;

public class EditorWindow
implements Realizer,
AddableTo {
    public String name;
    public String title;
    public String id;
    public String controllerClass;
    public int background;
    public SColor backgroundColor;
    public String closeAction;
    public Frame frame;
    public ArrayList<Dialog> dialogs;

    @Override
    public void add(Object obj) {
        if (obj instanceof Frame) {
            this.frame = (Frame)obj;
        } else if (obj instanceof Dialog) {
            if (this.dialogs == null) {
                this.dialogs = new ArrayList();
            }
            this.dialogs.add((Dialog)obj);
        } else if (!(obj instanceof Role)) {
            E.error("cant add " + obj);
        }
    }

    @Override
    public Object realize(Context ctx, GUIPath gpathin) {
        GUIPath gpath = gpathin;
        gpath = gpath.extend(this.id);
        DruFrame druFrame = (DruFrame)this.frame.realize(ctx, gpath);
        if (this.closeAction != null) {
            if (this.closeAction.equals("hide")) {
                druFrame.setCloseActionHide();
            } else {
                E.warning("unrecognized close action : " + this.closeAction);
            }
        }
        if (this.name == null) {
            this.name = this.title;
        }
        druFrame.setTitle(this.name);
        DruEditorWindow druew = new DruEditorWindow();
        if (this.backgroundColor != null) {
            E.info("need to use bg color");
        }
        druew.setControllerPath(this.controllerClass);
        druew.setName(this.name);
        druew.setMainFrame(druFrame);
        ctx.addComponent(druew, gpath);
        if (this.dialogs != null) {
            for (Dialog d : this.dialogs) {
                d.realize(ctx, new GUIPath());
            }
        }
        return druew;
    }
}

