/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.base;

import org.catacomb.druid.event.StateListener;
import org.catacomb.druid.gui.base.DruPanel;
import org.catacomb.druid.gui.base.DruSubcontainerPanel;
import org.catacomb.interlish.interact.DComponent;
import org.catacomb.report.E;

public class DruPseudoCardPanel
extends DruSubcontainerPanel {
    static final long serialVersionUID = 1001L;
    int npanel;
    DruPanel[] panels = new DruPanel[10];
    String[] names = new String[10];
    int ipanel;
    int nlistener;
    StateListener[] listeners;

    public DruPseudoCardPanel() {
        this.setSingle();
        this.panels = new DruPanel[10];
        this.names = new String[10];
    }

    @Override
    public void subAddPanel(DruPanel drup) {
        this.setColors(drup);
        if (this.bgColor.getRed() == 240 && this.bgColor.getGreen() == 240) {
            E.info("got the 240 color...");
        }
        this.panels[this.npanel] = drup;
        this.names[this.npanel] = drup.getTitle();
        ++this.npanel;
        if (this.npanel == 1) {
            this.getGUIPeer().addDComponent(drup.getGUIPeer());
            this.ipanel = 0;
        }
    }

    @Override
    public void subAddDComponent(DComponent dcpt) {
        E.error("only accept DruPanels");
    }

    public boolean containsCard(String s) {
        return this.getCardIndex(s) >= 0;
    }

    private int getCardIndex(String s) {
        int ishow = -1;
        int i = 0;
        while (i < this.npanel) {
            if (s.equals(this.names[i])) {
                ishow = i;
            }
            ++i;
        }
        return ishow;
    }

    public void showCard(String s) {
        int ishow = this.getCardIndex(s);
        if (ishow == -1) {
            E.error(" - unknown card in pseudo card panel " + s);
        } else if (ishow != this.ipanel) {
            this.showIthCard(ishow);
        }
        this.revalidate();
    }

    private void notifyListeners(String stat) {
        int i = 0;
        while (i < this.nlistener) {
            this.listeners[i].stateChanged(stat);
            ++i;
        }
    }

    public void addStateListener(StateListener sl) {
        if (this.listeners == null) {
            this.listeners = new StateListener[4];
        }
        this.listeners[this.nlistener++] = sl;
    }

    public void nextCard() {
        this.ipanel = (this.ipanel + 1) % this.npanel;
        if (this.ipanel == this.npanel) {
            this.ipanel = 0;
        }
        this.showIthCard(this.ipanel);
    }

    private void showIthCard(int ip) {
        this.getGUIPeer().removeDComponent(this.panels[this.ipanel].getGUIPeer());
        this.ipanel = ip;
        this.getGUIPeer().addDComponent(this.panels[this.ipanel].getGUIPeer());
        this.notifyListeners(this.names[ip]);
        this.revalidate();
    }

    @Override
    public void subRemoveAll() {
        E.missing();
    }
}

