/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import java.awt.Color;
import java.util.ArrayList;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.gui.edit.DruGCPanel;
import org.catacomb.druid.gui.edit.Effect;
import org.catacomb.druid.swing.DBaseButton;
import org.catacomb.druid.swing.DButton;
import org.catacomb.icon.DImageIcon;
import org.catacomb.icon.IconLoader;
import org.catacomb.interlish.structure.Button;
import org.catacomb.interlish.structure.Suggestible;

public class DruButton
extends DruGCPanel
implements LabelActor,
Button,
Suggestible {
    static final long serialVersionUID = 1001L;
    String label;
    ArrayList<Effect> effects;
    DBaseButton button;

    public DruButton(String lab) {
        this(lab, null);
    }

    public DruButton(String lab, String ac) {
        this.label = lab;
        this.button = this.makeButton(this.label);
        this.setActionCommand(ac);
        this.setActionMethod(ac);
        this.addSingleDComponent(this.button);
        this.button.setLabelActor(this);
    }

    @Override
    public void suggest() {
        this.button.suggest();
    }

    public void deSuggest() {
        this.button.deSuggest();
    }

    @Override
    public String toString() {
        return "DruButton  " + this.label;
    }

    public DBaseButton getButton() {
        return this.button;
    }

    public void setRolloverPolicy(int inorm, int ihover) {
        this.button.setRolloverPolicy(inorm, ihover);
    }

    public DBaseButton makeButton(String sl) {
        return new DButton(sl);
    }

    @Override
    public void setBg(Color c) {
        this.button.setBg(c);
    }

    @Override
    public void setFg(Color c) {
        this.button.setFg(c);
    }

    public String getLabel() {
        return this.button.getText();
    }

    public void disable() {
        this.able(false);
    }

    public void enable() {
        this.able(true);
    }

    @Override
    public void able(boolean b) {
        this.button.setEnabled(b);
    }

    public void setBoldFont() {
        this.button.setBoldFont();
    }

    public void setImage(String iconName) {
        DImageIcon icon = IconLoader.createImageIcon(iconName);
        this.button.setIcon(icon);
    }

    public void setIconSource(String imgsrc) {
        this.button.setIconSource(imgsrc);
    }

    public void setLabelText(String s) {
        this.button.setLabelText(s);
    }

    @Override
    public void postApply() {
        this.button.setMouseActor(this);
    }

    public void setActionCommand(String s) {
        this.button.setActionCommand(s);
    }

    public void applyEffects(boolean b) {
        if (this.effects != null) {
            for (Effect eff : this.effects) {
                eff.apply(b);
            }
        }
    }

    @Override
    public void labelAction(String s, boolean b) {
        this.exportInfo();
        this.applyEffects(true);
        this.action();
    }

    public void addEffect(Effect eff) {
        if (this.effects == null) {
            this.effects = new ArrayList();
        }
        this.effects.add(eff);
    }

    public void setEffects(ArrayList<Effect> arl) {
        this.effects = arl;
    }

    public void setPadding(int padding) {
        this.button.setPadding(padding);
    }

    public void setPadding(int pl, int pr, int pt, int pb) {
        this.button.setPadding(pl, pr, pt, pb);
    }
}

