/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import java.awt.Color;
import org.catacomb.druid.event.TextActor;
import org.catacomb.druid.gui.edit.DruGCPanel;
import org.catacomb.druid.swing.DTextArea;
import org.catacomb.interlish.content.StringValue;
import org.catacomb.interlish.structure.Ablable;
import org.catacomb.interlish.structure.TextArea;
import org.catacomb.interlish.structure.Value;
import org.catacomb.interlish.structure.ValueWatcher;
import org.catacomb.report.E;

public class DruTextArea
extends DruGCPanel
implements TextActor,
Ablable,
TextArea,
ValueWatcher {
    static final long serialVersionUID = 1001L;
    DTextArea dTextArea;
    StringValue stringValue;

    public DruTextArea(String mn, int width, int height) {
        this.setActionMethod(mn);
        this.dTextArea = new DTextArea(width, height, 2);
        this.setSingle();
        this.addDComponent(this.dTextArea);
        this.dTextArea.setLineBorder(0xC0C0C0);
        this.dTextArea.setTextActor(this);
    }

    @Override
    public void valueChangedBy(Value pv, Object src) {
        if (src != this) {
            if (this.stringValue == pv) {
                if (this.stringValue == null) {
                    this.dTextArea.setText("");
                    this.dTextArea.setEnabled(false);
                } else {
                    this.dTextArea.setText(this.stringValue.getString());
                    if (src.equals("HIGHLIGHT")) {
                        this.dTextArea.highlightLine(this.stringValue.getHighlight());
                    } else {
                        this.dTextArea.clearHighlight();
                    }
                }
            } else {
                E.error("value changed by called with mismatched value");
            }
        }
    }

    @Override
    public void setStringValue(StringValue sv) {
        if (this.stringValue != null) {
            this.stringValue.removeValueWatcher(this);
        }
        this.stringValue = sv;
        if (this.stringValue == null) {
            this.dTextArea.setEnabled(false);
        } else {
            this.dTextArea.setText(this.stringValue.getString());
            this.stringValue.addValueWatcher(this);
        }
    }

    @Override
    public void textChanged(String s) {
        this.stringValue.reportableSetString(this.dTextArea.getText(), this);
    }

    @Override
    public void textEntered(String s) {
    }

    @Override
    public void textEdited(String s) {
    }

    @Override
    public void setBg(Color c) {
        this.dTextArea.setBg(c);
        super.setBg(c);
    }

    @Override
    public void able(boolean b) {
        this.dTextArea.setEnabled(b);
    }

    @Override
    public void setEditable(boolean b) {
        this.dTextArea.setEditable(b);
        this.dTextArea.setEnabled(b);
    }

    public void setAntialiased() {
        this.dTextArea.setAntialiased();
    }

    public void setPadding(int padding) {
        this.dTextArea.setPadding(padding);
    }

    public void setFontSize(int fs) {
        this.dTextArea.setFontSize(fs);
    }

    @Override
    public void focusGained() {
    }

    @Override
    public void focusLost() {
    }
}

