/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.load;

import java.io.File;
import java.net.URL;
import org.catacomb.be.FileSourcable;
import org.catacomb.druid.load.RoleMap;
import org.catacomb.druid.load.XMLStore;
import org.catacomb.druid.manifest.ClassRole;
import org.catacomb.druid.manifest.DecFile;
import org.catacomb.druid.manifest.DecManifest;
import org.catacomb.interlish.resource.ResourceRole;
import org.catacomb.interlish.resource.Role;
import org.catacomb.interlish.service.ContentLoader;
import org.catacomb.interlish.service.ResourceAccess;
import org.catacomb.interlish.structure.Factory;
import org.catacomb.interlish.structure.PathLocated;
import org.catacomb.interlish.structure.Resolvable;
import org.catacomb.interlish.structure.Transitional;
import org.catacomb.interlish.util.JUtil;
import org.catacomb.report.E;
import org.catacomb.serial.Deserializer;
import org.catacomb.util.FileUtil;
import org.catacomb.util.NetUtil;
import org.catacomb.util.PathUtil;

public class DruidContentLoader
implements ContentLoader {
    private XMLStore store;
    private RoleMap roleMap;
    Class rootClass;

    public static void initLoader(Object projroot) {
        DruidContentLoader loader = new DruidContentLoader();
        ResourceAccess.setContentLoader(loader);
        loader.init(projroot);
    }

    private DruidContentLoader() {
    }

    public static Object getFromURL(URL url) {
        String s = NetUtil.readStringFromURL(url);
        Object obj = Deserializer.deserialize(s);
        return obj;
    }

    public void init(Object projroot) {
        this.store = new XMLStore();
        this.roleMap = new RoleMap();
        String xtxt = JUtil.getRelativeResource("DecManifest.xml");
        DecManifest dm = (DecManifest)Deserializer.deserialize(xtxt);
        this.roleMap.addRoles(dm);
        this.store.addClasspathManifest(dm);
        if (projroot != null) {
            String atxt = JUtil.getRelativeResource(projroot, "DecManifest.xml");
            DecManifest adm = (DecManifest)Deserializer.deserialize(atxt);
            this.roleMap.addRoles(adm);
            this.store.addClasspathManifest(adm);
        }
    }

    public void addFileSystemManifest(DecManifest dm, File fdtop) {
        this.store.addFileSystemManifest(dm, fdtop);
    }

    public Object loadFromFileNoCache(File f) {
        String s = FileUtil.readStringFromFile(f);
        Object obj = Deserializer.deserialize(s);
        return obj;
    }

    @Override
    public Object getResource(String name, String selector) {
        DecFile decFile = this.getSource(name, selector);
        Object ret = null;
        if (decFile != null) {
            if (!decFile.hasCachedObject()) {
                this.loadToObject(decFile);
            }
            ret = decFile.getCachedObject();
        }
        return ret;
    }

    private void loadToObject(DecFile decFile) {
        if (decFile.hasCachedText()) {
            this.loadObject(decFile);
        } else {
            this.loadText(decFile);
            this.loadObject(decFile);
        }
    }

    private void loadObject(DecFile decFile) {
        E.cacheAction(decFile.getFullID());
        String ppath = PathUtil.parentPackage(decFile.getFullID());
        Object obj = this.readObject(decFile.getCachedText(), ppath);
        decFile.setCachedObject(obj);
        if (obj instanceof FileSourcable && decFile.inFileSystem()) {
            ((FileSourcable)obj).setSourceFile(decFile.getSourceFile());
        }
    }

    @Override
    public Object readObject(String txt) {
        return this.readObject(txt, null);
    }

    public Object readObject(String txt, String srcPath) {
        Object obj = Deserializer.deserialize(txt);
        if (obj instanceof PathLocated) {
            ((PathLocated)obj).setPathLocation(srcPath);
        }
        if (obj instanceof Transitional) {
            obj = ((Transitional)obj).getOutcome();
        }
        if (obj instanceof PathLocated) {
            ((PathLocated)obj).setPathLocation(srcPath);
        }
        if (obj instanceof Resolvable) {
            ((Resolvable)obj).resolve();
        }
        return obj;
    }

    private void loadText(DecFile df) {
        if (df.inClasspath()) {
            String stxt = JUtil.getXMLResource(df.getFullID());
            if (stxt != null) {
                df.setCachedText(stxt);
            } else {
                E.error("cant read " + df.getFullID() + " no such resource");
                df.setCachedText("");
            }
        } else if (df.inFileSystem()) {
            File fsrc = df.getSourceFile();
            String s = FileUtil.readStringFromFile(fsrc);
            if (s != null) {
                df.setCachedText(s);
            } else {
                E.error("cant read " + fsrc + " no such file");
                df.setCachedText("");
            }
        }
    }

    private DecFile getSource(String location, String selectorin) {
        DecFile decFile = null;
        String selector = selectorin;
        if (selector == null) {
            selector = " ";
        }
        if (this.store.containsSource(location)) {
            if (this.store.hasMultipleSources(location)) {
                int ibm = 1000;
                for (DecFile df : this.store.getSources(location)) {
                    String s;
                    int isel;
                    if (!df.hasCachedText()) {
                        this.loadText(df);
                    }
                    if ((isel = (s = df.getCachedText()).indexOf(selector)) < 0 || isel >= ibm) continue;
                    decFile = df;
                    ibm = isel;
                }
                if (decFile == null) {
                    E.error("there are multiple sources named " + location + " but the selector " + selector + " does not match text in any of them");
                }
            } else {
                decFile = this.store.getSource(location);
            }
        } else if (location.startsWith("file:")) {
            decFile = new DecFile(location);
            this.store.addSource(decFile);
        } else {
            E.error("XMLStore cant find " + location + " ");
        }
        return decFile;
    }

    @Override
    public boolean hasEditorOf(String s) {
        return this.hasRolePlayer("edits", s);
    }

    @Override
    public String getEditorPath(String s) {
        Role r = this.roleMap.getRole("edits", s);
        DecFile decFile = this.getSource(r.getResource(), null);
        return decFile.getFullID();
    }

    @Override
    public boolean hasFactoryFor(String s) {
        return this.hasRolePlayer("makes", s) || this.hasRolePlayer("domainof", s);
    }

    @Override
    public Factory getFactoryFor(String s) {
        Factory fac = null;
        fac = this.hasRolePlayer("makes", s) ? (Factory)this.getRolePlayer("makes", s) : (Factory)this.getRolePlayer("domainof", s);
        return fac;
    }

    public boolean hasRunMappingFor(String s) {
        return this.hasRolePlayer("runmaps", s);
    }

    public Object getRunMappingFor(String s) {
        return this.getRolePlayer("runmaps", s);
    }

    @Override
    public boolean hasProviderOf(String s) {
        return this.hasRolePlayer("provides", s);
    }

    @Override
    public Object getProviderOf(String s) {
        return this.getNewRolePlayer("provides", s);
    }

    @Override
    public boolean hasExposerOf(String s) {
        return this.hasRolePlayer("exposes", s);
    }

    @Override
    public Object getExposerOf(String s) {
        return this.getRolePlayer("exposes", s);
    }

    @Override
    public boolean hasTablizerOf(String s) {
        return this.hasRolePlayer("tablizes", s);
    }

    @Override
    public Object getTablizerOf(String s) {
        return this.getRolePlayer("tablizes", s);
    }

    private boolean hasRolePlayer(String role, String subject) {
        return this.roleMap.hasRole(role, subject);
    }

    private Object getRolePlayer(String role, String subject) {
        return this.getRolePlayer(role, subject, true);
    }

    private Object getNewRolePlayer(String role, String subject) {
        return this.getRolePlayer(role, subject, false);
    }

    private Object getRolePlayer(String role, String subject, boolean cacheOK) {
        Object ret = null;
        Role r = this.roleMap.getRole(role, subject);
        if (r.hasCachedPlayer() && cacheOK) {
            ret = r.getCachedPlayer();
        } else if (r instanceof ClassRole) {
            ret = this.readClassRole((ClassRole)r);
        } else if (r instanceof ResourceRole) {
            ret = this.readResourceRole((ResourceRole)r);
        }
        r.cachePlayer(ret);
        return ret;
    }

    private Object readClassRole(ClassRole cr) {
        String cnm = cr.getResource();
        return JUtil.newInstance(cnm);
    }

    private Object readResourceRole(ResourceRole rr) {
        String resnm = rr.getResource();
        Object ret = this.getResource(resnm, "ole");
        return ret;
    }

    @Override
    public void newSourceFile(File f, File rootFolder) {
        this.store.newSourceFile(f, rootFolder);
    }
}

