/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.manifest;

import java.io.File;
import org.catacomb.report.E;
import org.catacomb.util.FileUtil;

public class DecFile {
    public String directory;
    public String name;
    public String extension;
    public static final int CLASSPATH = 0;
    public static final int FILE_SYSTEM = 1;
    private int p_accessMethod;
    private File p_rootFolder;
    private String p_fullID;
    private String p_cachedText;
    private Object p_cachedObject;

    public DecFile() {
    }

    public DecFile(String psf, String nm) {
        this.directory = psf;
        this.name = nm;
        this.cutName();
    }

    public DecFile(File f, File rtFolder) {
        this.p_accessMethod = 1;
        this.p_rootFolder = rtFolder;
        this.name = f.getName();
        this.directory = FileUtil.getRelativeDirectory(f, rtFolder);
        this.cutName();
    }

    public DecFile(String fullPath) {
        if (fullPath.startsWith("file:")) {
            String sp = fullPath.substring(5, fullPath.length());
            File f = new File(sp);
            this.directory = f.getParentFile().getAbsolutePath();
            this.name = f.getName();
            this.cutName();
            this.setFileSystemAccess(new File("/"), "");
        } else {
            E.missing();
        }
    }

    public String toString() {
        return "decFile dir=" + this.directory + " name=" + this.name + " ext=" + this.extension + " access=" + this.p_accessMethod;
    }

    private void cutName() {
        if (this.name.endsWith(".xml")) {
            this.name = this.name.substring(0, this.name.length() - 4);
            this.extension = "xml";
        } else {
            this.extension = "";
            E.error(" - DecFile in DecManifest only handles extension .xml  so far");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFullID() {
        if (this.p_fullID == null) {
            this.p_fullID = this.makeFullID();
        }
        return this.p_fullID;
    }

    private String makeFullID() {
        if (this.directory == null) {
            this.directory = "";
            E.error("null directory in DecFile");
        }
        String sret = null;
        sret = this.directory.length() > 0 ? (this.directory.endsWith("/") ? String.valueOf(this.directory) + this.name : String.valueOf(this.directory) + "/" + this.name) : this.name;
        sret = sret.replaceAll("/", ".");
        return sret;
    }

    public void setFileSystemAccess(File fdir, String cproot) {
        this.directory = String.valueOf(cproot) + this.directory;
        this.p_accessMethod = 1;
        this.p_rootFolder = fdir;
    }

    public void setClasspathAccess() {
        this.p_accessMethod = 0;
    }

    public boolean inClasspath() {
        return this.p_accessMethod == 0;
    }

    public boolean inFileSystem() {
        return this.p_accessMethod == 1;
    }

    public void setCachedObject(Object obj) {
        this.p_cachedObject = obj;
    }

    public boolean hasCachedObject() {
        return this.p_cachedObject != null;
    }

    public Object getCachedObject() {
        return this.p_cachedObject;
    }

    public void setCachedText(String s) {
        this.p_cachedText = s;
    }

    public boolean hasCachedText() {
        return this.p_cachedText != null;
    }

    public String getCachedText() {
        return this.p_cachedText;
    }

    public void clearObjectCache() {
        this.p_cachedObject = null;
    }

    public void clearTextCache() {
        this.p_cachedText = null;
    }

    public File getSourceFile() {
        String fnm = String.valueOf(this.name) + "." + this.extension;
        File fdir = null;
        fdir = this.p_rootFolder != null ? new File(this.p_rootFolder, this.directory) : new File(this.directory);
        return new File(fdir, fnm);
    }

    public String getPath() {
        String sd = this.directory;
        sd = sd == null || sd.length() == 0 ? "" : String.valueOf(this.directory) + "/'";
        return String.valueOf(sd) + this.name + "." + this.extension;
    }
}

