/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.catacomb.util.ColorUtil;

public class BorderUtil {
    public static final int NONE = 0;
    public static final int ETCHED_DOWN = 1;
    public static final int ETCHED_UP = 2;
    public static final int RAISED = 2;
    public static final int CURRENT = 3;

    public static Border makeEtchedBorder(Color c) {
        return BorderUtil.makeBorder(1, c);
    }

    public static Border makeEtchedUpBorder(Color c) {
        return BorderUtil.makeBorder(2, c);
    }

    public static Border makeEmptyBorder(int p) {
        return BorderFactory.createEmptyBorder(p, p, p, p);
    }

    public static Border makeEmptyBorder(int pleft, int pright, int ptop, int pbot) {
        return BorderFactory.createEmptyBorder(ptop, pleft, pbot, pright);
    }

    public static Border makeSunkenBorder(Color cb, Color co) {
        Color cbr = ColorUtil.brighter(co);
        Color cdk = ColorUtil.darker(cb);
        Color cdk2 = ColorUtil.darker(cdk);
        return BorderFactory.createBevelBorder(1, cbr, cb, cdk2, cdk);
    }

    public static Border makeRaisedBorder(Color cb, Color co) {
        Color cbr = ColorUtil.brighter(co);
        Color cdk = ColorUtil.darker(cb);
        Color cdk2 = ColorUtil.darker(cdk);
        return BorderFactory.createBevelBorder(0, cbr, cb, cdk2, cdk);
    }

    public static Border makeSlightlySunkenBorder(Color col) {
        Color cbr = ColorUtil.slightlyBrighter(col);
        Color cdk = ColorUtil.slightlyDarker(col);
        return BorderFactory.createBevelBorder(1, col, cbr, cdk, col);
    }

    public static Border makeBorder(int type, Color c) {
        Color cbr = ColorUtil.brighter(c);
        Color cdk = ColorUtil.darker(c);
        Border ret = null;
        ret = type == 1 ? BorderFactory.createEtchedBorder(cbr, cdk) : (type == 2 ? BorderFactory.createEtchedBorder(cdk, cbr) : BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return ret;
    }

    public static Border makeCompoundBorder(Border bin, Border bout) {
        return BorderFactory.createCompoundBorder(bout, bin);
    }

    public static Border makeZeroBorder() {
        return BorderUtil.makeEmptyBorder(0);
    }
}

