/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.catacomb.druid.swing.ToggleItem;
import org.catacomb.interlish.structure.Colored;
import org.catacomb.interlish.structure.Named;

public class CheckListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 1L;
    private JCheckBox checkBox;
    private JLabel label;
    Color csel = new Color(214, 214, 204);
    JPanel colorPanel;

    public CheckListCellRenderer(ListCellRenderer renderer) {
        this.setLayout(new BorderLayout(2, 2));
        this.setOpaque(true);
        this.checkBox = new JCheckBox();
        this.checkBox.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.label = new JLabel("");
        this.label.setFont(new Font("sansserif", 0, 12));
        this.add("West", this.checkBox);
        this.add("Center", this.label);
        this.colorPanel = new JPanel();
        this.colorPanel.setPreferredSize(new Dimension(12, 12));
        this.colorPanel.setMinimumSize(new Dimension(12, 12));
        this.colorPanel.setMaximumSize(new Dimension(12, 12));
        Color borderC = new Color(0xA0A0A0);
        this.colorPanel.setBorder(BorderFactory.createLineBorder(borderC));
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(1, 1, 4, 4));
        jp.add(this.colorPanel);
        jp.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add("East", jp);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color c;
        ToggleItem ti = (ToggleItem)value;
        this.checkBox.setSelected(ti.isOn());
        Object refobj = ti.getRef();
        if (refobj instanceof Named) {
            this.label.setText(((Named)refobj).getName());
        } else {
            this.label.setText(ti.getRef().toString());
        }
        Color cbg = isSelected ? this.csel : list.getBackground();
        this.setBackground(cbg);
        if (value instanceof Colored && (c = ((Colored)value).getColor()) != null) {
            this.colorPanel.setBackground(c);
        }
        return this;
    }
}

