/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.xtext.base.TextFloat;
import org.catacomb.druid.xtext.canvas.FontStore;
import org.catacomb.interlish.content.IntPosition;
import org.catacomb.report.E;

public class DDropCanvas
extends JPanel
implements MouseListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    BasicStroke bs1 = new BasicStroke(1.0f);
    Color bgColor = new Color(248, 248, 248);
    Color liveBgColor = new Color(200, 255, 200);
    boolean antialias;
    int width;
    int height;
    int dragOffX;
    int dragOffY;
    FontStore fontStore;
    TextFloat dragOnFloat;
    LabelActor labelActor;
    IntPosition dragCorner;
    String text;
    int caretPos;
    int keyCode;
    Object dropee;

    public DDropCanvas() {
        this.setFont(new Font("sansserif", 0, 12));
        this.fontStore = FontStore.instance();
        this.dragCorner = new IntPosition();
        this.text = "";
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.dropee = null;
    }

    public void setLabelActor(LabelActor la) {
        this.labelActor = la;
    }

    @Override
    public void paintComponent(Graphics g0) {
        if (this.isActive()) {
            g0.setColor(this.liveBgColor);
        } else {
            g0.setColor(this.bgColor);
        }
        g0.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g = (Graphics2D)g0;
        if (this.antialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.simpleStroke(g);
        this.paintText(g);
    }

    final void simpleStroke(Graphics2D g) {
        g.setStroke(this.bs1);
    }

    public void requestRepaint() {
        this.repaint();
    }

    public void paintText(Graphics2D g) {
        this.width = this.getWidth();
        this.height = this.getHeight();
        g.setColor(Color.black);
        if (this.dragOnFloat != null) {
            this.paintFloat(g, this.dragOnFloat);
        }
        if (this.caretPos > this.text.length()) {
            this.caretPos = this.text.length();
        }
        g.setColor(Color.black);
        g.drawString(this.text, 6, 18);
        int xo = 6 + g.getFontMetrics().stringWidth(this.text.substring(0, this.caretPos));
        g.drawLine(xo, 6, xo, 20);
    }

    private void paintFloat(Graphics2D g, TextFloat b) {
        String txt = b.getText();
        int x = b.getX();
        int y = b.getY();
        int w = b.getWidth();
        if (w < 0) {
            w = this.fontStore.stringWidth(g, txt);
            b.setWidth(w);
        }
        g.setColor(Color.black);
        g.drawString(txt, x, y);
    }

    public IntPosition getScreenPosition() {
        Point p = this.getLocationOnScreen();
        IntPosition ret = new IntPosition((int)p.getX(), (int)p.getY());
        return ret;
    }

    public void setSourceOffset(int x, int y) {
        this.dragOffX = x;
        this.dragOffY = y;
    }

    public void newTextDrag(String txt, IntPosition pos, Object src) {
        this.dragOnFloat = new TextFloat(txt, pos, src);
        this.repaint();
    }

    public void moveDrag(IntPosition pos) {
        this.dragOnFloat.setPosition(pos);
        this.repaint();
    }

    private boolean isActive() {
        boolean ret = false;
        if (this.dragOnFloat != null) {
            int xc = this.dragOnFloat.getX();
            int yc = this.dragOnFloat.getY();
            if (xc > 0 && xc < this.width - 10 && yc > 0 && yc < this.height) {
                ret = true;
            }
        }
        return ret;
    }

    public void drop() {
        if (this.isActive()) {
            this.setText(this.dragOnFloat.getText());
            this.dropee = this.dragOnFloat.getSource();
            this.dragOnFloat = null;
            this.reportAction();
        }
    }

    private void reportAction() {
        if (this.labelActor != null) {
            this.labelActor.labelAction(this.getText(), true);
        }
    }

    public void clear() {
        this.dragOnFloat = null;
        this.setText("");
        this.dropee = null;
        this.repaint();
    }

    public void setText(String s) {
        this.text = s;
        this.caretPos = 0;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.isActionKey()) {
            E.info("action key " + KeyEvent.getKeyText(this.keyCode));
        } else {
            char c = e.getKeyChar();
            String sc = "" + c;
            if (Character.isLetter(c) || " -_".indexOf(sc) >= 0) {
                this.text = String.valueOf(this.text.substring(0, this.caretPos)) + sc + this.text.substring(this.caretPos, this.text.length());
                ++this.caretPos;
                this.dropee = null;
                this.repaint();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyCode = e.getKeyCode();
        switch (this.keyCode) {
            case 37: {
                if (this.caretPos <= 0) break;
                --this.caretPos;
                this.repaint();
                break;
            }
            case 39: {
                if (this.caretPos >= this.text.length()) break;
                ++this.caretPos;
                this.repaint();
                break;
            }
            case 8: {
                if (this.caretPos <= 0) break;
                this.text = String.valueOf(this.text.substring(0, this.caretPos - 1)) + this.text.substring(this.caretPos, this.text.length());
                --this.caretPos;
                this.dropee = null;
                this.repaint();
                break;
            }
            case 10: {
                this.reportAction();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public Object getDropee() {
        return this.dropee;
    }
}

