/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.swing.DPanel;
import org.catacomb.report.E;

public class DRadioButtons
extends DPanel
implements ActionListener {
    static final long serialVersionUID = 1001L;
    LabelActor lact;
    String selected;
    String[] options;
    String[] labels;
    JRadioButton[] buttons;
    Font labelFont;
    CardLayout cardLayout;
    boolean vertical = true;
    Color bgColor;

    public DRadioButtons(String[] opts, String layout) {
        if (layout == null || layout.equals("vertical")) {
            this.vertical = true;
        } else if (layout.equals("horizontal")) {
            this.vertical = false;
        } else {
            E.warning("unknown layout: " + layout);
            this.vertical = false;
        }
        this.labelFont = new Font("sansserif", 0, 12);
        this.setOptions(opts, opts);
    }

    @Override
    public void setBg(Color c) {
        this.bgColor = c;
        super.setBg(c);
        JRadioButton[] jRadioButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            JRadioButton jrb = jRadioButtonArray[n2];
            jrb.setBackground(c);
            ++n2;
        }
    }

    @Override
    public void setTooltip(String s) {
        this.setToolTipText(s);
    }

    public void setOptions(String[] optsin, String[] labsin) {
        this.removeAll();
        String[] opts = optsin;
        String[] labs = labsin;
        if (opts == null) {
            opts = new String[]{};
        }
        this.options = opts;
        this.labels = labs;
        int nopt = opts.length;
        if (this.vertical) {
            this.setLayout(new GridLayout(nopt, 1, 2, 2));
        } else {
            this.setLayout(new FlowLayout(0, 5, 2));
        }
        ButtonGroup bgp = new ButtonGroup();
        this.buttons = new JRadioButton[nopt];
        int i = 0;
        while (i < nopt) {
            JRadioButton jrb = new JRadioButton(this.labels[i]);
            jrb.setActionCommand(this.options[i]);
            jrb.setFont(this.labelFont);
            bgp.add(jrb);
            this.buttons[i] = jrb;
            jrb.addActionListener(this);
            this.add(jrb);
            if (this.bgColor != null) {
                jrb.setBackground(this.bgColor);
            }
            ++i;
        }
        this.revalidate();
    }

    public void setSelectedIndex(int isel) {
        int i = 0;
        while (i < this.buttons.length) {
            if (isel != i && this.buttons[i].isSelected()) {
                this.buttons[i].setSelected(false);
            } else if (isel == i && !this.buttons[i].isSelected()) {
                this.buttons[i].setSelected(true);
            }
            ++i;
        }
    }

    public void setSelected(String s) {
        if (s == null) {
            int i = 0;
            while (i < this.options.length) {
                if (this.buttons[i].isSelected()) {
                    this.buttons[i].setSelected(false);
                }
                ++i;
            }
        } else {
            boolean done = false;
            int i = 0;
            while (i < this.options.length) {
                if (this.options[i].equals(s)) {
                    this.selected = s;
                    if (!this.buttons[i].isSelected()) {
                        this.buttons[i].setSelected(true);
                    }
                    done = true;
                }
                ++i;
            }
            if (!done) {
                StringBuffer sb = new StringBuffer();
                int i2 = 0;
                while (i2 < this.options.length) {
                    sb.append(String.valueOf(this.options[i2]) + ", ");
                    ++i2;
                }
                E.error("cant set selected  - not an option " + s + " possibilities are: " + sb.toString());
            }
        }
    }

    public String getSelected() {
        return this.selected;
    }

    @Override
    public void actionPerformed(ActionEvent aev) {
        this.selected = aev.getActionCommand();
        this.deliverAction(this.selected, true);
    }

    public void setLabelActor(LabelActor bl) {
        this.lact = bl;
    }

    public void deliverAction(String s, boolean b) {
        if (this.lact != null) {
            this.lact.labelAction(s, b);
        }
    }
}

