/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.event.TextActor;
import org.catacomb.druid.swing.BorderUtil;
import org.catacomb.druid.swing.DPanel;
import org.catacomb.interlish.interact.DComponent;

public class DTextField
extends DPanel
implements DComponent,
DocumentListener,
KeyListener,
FocusListener {
    static final long serialVersionUID = 1001L;
    LabelActor labelActor;
    TextActor textActor;
    String tag;
    boolean ignoreEvents = false;
    JTextField jTextField;
    boolean returnEvents;
    boolean reportFocus = false;
    boolean changedWhileFocused;

    public DTextField(String sid, int w) {
        this.tag = sid;
        this.jTextField = new JTextField(w);
        this.jTextField.setBorder(BorderUtil.makeEmptyBorder(2));
        this.setSingle();
        this.add(this.jTextField);
        this.jTextField.getDocument().addDocumentListener(this);
        this.returnEvents = false;
        this.jTextField.addFocusListener(this);
    }

    public void enableReturnEvents() {
        if (!this.returnEvents) {
            this.returnEvents = true;
            this.jTextField.addKeyListener(this);
        }
    }

    public void enableFocusEvents() {
        this.reportFocus = true;
    }

    protected JTextField getJTextField() {
        return this.jTextField;
    }

    public String getTag() {
        return this.tag;
    }

    public void setText(String s) {
        this.ignoreEvents = true;
        this.jTextField.setText(s);
        this.ignoreEvents = false;
    }

    public void setEditable(boolean b) {
        this.jTextField.setEditable(b);
    }

    @Override
    public void setEnabled(boolean b) {
        this.jTextField.setEnabled(b);
        if (b) {
            this.jTextField.setBackground(Color.white);
        } else {
            this.jTextField.setBackground(new Color(236, 236, 236));
        }
    }

    public void setLabelActor(LabelActor bl) {
        this.labelActor = bl;
    }

    public void setTextActor(TextActor tl) {
        this.textActor = tl;
    }

    @Override
    public void changedUpdate(DocumentEvent d) {
        this.flagChange();
    }

    @Override
    public void insertUpdate(DocumentEvent d) {
        this.flagChange();
    }

    @Override
    public void removeUpdate(DocumentEvent d) {
        this.flagChange();
    }

    public void flagChange() {
        if (!this.ignoreEvents) {
            this.changedWhileFocused = true;
            if (this.textActor != null) {
                this.textActor.textChanged(this.getText());
            }
        }
    }

    public String getText() {
        return this.jTextField.getText();
    }

    protected void reportAction() {
        if (this.labelActor != null) {
            this.labelActor.labelAction(this.getText(), true);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            if (this.labelActor != null) {
                this.labelActor.labelAction("return_pressed", true);
            }
            if (this.textActor != null) {
                this.textActor.textEntered(this.getText());
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void setLineBorder(int icol) {
        this.setBorder(BorderFactory.createLineBorder(new Color(icol)));
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.changedWhileFocused = false;
        if (this.reportFocus) {
            this.textActor.focusGained();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.changedWhileFocused && !this.ignoreEvents && this.textActor != null) {
            this.textActor.textEdited(this.getText());
        }
        if (this.reportFocus) {
            this.textActor.focusLost();
        }
    }
}

