/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import org.catacomb.interlish.content.ColorTable;

public class GradientPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    ColorTable colorTable;

    public GradientPanel(int w, int h) {
        this.setPreferredSize(new Dimension(w, h));
        this.setMinimumSize(new Dimension(w, h));
        this.setMaximumSize(new Dimension(w, h));
    }

    public void setColorTable(ColorTable ct) {
        this.colorTable = ct;
    }

    @Override
    public void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.colorTable == null) {
            g.setColor(Color.gray);
            g.fillRect(0, 0, w, h);
        } else {
            int i = 0;
            while (i < w) {
                double f = 1.0 * (double)i / (double)(w - 1);
                g.setColor(this.colorTable.getFractionalColor(f));
                g.drawLine(i, 0, i, h);
                ++i;
            }
        }
    }
}

