/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing.dnd;

import org.catacomb.interlish.structure.TextDisplayed;

public class Region {
    public static final int DRAG = 1;
    public static final int DROP = 2;
    public static final int DRAG_OR_DROP = 3;
    public static final int CLICK = 0;
    int p_x;
    int p_y;
    int p_w;
    int p_h;
    String p_tag;
    Object p_ref;
    int p_action;

    public Region(int x, int y, int w, int h, String string, Object object, int a) {
        this.p_x = x;
        this.p_y = y;
        this.p_w = w;
        this.p_h = h;
        this.p_action = a;
    }

    public Region(int[] xxyy, String s, Object o, int a) {
        this.p_x = xxyy[0];
        this.p_y = xxyy[2];
        this.p_w = xxyy[1] - xxyy[0];
        this.p_h = xxyy[3] - xxyy[2];
        this.p_tag = s;
        this.p_ref = o;
        this.p_action = a;
    }

    public String toString() {
        return "regoin (" + this.p_tag + ", " + this.p_ref + ", " + this.p_action + ")";
    }

    public String getTag() {
        return this.p_tag;
    }

    public Object getRef() {
        return this.p_ref;
    }

    public boolean equals(Region r) {
        return r.p_x == this.p_x && r.p_y == this.p_y && r.p_w == this.p_w && r.p_h == this.p_h;
    }

    public int getX() {
        return this.p_x;
    }

    public int getY() {
        return this.p_y;
    }

    public int getW() {
        return this.p_w;
    }

    public int getH() {
        return this.p_h;
    }

    public boolean contains(int x, int y) {
        return x > this.p_x && x < this.p_x + this.p_w && y > this.p_y && y < this.p_y + this.p_h;
    }

    public boolean acceptsDrops() {
        return this.p_action == 2 || this.p_action == 3;
    }

    public String getText() {
        String sret = "-missing-";
        if (this.p_ref instanceof TextDisplayed) {
            sret = ((TextDisplayed)this.p_ref).getDisplayText();
        } else if (this.p_ref != null) {
            sret = this.p_ref.toString();
        }
        return sret;
    }

    public static boolean canPress(int i) {
        return i == 1 || i == 3 || i == 0;
    }

    public boolean draggable() {
        return this.p_action == 1 || this.p_action == 3;
    }

    public boolean clickable() {
        return this.p_action == 0;
    }
}

