/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing.dnd;

import org.catacomb.druid.swing.dnd.Region;

public class RegionStore {
    int[][] regs = new int[20][4];
    Object[] refs = new Object[20];
    String[] tags = new String[20];
    int[] actions = new int[20];
    int nreg;
    Object active;
    int[] activeLims;
    String activeTag;
    Region dragOverRegion;
    Region hoverOverRegion;
    Region pressRegion;

    public void clear() {
        this.nreg = 0;
    }

    public void addRegion(int[] xywh, Object obj, String s, int acts) {
        this.addRegion(xywh[0], xywh[1], xywh[2], xywh[3], obj, s, acts);
    }

    public void addLengthenedRegion(int[] xywh, Object obj) {
        this.addRegion(xywh[0] - 6, xywh[1], xywh[2] + 12, xywh[3], obj, null, 0);
    }

    public void addRegion(int x, int y, int w, int h, Object obj, String flav, int acts) {
        if (this.nreg == this.regs.length) {
            int nn = 3 * this.nreg / 2;
            int[][] newregs = new int[nn][4];
            Object[] newrefs = new Object[nn];
            String[] newtags = new String[nn];
            int[] newactions = new int[nn];
            int i = 0;
            while (i < this.nreg) {
                int j = 0;
                while (j < 4) {
                    newregs[i][j] = this.regs[i][j];
                    ++j;
                }
                newrefs[i] = this.refs[i];
                newtags[i] = this.tags[i];
                newactions[i] = this.actions[i];
                ++i;
            }
            this.regs = newregs;
            this.refs = newrefs;
            this.tags = newtags;
            this.actions = newactions;
        }
        this.regs[this.nreg][0] = x;
        this.regs[this.nreg][1] = x + w;
        this.regs[this.nreg][2] = y - h;
        this.regs[this.nreg][3] = y;
        this.refs[this.nreg] = obj;
        this.tags[this.nreg] = flav;
        this.actions[this.nreg] = acts;
        ++this.nreg;
    }

    public Object activeRegion(int x, int y) {
        if (this.active == null || !this.within(x, y, this.activeLims)) {
            this.active = null;
            int i = 0;
            while (i < this.nreg) {
                if (this.within(x, y, this.regs[i])) {
                    this.active = this.refs[i];
                    this.activeLims = this.regs[i];
                    this.activeTag = this.tags[i];
                    break;
                }
                ++i;
            }
        }
        return this.active;
    }

    public int[] getActiveLimits() {
        return this.activeLims;
    }

    public String getActiveTag() {
        return this.activeTag;
    }

    private final boolean within(int x, int y, int[] rr) {
        return x > rr[0] && x < rr[1] && y > rr[2] && y < rr[3];
    }

    public Object getActive() {
        return this.active;
    }

    public boolean hasActive() {
        return this.active != null;
    }

    public void clearActive() {
        this.active = null;
    }

    public void dragOver(int x, int y) {
        if (this.dragOverRegion == null || !this.dragOverRegion.contains(x, y)) {
            this.dragOverRegion = null;
            int i = 0;
            while (i < this.nreg) {
                if (this.within(x, y, this.regs[i])) {
                    this.dragOverRegion = new Region(this.regs[i], this.tags[i], this.refs[i], this.actions[i]);
                    break;
                }
                ++i;
            }
        }
    }

    public Region getDragOverRegion() {
        return this.dragOverRegion;
    }

    public void hoverOver(int x, int y) {
        if (this.hoverOverRegion == null || !this.hoverOverRegion.contains(x, y)) {
            this.hoverOverRegion = null;
            int i = 0;
            while (i < this.nreg) {
                if (this.within(x, y, this.regs[i]) && Region.canPress(this.actions[i])) {
                    this.hoverOverRegion = new Region(this.regs[i], this.tags[i], this.refs[i], this.actions[i]);
                    break;
                }
                ++i;
            }
        }
    }

    public Region getHoverRegion() {
        return this.hoverOverRegion;
    }

    public void press(int x, int y) {
        this.pressRegion = null;
        int i = 0;
        while (i < this.nreg) {
            if (this.within(x, y, this.regs[i])) {
                this.pressRegion = new Region(this.regs[i], this.tags[i], this.refs[i], this.actions[i]);
                break;
            }
            ++i;
        }
    }

    public Region getPressRegion() {
        return this.pressRegion;
    }
}

