/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing.dnd;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import javax.swing.JTextField;
import org.catacomb.druid.swing.DDropTextField;
import org.catacomb.druid.swing.ImageDragSource;
import org.catacomb.druid.swing.dnd.DragAndDrop;
import org.catacomb.report.E;

public class TextFieldDropTarget
implements DropTargetListener {
    DropTarget target;
    DDropTextField ddtField;
    JTextField jtField;
    Rectangle dragBounds;

    public TextFieldDropTarget(JTextField jtf, DDropTextField ddtf) {
        this.jtField = jtf;
        this.ddtField = ddtf;
        this.target = new DropTarget(jtf, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(dtde.getDropAction());
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.dragBounds != null) {
            this.jtField.paintImmediately(this.dragBounds);
        } else {
            this.dragBounds = new Rectangle();
        }
        Point p = dtde.getLocation();
        DragAndDrop obj = DragAndDrop.getDnD();
        if (obj instanceof ImageDragSource) {
            ImageDragSource ids = obj;
            BufferedImage bim = ids.getDragImage();
            Point poff = ids.getDragImageOffset();
            int bw = bim.getWidth();
            int bh = bim.getHeight();
            if (bim == null) {
                // empty if block
            }
            this.dragBounds.setRect(p.x - poff.x, p.y - poff.y, bw, bh);
            Graphics g = this.jtField.getGraphics();
            g.drawImage(bim, (int)this.dragBounds.getX(), (int)this.dragBounds.getY(), null);
        } else {
            E.warning("wrong type of source " + obj);
        }
        dtde.acceptDrag(dtde.getDropAction());
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (this.dragBounds != null) {
            this.jtField.paintImmediately(this.dragBounds);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Object obj = DragAndDrop.getDnD().getDragSource();
        this.ddtField.setDropee(obj);
    }
}

