/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.util.examples;

import java.util.ArrayList;
import org.catacomb.interlish.structure.TreeNode;

public class DemoNode
implements TreeNode {
    public String name;
    public ArrayList<TreeNode> children;
    Object parent;

    public DemoNode(Object p) {
        this(p, "root");
    }

    public DemoNode(Object p, String s) {
        this.name = s;
        this.parent = p;
    }

    public DemoNode(String s, int level) {
        this.name = s;
        this.children = new ArrayList();
        this.children.add(new DemoNode("child-a-" + level));
        this.children.add(new DemoNode("child-b-" + level));
        this.children.add(new DemoNode("child-c-" + level));
        if (level > 0) {
            this.children.add(new DemoNode("folder-" + level, level - 1));
        }
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int getChildCount() {
        int nch = 0;
        if (this.children != null) {
            nch = this.children.size();
        }
        return nch;
    }

    @Override
    public Object getChild(int index) {
        return this.children.get(index);
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.children.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        boolean isleaf = true;
        if (this.children != null && this.children.size() > 0) {
            isleaf = false;
        }
        return isleaf;
    }
}

