/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.arbor;

import java.util.ArrayList;
import org.catacomb.be.DeReferencable;
import org.catacomb.be.Position;
import org.catacomb.be.ReReferencable;
import org.catacomb.graph.arbor.SegmentGraphPoint;
import org.catacomb.graph.drawing.VectorIcon;
import org.catacomb.interlish.structure.AttachmentPoint;
import org.catacomb.interlish.structure.Mesh;
import org.catacomb.interlish.structure.MeshBuilder;
import org.catacomb.interlish.structure.MeshInstructor;
import org.catacomb.interlish.structure.PointAttachable;

public class SegmentGraph
implements ReReferencable,
DeReferencable,
PointAttachable,
MeshInstructor {
    public ArrayList<SegmentGraphPoint> points = new ArrayList();
    private ArrayList<AttachmentPoint> p_bufAttachmentPoints;
    private double[] bufLimits;

    public void addInitialGraph() {
        SegmentGraphPoint sgp1 = this.addNewPoint(0.0, 0.0, null);
        this.addNewPoint(10.0, 0.0, sgp1);
    }

    public void ensureNonEmpty() {
        if (this.points.size() == 0) {
            this.addInitialGraph();
        }
    }

    @Override
    public void deReference() {
        this.indexPoints();
        for (SegmentGraphPoint sgp : this.getPoints()) {
            sgp.deReference();
        }
    }

    @Override
    public void reReference() {
        this.indexPoints();
        for (SegmentGraphPoint sgp : this.getPoints()) {
            sgp.reReference(this.points);
        }
    }

    @Override
    public ArrayList<AttachmentPoint> getAttachmentPoints() {
        if (this.p_bufAttachmentPoints == null || this.p_bufAttachmentPoints.size() != this.size()) {
            this.p_bufAttachmentPoints = new ArrayList();
            for (SegmentGraphPoint sgp : this.getPoints()) {
                this.p_bufAttachmentPoints.add(sgp.makeAttachmentPoint());
            }
        }
        return this.p_bufAttachmentPoints;
    }

    @Override
    public Mesh makeMesh(MeshBuilder mbuilder) {
        mbuilder.startMesh();
        this.indexPoints();
        for (SegmentGraphPoint sgp : this.getPoints()) {
            Position pos = sgp.getPosition();
            Object newPoint = mbuilder.newPoint(pos.getX(), pos.getY(), sgp.getZ(), sgp.getR(), sgp.getIndex(), sgp);
            int i = sgp.getIndex();
            SegmentGraphPoint[] sgn = sgp.getNeighbors();
            int k = 0;
            while (k < sgn.length) {
                if (sgn[k].getIndex() < i) {
                    mbuilder.connectToPeer(newPoint, sgn[k]);
                }
                ++k;
            }
        }
        Mesh mesh = mbuilder.getMesh();
        return mesh;
    }

    public int size() {
        return this.getPointCount();
    }

    public int getPointCount() {
        return this.points.size();
    }

    public ArrayList<SegmentGraphPoint> getPoints() {
        return this.points;
    }

    public void indexPoints() {
        int i = 0;
        for (SegmentGraphPoint sgp : this.points) {
            sgp.setIndex(i);
            ++i;
        }
    }

    public SegmentGraphPoint addNewPoint(double x, double y, SegmentGraphPoint psgp) {
        SegmentGraphPoint sgp = new SegmentGraphPoint(x, y);
        if (psgp != null) {
            psgp.connectTo(sgp);
        }
        this.addPoint(sgp);
        return sgp;
    }

    public void addRealize(SegmentGraphPoint sgp) {
        this.addPoint(sgp);
        sgp.realize();
    }

    public void clearHighlight() {
        for (SegmentGraphPoint sgp : this.points) {
            sgp.unHighlight();
        }
    }

    public void clearMark() {
        for (SegmentGraphPoint sgp : this.points) {
            sgp.unMark();
        }
    }

    public void highlightPath(SegmentGraphPoint sgpa, SegmentGraphPoint sgpb) {
        this.clearHighlight();
        this.clearMark();
        sgpb.highlight();
        sgpa.recHighlightPath();
    }

    public void highlightTree(SegmentGraphPoint sgpa, SegmentGraphPoint sgpb) {
        this.clearHighlight();
        sgpa.highlight();
        sgpb.recHighlight();
    }

    public void highlightTrace(SegmentGraphPoint sgpa) {
        this.clearHighlight();
        sgpa.recHighlight();
    }

    public void attachLabelToSelected(String slabel) {
        for (SegmentGraphPoint sgp : this.points) {
            if (!sgp.isHighlighted()) continue;
            sgp.setLabel(slabel);
        }
    }

    public void showLabel(String s) {
        for (SegmentGraphPoint sgp : this.points) {
            sgp.highlightLabel(s);
        }
    }

    public void addPoint(SegmentGraphPoint sgp) {
        sgp.setIndex(this.points.size());
        this.points.add(sgp);
        this.p_bufAttachmentPoints = null;
    }

    public void removePoint(SegmentGraphPoint sgp) {
        this.points.remove(sgp);
        this.p_bufAttachmentPoints = null;
    }

    public double[] getLimits() {
        if (this.bufLimits == null) {
            SegmentGraphPoint p0 = this.points.get(0);
            double xmin = p0.getX();
            double ymin = p0.getY();
            double xmax = xmin;
            double ymax = ymin;
            for (SegmentGraphPoint p : this.points) {
                double x = p.getX();
                double y = p.getY();
                if (x < xmin) {
                    xmin = x;
                }
                if (x > xmax) {
                    xmax = x;
                }
                if (ymin < y) {
                    ymin = y;
                }
                if (!(ymax > y)) continue;
                ymax = y;
            }
            double[] da = new double[]{xmin, ymin, xmax, ymax};
            this.bufLimits = da;
        }
        return this.bufLimits;
    }

    public VectorIcon getVectorIcon() {
        double[] xyxy = this.getLimits();
        double xmin = xyxy[0];
        double ymin = xyxy[1];
        double xmax = xyxy[2];
        double ymax = xyxy[3];
        double dx = xmax - xmin + 1.0E-4;
        double dy = ymax - ymin + 1.0E-4;
        double hdx = dx / 2.0;
        double hdy = dy / 2.0;
        double xcen = (xmin + xmax) / 2.0;
        double ycen = (ymin + ymax) / 2.0;
        VectorIcon ret = new VectorIcon();
        for (SegmentGraphPoint p : this.points) {
            double x0 = (p.getX() - xcen) / hdx;
            double y0 = (p.getY() - ycen) / hdy;
            SegmentGraphPoint[] segmentGraphPointArray = p.getNeighbors();
            int n = segmentGraphPointArray.length;
            int n2 = 0;
            while (n2 < n) {
                SegmentGraphPoint q = segmentGraphPointArray[n2];
                double x1 = (q.getX() - xcen) / hdx;
                double y1 = (q.getY() - ycen) / hdy;
                ret.addStraightLine(x0, y0, x1, y1);
                ++n2;
            }
        }
        return ret;
    }
}

