/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.arbor;

import java.awt.Color;
import org.catacomb.be.Position;
import org.catacomb.datalish.Box;
import org.catacomb.graph.arbor.SegmentGraph;
import org.catacomb.graph.arbor.SegmentGraphPoint;
import org.catacomb.graph.gui.BuildPaintInstructor;
import org.catacomb.graph.gui.Builder;
import org.catacomb.graph.gui.Painter;
import org.catacomb.graph.gui.PickListener;
import org.catacomb.graph.gui.Pickable;
import org.catacomb.report.E;

public class SegmentGraphVE
implements BuildPaintInstructor,
PickListener {
    SegmentGraph graph;
    double pressX;
    double pressY;
    double pressRadius;
    boolean selectable;
    boolean modifiable;
    boolean antialias = true;
    int selectAction = 0;
    public static final int VIEW = 0;
    public static final int EDIT = 1;
    public static final int MOVE = 2;
    public static final int DELETE = 3;
    public static final int PATH = 4;
    public static final int TREE = 5;
    public static final int TRACE = 6;
    static final String[] actionNames = new String[]{"view", "edit", "move", "delete", "selectPath", "selectTree", "trace"};
    SegmentGraphPoint sgp1;
    SegmentGraphPoint sgp2;

    public void setSegmentGraph(SegmentGraph sg) {
        this.graph = sg;
    }

    public void setAntialias(boolean b) {
        this.antialias = b;
    }

    public void setSelectAction(String sin) {
        String s = sin;
        if (s == null) {
            s = "view";
        }
        int iact = -1;
        int i = 0;
        while (i < actionNames.length) {
            if (actionNames[i].equals(s)) {
                iact = i;
            }
            ++i;
        }
        if (iact >= 0) {
            this.setSelectAction(iact);
        } else {
            E.error("dont know action " + s);
        }
    }

    public void setSelectAction(int act) {
        this.selectAction = act;
        this.clearSelect();
    }

    public void clearSelect() {
        this.sgp1 = null;
        this.sgp2 = null;
    }

    @Override
    public boolean antialias() {
        return this.antialias;
    }

    @Override
    public void instruct(Painter painter, Builder builder) {
        if (this.graph == null) {
            return;
        }
        if (this.selectAction == 1) {
            for (SegmentGraphPoint sgp : this.graph.getPoints()) {
                this.paintProto(sgp, painter, builder);
            }
        }
        for (SegmentGraphPoint sgp : this.graph.getPoints()) {
            this.paintReal(sgp, painter, builder);
        }
    }

    public void paintProto(SegmentGraphPoint sgp, Painter painter, Builder builder) {
        SegmentGraphPoint sgpe = sgp.getExtensionProto();
        painter.setColor(Color.gray);
        painter.drawLine(sgp.getPosition(), sgpe.getPosition());
        builder.addPoint(sgpe);
        SegmentGraphPoint[] psgps = sgp.getProtoNeighbors();
        SegmentGraphPoint[] rsgps = sgp.getNeighbors();
        int index = sgp.getIndex();
        int i = 0;
        while (i < psgps.length) {
            if (index < rsgps[i].getIndex()) {
                builder.addPoint(psgps[i]);
            }
            ++i;
        }
    }

    public void paintReal(SegmentGraphPoint sgp, Painter painter, Builder builder) {
        if (this.selectAction != 0) {
            builder.addPoint(sgp);
        }
        SegmentGraphPoint[] nbrs = sgp.getNeighbors();
        int index = sgp.getIndex();
        if (sgp.isHighlighted()) {
            painter.setColor(Color.orange);
            painter.fillCircle(sgp.getPosition(), sgp.getRadius());
        } else {
            painter.setColor(Color.white);
            painter.drawCircle(sgp.getPosition(), sgp.getRadius());
        }
        int i = 0;
        while (i < nbrs.length) {
            if (nbrs[i].getIndex() > index) {
                if (sgp.isHighlighted() && nbrs[i].isHighlighted()) {
                    painter.setColor(Color.orange);
                } else {
                    painter.setColor(Color.white);
                }
                this.drawSegment(painter, sgp, nbrs[i]);
            }
            ++i;
        }
    }

    public void drawSegment(Painter painter, SegmentGraphPoint sgpa, SegmentGraphPoint sgpb) {
        Position p1 = sgpa.getPosition();
        double x1 = p1.getX();
        double y1 = p1.getY();
        double r1 = sgpa.getRadius();
        Position p2 = sgpb.getPosition();
        double x2 = p2.getX();
        double y2 = p2.getY();
        double r2 = sgpb.getRadius();
        painter.drawCarrotSides(x1, y1, r1, x2, y2, r2);
    }

    @Override
    public void backgroundPressed(int i, int x, int y) {
    }

    @Override
    public void pickPressed(Pickable pbl, int button, int ix, int iy) {
        if (pbl instanceof SegmentGraphPoint) {
            SegmentGraphPoint sgp = (SegmentGraphPoint)pbl;
            if (button == 1) {
                if (sgp.isReal()) {
                    this.tryHighlight(sgp);
                } else {
                    this.graph.addRealize(sgp);
                }
            } else if (button == 3 && sgp.isReal()) {
                this.pressRadius = sgp.getRadius();
                this.pressX = sgp.getPosition().getX();
                this.pressY = sgp.getPosition().getY();
            }
        }
    }

    @Override
    public void pickDragged(Pickable pbl, Position pos, int button, int ix, int iy) {
        if ((this.selectAction == 1 || this.selectAction == 2) && pbl instanceof SegmentGraphPoint) {
            SegmentGraphPoint sgp = (SegmentGraphPoint)pbl;
            if (button == 1) {
                sgp.move(pos);
            } else if (button == 3) {
                double f = 0.1 * (pos.getY() - this.pressY) / this.pressRadius;
                sgp.setRadius(this.pressRadius * Math.exp(f));
            }
        }
    }

    @Override
    public void pickReleased(Pickable pbl, int button) {
    }

    private void tryHighlight(SegmentGraphPoint sgp) {
        this.sgp1 = this.sgp2;
        this.sgp2 = sgp;
        if (this.selectAction == 6) {
            this.graph.highlightTrace(sgp);
        } else if (this.sgp1 != null) {
            if (this.selectAction == 4) {
                this.graph.highlightPath(this.sgp1, this.sgp2);
                this.clearSelect();
            } else if (this.selectAction == 5) {
                this.graph.highlightTree(this.sgp1, this.sgp2);
                this.clearSelect();
            }
        } else {
            this.graph.clearHighlight();
            this.sgp2.highlight();
        }
    }

    @Override
    public void pickEnteredTrash(Pickable pbl) {
    }

    @Override
    public void pickLeftTrash(Pickable pbl) {
    }

    @Override
    public void pickTrashed(Pickable pbl) {
    }

    @Override
    public void trashPressed() {
    }

    @Override
    public void pickHovered(Pickable hoverItem) {
    }

    public Box getLimitBox() {
        return null;
    }

    @Override
    public Box getLimitBox(Painter p) {
        return null;
    }
}

