/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.drawing;

import java.awt.Color;
import java.util.StringTokenizer;
import org.catacomb.graph.drawing.FixedDrawingComponent;
import org.catacomb.graph.drawing.Shape;
import org.catacomb.graph.gui.Painter;
import org.catacomb.util.ArrayUtil;

public class SegmentLine
extends FixedDrawingComponent {
    public String xyxy;
    public double[] xpts;
    public double[] ypts;
    private double[] p_x;
    private double[] p_y;
    private double[] p_wkx;
    private double[] p_wky;

    public SegmentLine() {
    }

    public SegmentLine(double[] ax, double[] ay, Color c) {
        this.p_x = ax;
        this.p_y = ay;
        this.setWidth(1.0);
        this.setColor(c);
        this.init();
    }

    public double[] getXPts() {
        return this.p_x;
    }

    public double[] getYPts() {
        return this.p_y;
    }

    @Override
    public void instruct(Painter p, double offx, double offy, double scale) {
        int n = this.p_x.length;
        int i = 0;
        while (i < n) {
            this.p_wkx[i] = offx + scale * this.p_x[i];
            this.p_wky[i] = offy + scale * this.p_y[i];
            ++i;
        }
        p.drawPolyline(this.p_wkx, this.p_wky, n, this.getColor(), this.getWidth(), this.widthIsPixels());
    }

    @Override
    public void reReference() {
        super.reReference();
        if (this.xyxy != null) {
            StringTokenizer st = new StringTokenizer(this.xyxy, ", \n");
            int nt = st.countTokens();
            int hn = nt / 2;
            this.p_x = new double[hn];
            this.p_y = new double[hn];
            int i = 0;
            while (i < hn) {
                this.p_x[i] = new Double(st.nextToken());
                this.p_y[i] = new Double(st.nextToken());
                ++i;
            }
        } else if (this.xpts != null) {
            this.p_x = this.xpts;
            this.p_y = this.ypts;
        }
        this.init();
    }

    private void init() {
        if (this.p_x == null) {
            this.p_x = new double[0];
            this.p_y = new double[0];
        }
        int n = this.p_x.length;
        this.p_wkx = new double[n];
        this.p_wky = new double[n];
    }

    public void shift(double dx, double dy) {
        int i = 0;
        while (i < this.p_x.length) {
            int n = i;
            this.p_x[n] = this.p_x[n] + dx;
            int n2 = i++;
            this.p_y[n2] = this.p_y[n2] + dy;
        }
    }

    public void scaleBy(double fac) {
        int i = 0;
        while (i < this.p_x.length) {
            int n = i;
            this.p_x[n] = this.p_x[n] * fac;
            int n2 = i++;
            this.p_y[n2] = this.p_y[n2] * fac;
        }
    }

    @Override
    public void applyToShape(Shape shp) {
        shp.setClosure(0);
        shp.setCurviness(0.0);
        shp.setSymmetry(0);
        shp.setXpts(ArrayUtil.copyDArray(this.getXPts()));
        shp.setYpts(ArrayUtil.copyDArray(this.getYPts()));
    }

    public static SegmentLine unitBox() {
        double[] xp = new double[]{-1.0, 1.0, 1.0, -1.0, -1.0};
        double[] yp = new double[]{1.0, 1.0, -1.0, -1.0, 1.0};
        SegmentLine ret = new SegmentLine(xp, yp, Color.gray);
        return ret;
    }
}

