/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.drawing;

import java.awt.Color;
import org.catacomb.be.DeReferencable;
import org.catacomb.be.Position;
import org.catacomb.be.ReReferencable;
import org.catacomb.datalish.SColor;
import org.catacomb.graph.drawing.ShapePoint;
import org.catacomb.graph.drawing.ShapeSymmetry;
import org.catacomb.graph.gui.Geom;
import org.catacomb.graph.gui.PickableRegion;
import org.catacomb.interlish.content.IntPosition;
import org.catacomb.interlish.content.Polypoint;
import org.catacomb.interlish.content.RShape;
import org.catacomb.interlish.structure.Assembly;
import org.catacomb.interlish.structure.Table;
import org.catacomb.interlish.structure.TablePeer;
import org.catacomb.report.E;
import org.catacomb.util.ArrayUtil;

public class Shape
extends Polypoint
implements ReReferencable,
DeReferencable,
TablePeer {
    public double curviness = 0.0;
    public double lineWidth = 1.0;
    public SColor lineColor;
    public SColor fillColor;
    private Color p_lineColor;
    private Color p_fillColor;
    public String symmetry;
    private int p_symmetry;
    public static final int MOVE_POINT = 0;
    public static final int ROTATE_SHAPE = 1;
    public static final int SHIFT_SHAPE = 2;
    private ShapePoint[] p_points;
    private ShapePoint[] p_protos;
    private boolean p_protosUTD;
    private Position p_position = new Position();
    private Position p_cachePosition = new Position();
    private Position p_pressPosition;
    private PickableRegion p_pickableRegion;
    private boolean updatePickable;
    private IntPosition p_intPosition;
    private boolean intIsDefinitive;
    private Assembly r_parent;
    private boolean pointLeadsArrays;
    private boolean p_rotating;
    private int pointColor = 65280;
    private int protoPointColor = 0xFF00FF;
    private int p_index;
    private Table p_table;

    public Shape() {
        this.p_lineColor = Color.blue;
        this.p_fillColor = Color.yellow;
        this.setClosure(2);
    }

    public Shape(Shape s) {
        this();
        this.curviness = s.curviness;
        this.p_symmetry = s.p_symmetry;
        this.setClosure(s.getClosure());
        this.lineWidth = s.lineWidth;
        this.p_lineColor = s.p_lineColor;
        this.p_fillColor = s.p_fillColor;
        this.xpts = this.copyArray(s.xpts);
        this.ypts = this.copyArray(s.ypts);
        this.makePoints();
        this.syncArrays();
        this.initPickable();
    }

    public void setLineWidth(double d) {
        this.lineWidth = d;
    }

    public void setIndex(int ind) {
        this.p_index = ind;
    }

    public int getIndex() {
        return this.p_index;
    }

    public void select() {
        this.cachePositions();
    }

    public ShapePoint[] getPoints() {
        return this.p_points;
    }

    public ShapePoint[] getProtoPoints() {
        if (this.p_protos == null || !this.p_protosUTD) {
            this.makeProtos();
        }
        return this.p_protos;
    }

    public String getStringClosure() {
        return p_closureNames[this.getClosure()];
    }

    public void setParent(Assembly a) {
        this.r_parent = a;
    }

    public Assembly getParent() {
        return this.r_parent;
    }

    public void setCurviness(double d) {
        this.curviness = d;
    }

    public double getCurviness() {
        return this.curviness;
    }

    public void setClosure(String s) {
        this.setClosure(0);
        int iia = ArrayUtil.getIndexInArray(s, p_closureNames);
        if (iia >= 0) {
            this.setClosure(iia);
        }
    }

    private double[] copyArray(double[] da) {
        double[] ret = new double[da.length];
        System.arraycopy(da, 0, ret, 0, da.length);
        return ret;
    }

    public Shape makeCopy() {
        this.syncArrays();
        return new Shape(this);
    }

    public void setSymmetryString(String s) {
        this.p_symmetry = 0;
        int iia = ArrayUtil.getIndexInArray(s, ShapeSymmetry.getSymmetryNames());
        if (iia >= 0) {
            this.p_symmetry = iia;
        }
    }

    @Override
    public void reReference() {
        this.setClosure(this.closure);
        this.setSymmetryString(this.symmetry);
        this.makePoints();
        this.syncArrays();
        if (this.lineColor != null) {
            this.p_lineColor = this.lineColor.getColor();
        }
        if (this.fillColor != null) {
            this.p_fillColor = this.fillColor.getColor();
        }
    }

    @Override
    public void deReference() {
        this.closure = p_closureNames[this.getClosure()];
        String[] symnms = ShapeSymmetry.getSymmetryNames();
        this.symmetry = symnms[this.p_symmetry];
    }

    public double getSmoothness() {
        return this.curviness;
    }

    public Color getLineColor() {
        return this.p_lineColor;
    }

    public Color getFillColor() {
        return this.p_fillColor;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public boolean isExtensible() {
        return this.p_symmetry == 0;
    }

    public int getSymmetry() {
        return this.p_symmetry;
    }

    private void cachePositions() {
        this.p_cachePosition.set(this.p_position);
        int i = 0;
        while (i < this.p_points.length) {
            this.p_points[i].cachePosition();
            ++i;
        }
    }

    public void setPosition(Position p) {
        this.updatePickable = true;
        Position prel = new Position(p);
        prel.subtract(this.p_cachePosition);
        int i = 0;
        while (i < this.p_points.length) {
            this.p_points[i].shiftFromCache(prel);
            ++i;
        }
        this.flagPointMoved();
        this.intIsDefinitive = false;
    }

    public void initPickable() {
        this.p_pickableRegion = new PickableRegion(this.getXPts(), this.getYPts(), this);
        if (!this.isClosed()) {
            this.p_pickableRegion.setPoints(Geom.makeLineBoundary(this.getXPts(), this.getYPts()));
        }
        this.p_pickableRegion.setReferencePoint(this.p_position);
        this.updatePickable = false;
    }

    public PickableRegion getBoundaryRegion() {
        if (this.p_pickableRegion == null) {
            this.initPickable();
        } else if (this.updatePickable) {
            if (this.isClosed()) {
                this.p_pickableRegion.setPoints(this.getXPts(), this.getYPts());
                this.p_pickableRegion.setReferencePoint(this.p_position);
            } else {
                this.p_pickableRegion.setPoints(Geom.makeLineBoundary(this.getXPts(), this.getYPts()));
                this.p_pickableRegion.setReferencePoint(this.p_position);
            }
            this.updatePickable = false;
        }
        return this.p_pickableRegion;
    }

    public void makePoints() {
        int np = this.xpts.length;
        this.p_points = new ShapePoint[np];
        int i = 0;
        while (i < np) {
            this.p_points[i] = new ShapePoint(this, new Position(this.xpts[i], this.ypts[i]), this.pointColor);
            ++i;
        }
    }

    private void makeProtos() {
        int np;
        int nproto = np = this.p_points.length;
        if (this.isOpen()) {
            --nproto;
        }
        this.p_protos = new ShapePoint[nproto];
        int i = 0;
        while (i < nproto) {
            ShapePoint sp;
            Position pa = this.p_points[i].getPosition();
            Position pb = this.p_points[(i + 1) % np].getPosition();
            Position midpos = Position.aXPlusBY(0.5, pa, 0.5, pb);
            this.p_protos[i] = sp = new ShapePoint(this, midpos, this.protoPointColor);
            sp.setIndex(i);
            sp.setType("proto");
            ++i;
        }
        this.p_protosUTD = true;
    }

    public Position getPosition() {
        return this.p_position;
    }

    public void setIntPosition(IntPosition intp) {
        if (this.p_intPosition == null) {
            this.p_intPosition = new IntPosition();
        }
        this.p_intPosition.set(intp);
        this.intIsDefinitive = true;
    }

    public boolean hasIntPosition() {
        return this.intIsDefinitive;
    }

    public IntPosition getIntPosition() {
        return this.p_intPosition;
    }

    @Override
    public double[] getXPts() {
        if (this.pointLeadsArrays) {
            this.syncArrays();
        }
        return this.xpts;
    }

    @Override
    public double[] getYPts() {
        if (this.pointLeadsArrays) {
            this.syncArrays();
        }
        return this.ypts;
    }

    public void flagPointMoved() {
        this.pointLeadsArrays = true;
        this.p_protosUTD = false;
    }

    public void syncArrays() {
        int np = this.p_points.length;
        if (this.xpts == null || this.xpts.length != np) {
            this.xpts = new double[np];
            this.ypts = new double[np];
        }
        int i = 0;
        while (i < np) {
            Position pos = this.p_points[i].getPosition();
            this.xpts[i] = pos.getX();
            this.ypts[i] = pos.getY();
            ++i;
        }
        this.p_position.set(this.cog(this.xpts), this.cog(this.ypts));
        this.p_protosUTD = false;
        this.updatePickable = true;
        this.pointLeadsArrays = false;
    }

    public void addPoint(int ipr, double x, double y) {
        this.addPoint(ipr, new ShapePoint(this, new Position(x, y), this.pointColor));
    }

    public void addPoint(int ipr, ShapePoint sp) {
        sp.setType("normal");
        sp.setColor(this.pointColor);
        int np = this.p_points.length;
        ShapePoint[] ap = new ShapePoint[np + 1];
        int i = 0;
        while (i <= ipr) {
            ap[i] = this.p_points[i];
            ++i;
        }
        ap[ipr + 1] = sp;
        i = ipr + 1;
        while (i < np) {
            ap[i + 1] = this.p_points[i];
            ++i;
        }
        this.p_points = ap;
        this.p_protosUTD = false;
        this.syncArrays();
    }

    public boolean deletePoint(ShapePoint sp) {
        boolean ret = false;
        int itg = -1;
        int i = 0;
        while (i < this.p_points.length) {
            if (sp == this.p_points[i]) {
                itg = i;
                break;
            }
            ++i;
        }
        if (itg >= 0) {
            ret = this.deletePoint(itg);
        } else {
            E.error("cant find point");
        }
        return ret;
    }

    public boolean deletePoint(int itg) {
        boolean bdone = false;
        if (!this.isRectangular() && this.p_points.length > 2) {
            int np = this.p_points.length;
            ShapePoint[] ap = new ShapePoint[np - 1];
            int i = 0;
            while (i < itg) {
                ap[i] = this.p_points[i];
                ++i;
            }
            i = itg;
            while (i < np - 1) {
                ap[i] = this.p_points[i + 1];
                ++i;
            }
            this.p_points = ap;
            this.p_protosUTD = false;
            this.syncArrays();
            bdone = true;
        }
        return bdone;
    }

    private double cog(double[] ap) {
        int n = ap.length;
        double c = 0.0;
        int i = 0;
        while (i < n) {
            c += ap[i];
            ++i;
        }
        return c /= (double)n;
    }

    public void regionPressed() {
        this.p_rotating = false;
    }

    public void pointPressed(ShapePoint sp) {
        this.p_rotating = false;
        this.cachePositions();
    }

    public void movePoint(ShapePoint sp, Position pos, int action) {
        if (action != 2) {
            if (action == 1) {
                this.rotate(sp, pos);
            } else if (action == 0) {
                ShapeSymmetry.applySymmetry(this, sp, pos);
            }
        }
        this.flagPointMoved();
    }

    public void rotate(Position pos) {
        if (this.p_rotating) {
            this.rotateFromTo(this.p_pressPosition, pos);
        } else {
            this.p_pressPosition = new Position(pos);
            this.p_rotating = true;
        }
    }

    private void rotate(ShapePoint sp, Position pos) {
        this.rotateFromTo(sp.getCachedPosition(), pos);
    }

    private void rotateFromTo(Position pc, Position pos) {
        double pxc = this.p_cachePosition.getX();
        double pyc = this.p_cachePosition.getY();
        double xa = pc.getX() - pxc;
        double ya = pc.getY() - pyc;
        double xb = pos.getX() - pxc;
        double yb = pos.getY() - pyc;
        double a2 = xa * xa + ya * ya;
        double b2 = xb * xb + yb * yb;
        double mp = Math.sqrt(a2 * b2);
        double cos = (xa * xb + ya * yb) / mp;
        double sin = (xa * yb - xb * ya) / mp;
        int i = 0;
        while (i < this.p_points.length) {
            Position pca = this.p_points[i].getCachedPosition();
            double px = pca.getX() - pxc;
            double py = pca.getY() - pyc;
            double pxn = pxc + cos * px - sin * py;
            double pyn = pyc + sin * px + cos * py;
            this.p_points[i].setPosition(new Position(pxn, pyn));
            ++i;
        }
    }

    public void setLineColor(Color col) {
        this.p_lineColor = col;
    }

    public void setFillColor(Color col) {
        this.p_fillColor = col;
    }

    public boolean isRectangular() {
        return this.p_symmetry == 1 || this.p_symmetry == 3;
    }

    public boolean overlaps(Shape shape) {
        return true;
    }

    @Override
    public void attachTable(Table tbl) {
        this.p_table = tbl;
    }

    @Override
    public void initFromTable(Table tbl) {
        this.p_table = tbl;
    }

    @Override
    public Table getTable() {
        return this.p_table;
    }

    @Override
    public void removeChild(TablePeer child) {
        E.error("shapes dont have children");
    }

    public void setSymmetry(int isym) {
        this.p_symmetry = isym;
    }

    public void rescale(double d) {
        this.expand(d);
    }

    public void expand(double d) {
        int i = 0;
        while (i < this.xpts.length) {
            int n = i;
            this.xpts[n] = this.xpts[n] * d;
            int n2 = i++;
            this.ypts[n2] = this.ypts[n2] * d;
        }
        this.makePoints();
        this.syncArrays();
    }

    public void shiftExpand(double ox, double oy, double d) {
        int i = 0;
        while (i < this.xpts.length) {
            this.xpts[i] = ox + d * this.xpts[i];
            this.ypts[i] = oy + d * this.ypts[i];
            ++i;
        }
        this.makePoints();
        this.syncArrays();
    }

    public void contract(double d) {
        this.expand(1.0 / d);
    }

    public String getStringSymmetry() {
        return ShapeSymmetry.getStringSymmetry(this.p_symmetry);
    }

    public boolean isQuadrilateral() {
        return this.xpts.length == 4;
    }

    public boolean isFullyRounded() {
        return this.curviness > 0.99;
    }

    public boolean isFullyAngular() {
        return this.curviness < 0.01;
    }

    public boolean isSymmetric() {
        return this.p_symmetry == 1 || this.p_symmetry == 3;
    }

    public boolean isRectangleSymmetry() {
        return this.p_symmetry == 1;
    }

    public boolean isSquareSymmetry() {
        return this.p_symmetry == 3;
    }

    @Override
    public void notifyObservers() {
    }

    private double[][] curveInterps() {
        int nintern = 5;
        double[][] cif = new double[2][nintern];
        int i = 0;
        while (i < nintern) {
            double fi = 1.0 * (double)i / (double)nintern;
            cif[0][i] = Math.sin(fi * Math.PI / 2.0);
            cif[1][i] = 1.0 - Math.sin((1.0 - fi) * Math.PI / 2.0);
            ++i;
        }
        return cif;
    }

    public double[][] getBoundaryPoints() {
        double[][] ret = null;
        ShapePoint[] spts = this.getPoints();
        int n = spts.length;
        if (this.curviness <= 0.1) {
            ret = new double[2][n];
            int i = 0;
            while (i < n) {
                ShapePoint sp = spts[i];
                Position ap = sp.getAbsolutePosition();
                ret[0][i] = ap.getX();
                ret[1][i] = ap.getY();
                ++i;
            }
        } else {
            double[][] cif = this.curveInterps();
            int nin = cif[0].length;
            ret = new double[2][n * nin];
            int ipt = 0;
            while (ipt < n) {
                Position pa = spts[ipt].getAbsolutePosition();
                Position pb = spts[(ipt + 1) % n].getAbsolutePosition();
                Position pc = spts[(ipt + 2) % n].getAbsolutePosition();
                Position mab = Position.midpoint(pa, pb);
                Position mbc = Position.midpoint(pb, pc);
                double v1x = pb.getX() - mab.getX();
                double v1y = pb.getY() - mab.getY();
                double v2x = mbc.getX() - pb.getX();
                double v2y = mbc.getY() - pb.getY();
                int j = 0;
                while (j < nin) {
                    int iin = ipt * nin + j;
                    ret[0][iin] = mab.getX() + cif[0][j] * v1x + cif[1][j] * v2x;
                    ret[1][iin] = mab.getY() + cif[0][j] * v1y + cif[1][j] * v2y;
                    ++j;
                }
                ++ipt;
            }
        }
        return ret;
    }

    public RShape exportRunish(double f) {
        double[][] xy = this.getBoundaryPoints();
        int i = 0;
        while (i < xy[0].length) {
            double[] dArray = xy[0];
            int n = i;
            dArray[n] = dArray[n] * f;
            double[] dArray2 = xy[1];
            int n2 = i++;
            dArray2[n2] = dArray2[n2] * f;
        }
        int rsc = 1;
        if (this.closure.equals("open")) {
            rsc = 0;
        } else if (this.closure.equals("closed")) {
            rsc = 1;
        } else if (this.closure.equals("filled")) {
            rsc = 2;
        } else {
            E.error("unrecognized " + this.closure);
        }
        RShape rs = new RShape(xy[0], xy[1], this.lineWidth, this.lineColor, this.fillColor, rsc);
        return rs;
    }
}

