/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.Color;
import org.catacomb.interlish.content.ColorTable;
import org.catacomb.interlish.structure.ColorMapped;
import org.catacomb.interlish.structure.Colored;
import org.catacomb.interlish.structure.IDable;
import org.catacomb.report.E;

public class DisplayStyleSet
implements Colored,
ColorMapped,
IDable {
    public String id;
    public static final String[] styleNames = new String[]{"solid", "dotted", "short dash", "long dash", "dot-dash"};
    int lineStyle = 0;
    public static final String[] widthNames = new String[]{"1", "1.5", "2", "3", "4"};
    public static final double[] widths = new double[]{1.0, 1.5, 2.0, 3.0, 4.0};
    int lineWidthIndex;
    double lineWidth;
    static Color defaultColor = new Color(201, 202, 203);
    Color lineColor;
    String colorTableName;
    ColorTable r_colorTable;
    boolean assignedLine;
    boolean assignedColor;
    static int lineStyleCounter;
    static int colorCounter;

    public DisplayStyleSet() {
        this.setLineWidthName("1");
        this.setLineColor(defaultColor);
        this.setColorTable("default");
        this.assignedLine = false;
        this.assignedColor = false;
    }

    public DisplayStyleSet(String s) {
        this();
        this.setID(s);
    }

    @Override
    public void setID(String s) {
        this.id = s;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public Color getColor() {
        return this.lineColor;
    }

    public final void setLineStyle(String s) {
        int isty = -1;
        int i = 0;
        while (i < styleNames.length) {
            if (styleNames[i].equals(s)) {
                isty = i;
                break;
            }
            ++i;
        }
        if (isty < 0) {
            this.lineStyle = 0;
            E.warning("unrecognized style " + s);
        } else {
            this.lineStyle = isty;
        }
        this.assignedLine = true;
    }

    public final void setLineWidthName(String s) {
        int isty = -1;
        int i = 0;
        while (i < widthNames.length) {
            if (widthNames[i].equals(s)) {
                isty = i;
                break;
            }
            ++i;
        }
        if (isty < 0) {
            isty = 0;
            E.warning("unrecognized width " + s);
        }
        this.lineWidthIndex = isty;
        this.lineWidth = widths[isty];
    }

    public int getLineWidthIndex() {
        return this.lineWidthIndex;
    }

    public static double[] getIndexedWidths() {
        return widths;
    }

    public static String[] getStyleNames() {
        return styleNames;
    }

    public final void setLineColor(Color c) {
        this.lineColor = c;
        this.assignedColor = true;
    }

    public final void setColorTable(String s) {
        this.colorTableName = s;
        this.r_colorTable = null;
    }

    public final void setColorTable(ColorTable ct) {
        this.r_colorTable = ct;
        this.colorTableName = ct.getName();
    }

    public String getStringLineStyle() {
        return styleNames[this.lineStyle];
    }

    public int getLineStyleIndex() {
        return this.lineStyle;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public ColorTable getColorTable() {
        return this.r_colorTable;
    }

    public String getColorTableName() {
        return this.colorTableName;
    }

    public String getStringLineWidth() {
        return widthNames[this.lineWidthIndex];
    }

    public void assignIfUnset() {
        if (!this.assignedLine) {
            this.lineStyle = lineStyleCounter;
            lineStyleCounter = (lineStyleCounter + 1) % styleNames.length;
            this.assignedLine = true;
        }
        if (!this.assignedColor) {
            Color c = new Color((int)(255.0 * Math.random()), (int)(255.0 * Math.random()), (int)(255.0 * Math.random()));
            this.setLineColor(c);
            this.assignedColor = true;
        }
    }
}

