/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import org.catacomb.graph.gui.BasePanel;
import org.catacomb.graph.gui.BuildPaintInstructor;
import org.catacomb.graph.gui.PaintInstructor;
import org.catacomb.graph.gui.PickListener;
import org.catacomb.graph.gui.PickWorldCanvas;
import org.catacomb.graph.gui.RotationListener;
import org.catacomb.interlish.interact.ClickListener;

public class DrawingCanvas
extends BasePanel {
    static final long serialVersionUID = 1001L;
    PickWorldCanvas pwCanvas;

    public DrawingCanvas(int w, int h) {
        this.setPreferredSize(new Dimension(w, h));
        this.pwCanvas = new PickWorldCanvas(w, h - 20, true);
        this.setLayout(new BorderLayout());
        this.add("Center", this.pwCanvas);
    }

    public void reframe() {
        this.pwCanvas.reframe();
    }

    public void setMouseMode(String s) {
        this.pwCanvas.setMouseMode(s);
    }

    public void setPaintInstructor(PaintInstructor pi) {
        this.pwCanvas.setPaintInstructor(pi);
    }

    public void setBuildPaintInstructor(BuildPaintInstructor bpi) {
        this.pwCanvas.setBuildPaintInstructor(bpi);
    }

    public void setPickListener(PickListener pl) {
        this.pwCanvas.setPickListener(pl);
    }

    public void setClickListener(ClickListener cl) {
        this.pwCanvas.setClickListener(cl);
    }

    public void setRotationListener(RotationListener rl) {
        this.pwCanvas.setRotationListener(rl);
    }

    public boolean isAntialiasing() {
        return this.pwCanvas.isAntialiasing();
    }

    public void setAntialias(boolean b) {
        this.pwCanvas.setAntialias(b);
    }

    public void setOnGridAxes() {
        this.pwCanvas.setOnGridAxes();
    }

    public void setThreeD() {
        this.pwCanvas.setFixedAspectRatio(1.0);
    }

    public void attach(Object obj) {
        if (obj instanceof BuildPaintInstructor) {
            this.setBuildPaintInstructor((BuildPaintInstructor)obj);
        } else if (obj instanceof PaintInstructor) {
            this.setPaintInstructor((PaintInstructor)obj);
        }
        if (obj instanceof PickListener) {
            this.setPickListener((PickListener)obj);
        }
        if (obj instanceof ClickListener) {
            this.setClickListener((ClickListener)obj);
        }
        if (obj instanceof RotationListener) {
            this.setRotationListener((RotationListener)obj);
        }
    }

    public void setBackgroundColor(Color c) {
        this.pwCanvas.setDataBackground(c);
    }

    public void setGridColor(Color c) {
        this.pwCanvas.setGridColor(c);
    }

    public void setAxisColor(Color c) {
        this.pwCanvas.setAxisColor(c);
    }

    public void setXRange(double low, double high) {
        this.pwCanvas.setXRange(low, high);
    }

    public void setFixedAspectRatio(double ar) {
        this.pwCanvas.setFixedAspectRatio(ar);
    }

    public void viewChanged() {
        if (this.pwCanvas != null) {
            this.pwCanvas.repaint();
        }
    }

    public double[][] getProjectionMatrix() {
        return this.pwCanvas.getProjectionMatrix();
    }

    public void setRollCenter(double x, double y, double z) {
        this.pwCanvas.setRollCenter(x, y, z);
    }

    public void turn(double d) {
        this.pwCanvas.turn(d);
    }

    public double[] get3Center() {
        return this.pwCanvas.get3Center();
    }

    public double[] get2Center() {
        return this.pwCanvas.get2Center();
    }

    public void setShowGrid(boolean b) {
        this.pwCanvas.setShowGrid(b);
    }

    public void setFourMatrix(double[] fm) {
        this.pwCanvas.setFourMatrix(fm);
    }

    public double[] getFourMatrix() {
        return this.pwCanvas.getFourMatrix();
    }
}

