/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.Graphics2D;
import org.catacomb.graph.gui.Mouse;

abstract class MouseHandler {
    static final int NONE = 0;
    static final int BUFFERED = 1;
    static final int FULL = 2;
    private int repaintStatus = 0;
    private boolean active = true;
    private static final int OUT = -1;
    private static final int UNDECIDED = 0;
    private static final int IN = 1;
    private int claimStatus = 0;

    MouseHandler() {
        this.setClaimUndecided();
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    boolean motionAware() {
        return false;
    }

    boolean motionChange(Mouse m) {
        return false;
    }

    int getRepaintStatus() {
        return this.repaintStatus;
    }

    void setRepaintStatus(int i) {
        this.repaintStatus = i;
    }

    void setFullRepaint() {
        this.repaintStatus = 2;
    }

    void setClaimUndecided() {
        this.claimStatus = 0;
    }

    void setClaimIn() {
        this.claimStatus = 1;
    }

    void setClaimOut() {
        this.claimStatus = -1;
    }

    boolean isIn() {
        return this.claimStatus == 1;
    }

    boolean isUndecided() {
        return this.claimStatus == 0;
    }

    boolean isOut() {
        return this.claimStatus == -1;
    }

    void clear() {
    }

    void init(Mouse m) {
    }

    void advance(Mouse m) {
    }

    void release(Mouse m) {
    }

    void echoPaint(Graphics2D g) {
    }

    void missedPress(Mouse m) {
    }

    void applyOnDown(Mouse m) {
    }

    void applyOnDrag(Mouse m) {
    }

    void applyOnRelease(Mouse m) {
    }
}

