/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import org.catacomb.graph.gui.Pickable;
import org.catacomb.graph.gui.PickablePoint;
import org.catacomb.graph.gui.PickableRegion;

public class PickStore {
    int npoint;
    Pickable[] points = new Pickable[10];
    int[][] pointBoxes = new int[10][4];
    int nregion;
    PickableRegion[] regions = new PickableRegion[10];
    int[][] regionRefs = new int[10][2];
    int xref = 0;
    int yref = 0;

    public void clear() {
        this.npoint = 0;
        this.nregion = 0;
    }

    public void addPoint(PickablePoint pbl, int xc, int yc) {
        int hrng = pbl.getRange() / 2;
        int icx0 = xc - hrng;
        int icy0 = yc - hrng;
        int icx1 = xc + hrng;
        int icy1 = yc + hrng;
        this.addPoint(pbl, icx0, icy0, icx1, icy1);
    }

    public void addPoint(Pickable pbl, int xa, int ya, int xb, int yb) {
        if (this.npoint >= this.points.length) {
            int nnew = (int)(1.5 * (double)this.points.length);
            Pickable[] npb = new Pickable[nnew];
            int[][] ab = new int[nnew][4];
            int i = 0;
            while (i < this.npoint) {
                npb[i] = this.points[i];
                int[] aab = ab[i];
                int[] apb = this.pointBoxes[i];
                aab[0] = apb[0];
                aab[1] = apb[1];
                aab[2] = apb[2];
                aab[3] = apb[3];
                ++i;
            }
            this.points = npb;
            this.pointBoxes = ab;
        }
        this.points[this.npoint] = pbl;
        int[] apb = this.pointBoxes[this.npoint];
        apb[0] = xa;
        apb[1] = ya;
        apb[2] = xb;
        apb[3] = yb;
        pbl.setCache(this.npoint);
        ++this.npoint;
    }

    public void addPickableRegion(PickableRegion pbl, int xr, int yr) {
        if (this.nregion >= this.regions.length) {
            int nnew = (int)(1.5 * (double)this.regions.length + 10.0);
            PickableRegion[] npb = new PickableRegion[nnew];
            int[][] nrc = new int[nnew][2];
            int i = 0;
            while (i < this.nregion) {
                npb[i] = this.regions[i];
                nrc[i][0] = this.regionRefs[i][0];
                nrc[i][1] = this.regionRefs[i][1];
                ++i;
            }
            this.regions = npb;
            this.regionRefs = nrc;
        }
        this.regions[this.nregion] = pbl;
        this.regionRefs[this.nregion][0] = xr;
        this.regionRefs[this.nregion][1] = yr;
        ++this.nregion;
    }

    private boolean within(int[] xyxy, int x, int y) {
        return x > xyxy[0] && x < xyxy[2] && y > xyxy[1] && y < xyxy[3];
    }

    public Pickable getClaimant(int mx, int my, double dx, double dy) {
        Pickable ret = null;
        int j = this.npoint - 1;
        while (j >= 0) {
            if (this.within(this.pointBoxes[j], mx, my)) {
                ret = this.points[j];
                int[] pbox = this.pointBoxes[j];
                this.xref = (pbox[0] + pbox[2]) / 2;
                this.yref = (pbox[1] + pbox[3]) / 2;
                break;
            }
            --j;
        }
        if (ret == null) {
            j = this.nregion - 1;
            while (j >= 0) {
                PickableRegion pr = this.regions[j];
                if (pr.contains(dx, dy)) {
                    ret = pr;
                    this.xref = this.regionRefs[j][0];
                    this.yref = this.regionRefs[j][1];
                    break;
                }
                --j;
            }
        }
        return ret;
    }

    public int getClaimantRefX() {
        return this.xref;
    }

    public int getClaimantRefY() {
        return this.yref;
    }

    public boolean itemClaims(Pickable pbl, int mx, int my, double dx, double dy) {
        boolean ret = false;
        int ind = pbl.getCache();
        if (pbl instanceof PickableRegion) {
            if (((PickableRegion)pbl).contains(dx, dy)) {
                ret = true;
            }
        } else if (this.within(this.pointBoxes[ind], mx, my)) {
            ret = true;
        }
        return ret;
    }

    public int[] getEchoBox(PickablePoint pp) {
        return this.pointBoxes[pp.getCache()];
    }
}

