/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.Color;
import org.catacomb.be.Position;
import org.catacomb.graph.gui.AbsLocated;
import org.catacomb.graph.gui.Pickable;

public class PickablePoint
implements Pickable {
    Position p_position;
    Color p_color;
    String p_tip;
    int p_size;
    int p_range;
    static final int SQUARE = 1;
    static final int CIRCLE = 2;
    int p_style;
    int p_icache;
    Object p_ref;
    private AbsLocated p_absLocated;

    public PickablePoint() {
        this(0.0, 0.0, null);
    }

    public PickablePoint(Object obj) {
        this(0.0, 0.0, obj);
    }

    public PickablePoint(double cx, double cy) {
        this(cx, cy, null);
    }

    public PickablePoint(Position p, Object obj) {
        this(p.getX(), p.getY(), obj);
    }

    public PickablePoint(Position p, Object obj, int icol) {
        this(p.getX(), p.getY(), obj);
        this.p_color = new Color(icol);
    }

    public PickablePoint(double cx, double cy, Object oref) {
        this(cx, cy, Color.red, oref);
    }

    public PickablePoint(double cx, double cy, Color col, Object oref) {
        this(cx, cy, col, oref, 4, 8);
    }

    public PickablePoint(double cx, double cy, Color col, Object oref, int isize, int irange) {
        this.p_position = new Position(cx, cy);
        this.p_color = col;
        this.p_ref = oref;
        if (oref instanceof AbsLocated) {
            this.p_absLocated = (AbsLocated)oref;
        }
        this.p_size = isize;
        this.p_range = irange;
    }

    public void moveTo(double x, double y) {
        this.p_position.set(x, y);
    }

    @Override
    public Object getRef() {
        return this.p_ref;
    }

    @Override
    public void setCache(int i) {
        this.p_icache = i;
    }

    @Override
    public int getCache() {
        return this.p_icache;
    }

    public void moveTo(Position pos) {
        this.setPosition(pos);
    }

    public void setPosition(Position p) {
        this.setPosition(p.getX(), p.getY());
    }

    public void setPosition(double x, double y) {
        this.p_position.set(x, y);
    }

    public int getRange() {
        return this.p_range;
    }

    public int getSize() {
        return this.p_size;
    }

    public void setColor(int icol) {
        this.setColor(new Color(icol));
    }

    public void setColor(Color c) {
        this.p_color = c;
    }

    public void setSize(int sz) {
        this.p_size = sz;
    }

    public void setRange(int rn) {
        this.p_range = rn;
    }

    public Position getPosition() {
        Position ret = null;
        ret = this.p_absLocated == null ? this.p_position : this.p_absLocated.getAbsolutePosition();
        return ret;
    }

    public Color getColor() {
        return this.p_color;
    }
}

