/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.catacomb.be.Position;
import org.catacomb.datalish.Box;
import org.catacomb.graph.gui.BaseCanvas;
import org.catacomb.graph.gui.BoxSelectionHandler;
import org.catacomb.graph.gui.ClickZoomHandler;
import org.catacomb.graph.gui.Mouse;
import org.catacomb.graph.gui.MouseHandler;
import org.catacomb.graph.gui.PaintInstructor;
import org.catacomb.graph.gui.Painter;
import org.catacomb.graph.gui.PanHandler;
import org.catacomb.graph.gui.RangeListener;
import org.catacomb.graph.gui.RollHandler;
import org.catacomb.graph.gui.RotationListener;
import org.catacomb.graph.gui.TurnZoomHandler;
import org.catacomb.graph.gui.TurntableHandler;
import org.catacomb.graph.gui.WorldTransform;
import org.catacomb.interlish.interact.ClickListener;
import org.catacomb.interlish.structure.ModeSettable;
import org.catacomb.report.E;

public class WorldCanvas
extends BaseCanvas
implements ModeSettable {
    static final long serialVersionUID = 1001L;
    public static final String PAN = "pan";
    public static final String ZOOM = "zoom";
    public static final String BOX = "box";
    public static final String ROLL = "roll";
    public static final String TURN = "turn";
    public static final String MULTI = "all";
    public static final String ZOOMIN = "zoomIn";
    public static final String ZOOMOUT = "zoomOut";
    protected WorldTransform wt;
    protected Painter painter;
    protected PaintInstructor paintInstructor;
    protected Mouse mouse;
    private BoxSelectionHandler boxSelectionHandler;
    private PanHandler panHandler;
    private TurnZoomHandler turnZoomHandler;
    private ClickZoomHandler clickZoomHandler;
    private RollHandler rollHandler;
    private TurntableHandler turntableHandler;
    private MouseHandler[] handlers;
    private boolean antialias = false;
    private boolean tooltips = false;
    Box reframeBox;
    private boolean userAntialias;

    public WorldCanvas(int w, int h) {
        this(w, h, true);
    }

    public WorldCanvas(int w, int h, boolean interactive) {
        super(w, h);
        this.mouse = new Mouse(this, interactive);
        this.wt = new WorldTransform();
        this.wt.setWidth(w);
        this.wt.setHeight(h);
        this.painter = new Painter(this.wt);
        this.addWorldHandlers();
        this.setMouseMode(PAN);
    }

    public boolean isAntialiasing() {
        return this.antialias;
    }

    public void setAntialias(boolean b) {
        this.userAntialias = b;
        this.antialias = b;
        this.repaint();
    }

    public void restoreAA() {
        this.setAntialias(this.userAntialias);
    }

    @Override
    public void setMode(String dom, String mod) {
        if (dom.equals("antialias")) {
            this.antialias = mod.equals("true");
        } else if (dom.equals("mouse")) {
            this.setMouseMode(mod);
        } else {
            E.error("unrecognized mode " + dom);
        }
        this.repaint();
    }

    @Override
    public void setMode(String dom, boolean b) {
        if (dom.equals("antialias")) {
            this.antialias = b;
        } else if (dom.equals("labels")) {
            this.tooltips = b;
        } else if (dom.equals("showAll")) {
            this.reframe();
        } else {
            E.error("unrecognized mode " + dom);
        }
        this.repaint();
    }

    public void syncSize() {
        this.wt.setWidth(this.getWidth());
        this.wt.setHeight(this.getHeight());
    }

    public void reluctantReframe() {
        Box box;
        if (this.reframeBox == null) {
            this.reframe();
        } else if (this.paintInstructor != null && (box = this.paintInstructor.getLimitBox()) != null && box.differentFrom(this.reframeBox, 0.15)) {
            this.frameToBox(box);
        }
    }

    public void reframe() {
        if (this.paintInstructor == null) {
            E.shortWarning("no paint instructor?");
        } else {
            Box box = this.paintInstructor.getLimitBox();
            this.frameToBox(box);
        }
    }

    protected void frameToBox(Box box) {
        if (box == null) {
            E.warning("no limit box returned from " + this.paintInstructor.getClass().getName());
        } else if (box.hasData()) {
            this.reframeBox = box.makeCopy();
            box.pad();
            this.painter.reframe(box);
            this.repaint();
        }
    }

    public boolean showTooltips() {
        return this.tooltips;
    }

    public void setMode(int imode) {
        E.missing();
    }

    public void addRangeListener(RangeListener rl) {
        this.wt.addRangeListener(rl);
    }

    public Painter getPainter() {
        return this.painter;
    }

    WorldTransform getWorldTransform() {
        return this.wt;
    }

    public void prependHandler(MouseHandler mhandler) {
        this.mouse.prependHandler(mhandler);
    }

    public void setClickListener(ClickListener cl) {
        this.mouse.setClickListener(cl);
    }

    public void setRotationListener(RotationListener rl) {
        this.wt.setRotationListener(rl);
    }

    public void addWorldHandlers() {
        this.panHandler = new PanHandler();
        this.addHandler(this.panHandler);
        this.clickZoomHandler = new ClickZoomHandler();
        this.addHandler(this.clickZoomHandler);
        this.boxSelectionHandler = new BoxSelectionHandler();
        this.addHandler(this.boxSelectionHandler);
        this.turnZoomHandler = new TurnZoomHandler();
        this.addHandler(this.turnZoomHandler);
        this.rollHandler = new RollHandler();
        this.addHandler(this.rollHandler);
        this.turntableHandler = new TurntableHandler();
        this.addHandler(this.turntableHandler);
        MouseHandler[] ha = new MouseHandler[]{this.panHandler, this.clickZoomHandler, this.boxSelectionHandler, this.turnZoomHandler, this.rollHandler, this.turntableHandler};
        this.handlers = ha;
    }

    public void setMouseMode(String s) {
        int i = 0;
        while (i < this.handlers.length) {
            this.handlers[i].deactivate();
            ++i;
        }
        if (s == null) {
            E.error("null mouse mode ");
        } else if (s.equals(MULTI)) {
            i = 0;
            while (i < this.handlers.length) {
                this.handlers[i].activate();
                ++i;
            }
        } else if (s.equals(PAN)) {
            this.panHandler.simpleActivate();
        } else if (s.equals(ZOOM)) {
            this.clickZoomHandler.activateInOut();
        } else if (s.equals(BOX)) {
            this.boxSelectionHandler.simpleActivate();
        } else if (s.equals(ROLL)) {
            this.rollHandler.simpleActivate();
        } else if (s.equals(TURN)) {
            this.turntableHandler.simpleActivate();
        } else if (s.equals(ZOOMIN)) {
            this.clickZoomHandler.activateIn();
        } else if (s.equals(ZOOMOUT)) {
            this.clickZoomHandler.activateOut();
        } else {
            E.error("unhandled mouse mode " + s);
        }
    }

    public void setXRange(double[] lh) {
        this.setXRange(lh[0], lh[1]);
    }

    public void setYRange(double[] lh) {
        this.setYRange(lh[0], lh[1]);
    }

    public void ensureCovers(double[] xr, double[] yr) {
        this.wt.ensureCovers(xr[0], yr[0], xr[1], yr[1]);
        this.wt.notifyRangeChange();
    }

    public void setXRange(double low, double high) {
        this.wt.setXRange(low, high);
        this.wt.notifyRangeChange();
    }

    public void setYRange(double low, double high) {
        this.wt.setYRange(low, high);
        this.wt.notifyRangeChange();
    }

    public void setFixedAspectRatio(double ar) {
        this.wt.setFixedAspectRatio(ar);
    }

    public double[] getXRange() {
        return this.wt.getXRange();
    }

    public double[] getYRange() {
        return this.wt.getYRange();
    }

    public void viewAction(String s) {
        if (s.equals("frame")) {
            this.reframe();
        }
    }

    public void addHandler(MouseHandler mh) {
        this.mouse.addHandler(mh);
    }

    public void fixRanges() {
        this.wt.fixRanges();
    }

    public void setPaintInstructor(PaintInstructor pi) {
        this.paintInstructor = pi;
    }

    @Override
    public void paintComponent(Graphics g0) {
        this.wt.setWidth(this.getWidth());
        this.wt.setHeight(this.getHeight());
        g0.setColor(this.getDataBackground());
        g0.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g = (Graphics2D)g0;
        this.painter.setGraphics(g);
        this.prePaint(g);
        this.paint2D(g);
        this.postPaint(g);
        this.mouse.echoPaint(g);
    }

    public void prePaint(Graphics2D g) {
    }

    public void postPaint(Graphics2D g) {
    }

    public void applyAAPreference(Graphics2D g) {
        if (this.antialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    @Override
    public void paint2D(Graphics2D g) {
        E.info("pw oainting ");
        if (this.paintInstructor != null) {
            this.applyAAPreference(g);
            this.paintInstructor.instruct(this.painter);
        }
    }

    void boxSelected(int x0, int y0, int x1, int y1) {
        this.wt.setCanvasSize(this.getWidth(), this.getHeight());
        this.wt.boxSelected(x0, y0, x1, y1);
        this.repaint();
    }

    void initializeZoom(int xc, int yc) {
        this.wt.initializeZoom(xc, yc);
    }

    void dragZoom(double fx, double fy, int xc, int yc) {
        this.antialias = false;
        this.wt.dragZoom(fx, fy, xc, yc);
    }

    void zoom(double fac, int xc, int yc) {
        this.wt.zoom(fac, xc, yc);
        this.repaint();
    }

    void zoom(double xfac, double yfac, int xc, int yc) {
        this.wt.zoom(xfac, yfac, xc, yc);
        this.repaint();
    }

    void trialPan(int xfrom, int yfrom, int xto, int yto) {
        this.antialias = false;
        this.wt.trialPan(xfrom, yfrom, xto, yto);
        this.repaint();
    }

    void permanentPan(int xfrom, int yfrom, int xto, int yto) {
        this.wt.permanentPan(xfrom, yfrom, xto, yto);
        this.repaint();
    }

    void dragRollRotate(int px, int py) {
        this.antialias = false;
        this.wt.dragRollRotate(px, py);
        this.repaint();
    }

    void dragZRotate(int px, int py) {
        this.antialias = false;
        this.wt.dragZRotate(px, py);
        this.repaint();
    }

    public void turn(double d) {
        this.wt.initializeRotation(this.getWidth() / 2, this.getHeight() / 2);
        this.wt.zRotate(d / 180.0 * Math.PI);
        this.repaint();
    }

    void initializeRotation(int px, int py) {
        this.wt.initializeRotation(px, py);
    }

    void initializeRotation(double x, double y, double z) {
        this.wt.initializeRotationLocal(x, y, z);
    }

    public void setColorRange(double cmin, double cmax) {
        this.painter.setColorRange(cmin, cmax);
    }

    public void setColorTable(Color[] ac) {
        this.painter.setColorTable(ac);
    }

    public int[] getIntPosition(Position pos) {
        return this.wt.getIntPosition(pos.getX(), pos.getY());
    }

    public double[][] getProjectionMatrix() {
        return this.wt.getProjectionMatrix();
    }

    public void setRollCenter(double x, double y, double z) {
        this.rollHandler.setRollCenter(x, y, z);
    }

    public double[] get2Center() {
        return this.wt.get2Center();
    }

    public double[] get3Center() {
        return this.wt.get3Center();
    }

    public double[] getFourMatrix() {
        double[][] pm = this.wt.getProjectionMatrix();
        double[] cen2 = this.wt.get2Center();
        double[] ret = new double[16];
        double sf = 3.0 * this.wt.getScale();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                ret[4 * i + j] = sf * pm[i][j];
                ++j;
            }
            ret[4 * i + 3] = cen2[i];
            ++i;
        }
        ret[15] = 1.0;
        return ret;
    }

    public void setFourMatrix(double[] fm) {
        double[][] pm = new double[3][3];
        double[] cen = new double[3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                pm[i][j] = fm[4 * i + j];
                ++j;
            }
            cen[i] = fm[4 * i + 3];
            ++i;
        }
        double m3xx = pm[0][0];
        double m3xy = pm[0][1];
        double m3xz = pm[0][2];
        double m3yx = pm[1][0];
        double m3yy = pm[1][1];
        double m3yz = pm[1][2];
        double m3zx = pm[2][0];
        double m3zy = pm[2][1];
        double m3zz = pm[2][2];
        double det = m3xx * (m3yy * m3zz - m3zy * m3yz) - m3xy * (m3yx * m3zz - m3zx * m3yz) + m3xz * (m3yx * m3zy - m3zx * m3yy);
        double rdet = Math.pow(det, 0.3333333333333333);
        int i2 = 0;
        while (i2 < 3) {
            int j = 0;
            while (j < 3) {
                double[] dArray = pm[i2];
                int n = j++;
                dArray[n] = dArray[n] / rdet;
            }
            ++i2;
        }
        double[] c0 = new double[]{0.0, 0.0, 0.0};
        int i3 = 0;
        while (i3 < 3) {
            int n = i3++;
            cen[n] = cen[n] / rdet;
        }
        this.wt.setProjectionMatrix(pm);
        this.wt.set3Center(c0);
        this.wt.set2Center(cen);
        this.wt.setScale(0.3 * rdet);
        this.repaint();
    }
}

