/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.content;

import org.catacomb.be.Direction;
import org.catacomb.be.Position;

public class Polypoint {
    public double[] xpts;
    public double[] ypts;
    public static final int OPEN = 0;
    public static final int CLOSED = 1;
    public static final int FILLED = 2;
    public String closure;
    private int p_closure;
    public static final String[] p_closureNames = new String[]{"open", "closed", "filled"};

    public Polypoint() {
        this.xpts = new double[2];
        this.ypts = new double[2];
    }

    public Polypoint(double[] xp, double[] yp) {
        this(xp, yp, 0);
    }

    public Polypoint(double[] xp, double[] yp, int icl) {
        this.xpts = xp;
        this.ypts = yp;
        this.p_closure = icl;
    }

    public String exportAsString() {
        StringBuffer sb = new StringBuffer();
        sb.append("pp(" + this.xpts.length + ": ");
        int i = 0;
        while (i < this.xpts.length) {
            sb.append(String.valueOf(this.xpts[i]) + ", " + this.ypts[i] + ", ");
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public int getClosure() {
        return this.p_closure;
    }

    public void setClosure(int pc) {
        this.p_closure = pc;
        this.closure = p_closureNames[this.p_closure];
    }

    public boolean isFilled() {
        return this.p_closure == 2;
    }

    public boolean isOpen() {
        return this.p_closure == 0;
    }

    public boolean isClosed() {
        return this.p_closure == 1 || this.p_closure == 2;
    }

    public void setXpts(double[] d) {
        this.xpts = d;
    }

    public void setYpts(double[] d) {
        this.ypts = d;
    }

    public double[] getXPts() {
        return this.xpts;
    }

    public double[] getYPts() {
        return this.ypts;
    }

    public Polypoint getCopy() {
        int np = this.xpts.length;
        double[] xp = new double[np];
        double[] yp = new double[np];
        int i = 0;
        while (i < np) {
            xp[i] = this.xpts[i];
            yp[i] = this.ypts[i];
            ++i;
        }
        return new Polypoint(xp, yp, this.p_closure);
    }

    public void translate(Position pos) {
        double dx = pos.getX();
        double dy = pos.getY();
        int i = 0;
        while (i < this.xpts.length) {
            int n = i;
            this.xpts[n] = this.xpts[n] + dx;
            int n2 = i++;
            this.ypts[n2] = this.ypts[n2] + dy;
        }
    }

    public void rotate(Direction dir) {
        double c = dir.getCosine();
        double s = dir.getSine();
        int i = 0;
        while (i < this.xpts.length) {
            double x = this.xpts[i];
            double y = this.ypts[i];
            this.xpts[i] = c * x - s * y;
            this.ypts[i] = s * x + c * y;
            ++i;
        }
    }
}

