/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import java.lang.reflect.Field;
import org.catacomb.datalish.Box;
import org.catacomb.datalish.SceneConfig;
import org.catacomb.datalish.SpritePlacement;
import org.catacomb.datalish.SpriteStore;
import org.catacomb.numeric.data.BlockStack;
import org.catacomb.numeric.data.SpriteAnim;
import org.catacomb.numeric.data.StackSingleSlice;
import org.catacomb.report.E;

public class AnimSlice
extends StackSingleSlice
implements SpriteAnim {
    SceneConfig[] data;
    double[] times;
    int npcache;
    SpriteStore spriteStore;

    public AnimSlice(BlockStack bs, String fnm, Field f, String t, SpriteStore ss) {
        super(bs, fnm, f, null, t);
        this.spriteStore = ss;
        this.npcache = 0;
        this.data = new SceneConfig[10];
        this.times = new double[10];
    }

    @Override
    public SpriteStore getSpriteStore() {
        return this.spriteStore;
    }

    @Override
    public SceneConfig getSceneConfig(int ip) {
        int np = this.blockStack.getSize();
        if (np > this.data.length) {
            int nn = np + np / 2 + 10;
            SceneConfig[] dn = new SceneConfig[nn];
            int i = 0;
            while (i < this.npcache) {
                dn[i] = this.data[i];
                ++i;
            }
            this.data = dn;
        }
        SceneConfig ret = null;
        if (ip < np && (ret = this.data[ip]) == null) {
            try {
                this.data[ip] = ret = (SceneConfig)this.field.get(this.blockStack.getBlock(ip));
                if (this.npcache < ip) {
                    this.npcache = ip;
                }
            }
            catch (Exception ex) {
                E.error("exception reading slice from block stack " + this + " " + ex);
            }
        }
        return ret;
    }

    @Override
    void clearCache() {
        this.npcache = 0;
    }

    @Override
    public Box getBox() {
        int np = this.blockStack.getSize();
        Box box = new Box();
        int ival = 1 + np / 20;
        int i = 0;
        while (i < np) {
            SpritePlacement[] spritePlacementArray = this.getSceneConfig(i).getPlacements();
            int n = spritePlacementArray.length;
            int n2 = 0;
            while (n2 < n) {
                SpritePlacement sp = spritePlacementArray[n2];
                box.push(sp.getPosition());
                ++n2;
            }
            i += ival;
        }
        box.enlarge(0.2);
        return box;
    }

    @Override
    public String getFrameDescription(int ifr) {
        SceneConfig sc = this.getSceneConfig(ifr);
        return String.format("%8.3g", new Double(sc.getTime()));
    }
}

